package io.fabric8.openshift.api.model.machineconfig.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class MachineConfigPoolBuilder extends MachineConfigPoolFluent<MachineConfigPoolBuilder> implements VisitableBuilder<MachineConfigPool,MachineConfigPoolBuilder>{
  public MachineConfigPoolBuilder() {
    this(new MachineConfigPool());
  }
  
  public MachineConfigPoolBuilder(MachineConfigPoolFluent<?> fluent) {
    this(fluent, new MachineConfigPool());
  }
  
  public MachineConfigPoolBuilder(MachineConfigPoolFluent<?> fluent,MachineConfigPool instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public MachineConfigPoolBuilder(MachineConfigPool instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  MachineConfigPoolFluent<?> fluent;
  
  public MachineConfigPool build() {
    MachineConfigPool buildable = new MachineConfigPool(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}