/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.machine.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.machine.v1beta1.DiskEncryptionSetParameters;
import io.fabric8.openshift.api.model.machine.v1beta1.DiskEncryptionSetParametersBuilder;
import io.fabric8.openshift.api.model.machine.v1beta1.DiskEncryptionSetParametersFluent;
import io.fabric8.openshift.api.model.machine.v1beta1.OSDiskManagedDiskParameters;
import io.fabric8.openshift.api.model.machine.v1beta1.VMDiskSecurityProfile;
import io.fabric8.openshift.api.model.machine.v1beta1.VMDiskSecurityProfileBuilder;
import io.fabric8.openshift.api.model.machine.v1beta1.VMDiskSecurityProfileFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class OSDiskManagedDiskParametersFluent<A extends OSDiskManagedDiskParametersFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private DiskEncryptionSetParametersBuilder diskEncryptionSet;
    private VMDiskSecurityProfileBuilder securityProfile;
    private String storageAccountType;

    public OSDiskManagedDiskParametersFluent() {
    }

    public OSDiskManagedDiskParametersFluent(OSDiskManagedDiskParameters instance) {
        this.copyInstance(instance);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public DiskEncryptionSetParameters buildDiskEncryptionSet() {
        return this.diskEncryptionSet != null ? this.diskEncryptionSet.build() : null;
    }

    public VMDiskSecurityProfile buildSecurityProfile() {
        return this.securityProfile != null ? this.securityProfile.build() : null;
    }

    protected void copyInstance(OSDiskManagedDiskParameters instance) {
        OSDiskManagedDiskParameters oSDiskManagedDiskParameters = instance = instance != null ? instance : new OSDiskManagedDiskParameters();
        if (instance != null) {
            this.withDiskEncryptionSet(instance.getDiskEncryptionSet());
            this.withSecurityProfile(instance.getSecurityProfile());
            this.withStorageAccountType(instance.getStorageAccountType());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public DiskEncryptionSetNested<A> editDiskEncryptionSet() {
        return this.withNewDiskEncryptionSetLike(Optional.ofNullable(this.buildDiskEncryptionSet()).orElse(null));
    }

    public DiskEncryptionSetNested<A> editOrNewDiskEncryptionSet() {
        return this.withNewDiskEncryptionSetLike(Optional.ofNullable(this.buildDiskEncryptionSet()).orElse(new DiskEncryptionSetParametersBuilder().build()));
    }

    public DiskEncryptionSetNested<A> editOrNewDiskEncryptionSetLike(DiskEncryptionSetParameters item) {
        return this.withNewDiskEncryptionSetLike(Optional.ofNullable(this.buildDiskEncryptionSet()).orElse(item));
    }

    public SecurityProfileNested<A> editOrNewSecurityProfile() {
        return this.withNewSecurityProfileLike(Optional.ofNullable(this.buildSecurityProfile()).orElse(new VMDiskSecurityProfileBuilder().build()));
    }

    public SecurityProfileNested<A> editOrNewSecurityProfileLike(VMDiskSecurityProfile item) {
        return this.withNewSecurityProfileLike(Optional.ofNullable(this.buildSecurityProfile()).orElse(item));
    }

    public SecurityProfileNested<A> editSecurityProfile() {
        return this.withNewSecurityProfileLike(Optional.ofNullable(this.buildSecurityProfile()).orElse(null));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OSDiskManagedDiskParametersFluent that = (OSDiskManagedDiskParametersFluent)((Object)o);
        if (!Objects.equals((Object)this.diskEncryptionSet, (Object)that.diskEncryptionSet)) {
            return false;
        }
        if (!Objects.equals((Object)this.securityProfile, (Object)that.securityProfile)) {
            return false;
        }
        if (!Objects.equals(this.storageAccountType, that.storageAccountType)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getStorageAccountType() {
        return this.storageAccountType;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasDiskEncryptionSet() {
        return this.diskEncryptionSet != null;
    }

    public boolean hasSecurityProfile() {
        return this.securityProfile != null;
    }

    public boolean hasStorageAccountType() {
        return this.storageAccountType != null;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.diskEncryptionSet, this.securityProfile, this.storageAccountType, this.additionalProperties});
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.diskEncryptionSet != null) {
            sb.append("diskEncryptionSet:");
            sb.append((Object)this.diskEncryptionSet);
            sb.append(",");
        }
        if (this.securityProfile != null) {
            sb.append("securityProfile:");
            sb.append((Object)this.securityProfile);
            sb.append(",");
        }
        if (this.storageAccountType != null) {
            sb.append("storageAccountType:");
            sb.append(this.storageAccountType);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withDiskEncryptionSet(DiskEncryptionSetParameters diskEncryptionSet) {
        this._visitables.remove((Object)"diskEncryptionSet");
        if (diskEncryptionSet != null) {
            this.diskEncryptionSet = new DiskEncryptionSetParametersBuilder(diskEncryptionSet);
            this._visitables.get((Object)"diskEncryptionSet").add(this.diskEncryptionSet);
        } else {
            this.diskEncryptionSet = null;
            this._visitables.get((Object)"diskEncryptionSet").remove((Object)this.diskEncryptionSet);
        }
        return (A)((Object)this);
    }

    public DiskEncryptionSetNested<A> withNewDiskEncryptionSet() {
        return new DiskEncryptionSetNested(null);
    }

    public A withNewDiskEncryptionSet(String id) {
        return this.withDiskEncryptionSet(new DiskEncryptionSetParameters(id));
    }

    public DiskEncryptionSetNested<A> withNewDiskEncryptionSetLike(DiskEncryptionSetParameters item) {
        return new DiskEncryptionSetNested(item);
    }

    public SecurityProfileNested<A> withNewSecurityProfile() {
        return new SecurityProfileNested(null);
    }

    public SecurityProfileNested<A> withNewSecurityProfileLike(VMDiskSecurityProfile item) {
        return new SecurityProfileNested(item);
    }

    public A withSecurityProfile(VMDiskSecurityProfile securityProfile) {
        this._visitables.remove((Object)"securityProfile");
        if (securityProfile != null) {
            this.securityProfile = new VMDiskSecurityProfileBuilder(securityProfile);
            this._visitables.get((Object)"securityProfile").add(this.securityProfile);
        } else {
            this.securityProfile = null;
            this._visitables.get((Object)"securityProfile").remove((Object)this.securityProfile);
        }
        return (A)((Object)this);
    }

    public A withStorageAccountType(String storageAccountType) {
        this.storageAccountType = storageAccountType;
        return (A)((Object)this);
    }

    public class SecurityProfileNested<N>
    extends VMDiskSecurityProfileFluent<SecurityProfileNested<N>>
    implements Nested<N> {
        VMDiskSecurityProfileBuilder builder;

        SecurityProfileNested(VMDiskSecurityProfile item) {
            this.builder = new VMDiskSecurityProfileBuilder(this, item);
        }

        public N and() {
            return (N)OSDiskManagedDiskParametersFluent.this.withSecurityProfile(this.builder.build());
        }

        public N endSecurityProfile() {
            return this.and();
        }
    }

    public class DiskEncryptionSetNested<N>
    extends DiskEncryptionSetParametersFluent<DiskEncryptionSetNested<N>>
    implements Nested<N> {
        DiskEncryptionSetParametersBuilder builder;

        DiskEncryptionSetNested(DiskEncryptionSetParameters item) {
            this.builder = new DiskEncryptionSetParametersBuilder(this, item);
        }

        public N and() {
            return (N)OSDiskManagedDiskParametersFluent.this.withDiskEncryptionSet(this.builder.build());
        }

        public N endDiskEncryptionSet() {
            return this.and();
        }
    }
}

