/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.machine.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.machine.v1beta1.NetworkDeviceSpec;
import io.fabric8.openshift.api.model.machine.v1beta1.NetworkDeviceSpecBuilder;
import io.fabric8.openshift.api.model.machine.v1beta1.NetworkDeviceSpecFluent;
import io.fabric8.openshift.api.model.machine.v1beta1.NetworkSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class NetworkSpecFluent<A extends NetworkSpecFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private ArrayList<NetworkDeviceSpecBuilder> devices = new ArrayList();

    public NetworkSpecFluent() {
    }

    public NetworkSpecFluent(NetworkSpec instance) {
        this.copyInstance(instance);
    }

    public A addAllToDevices(Collection<NetworkDeviceSpec> items) {
        if (this.devices == null) {
            this.devices = new ArrayList();
        }
        for (NetworkDeviceSpec item : items) {
            NetworkDeviceSpecBuilder builder = new NetworkDeviceSpecBuilder(item);
            this._visitables.get((Object)"devices").add(builder);
            this.devices.add(builder);
        }
        return (A)((Object)this);
    }

    public DevicesNested<A> addNewDevice() {
        return new DevicesNested(-1, null);
    }

    public DevicesNested<A> addNewDeviceLike(NetworkDeviceSpec item) {
        return new DevicesNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToDevices(NetworkDeviceSpec ... items) {
        if (this.devices == null) {
            this.devices = new ArrayList();
        }
        for (NetworkDeviceSpec item : items) {
            NetworkDeviceSpecBuilder builder = new NetworkDeviceSpecBuilder(item);
            this._visitables.get((Object)"devices").add(builder);
            this.devices.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToDevices(int index, NetworkDeviceSpec item) {
        if (this.devices == null) {
            this.devices = new ArrayList();
        }
        NetworkDeviceSpecBuilder builder = new NetworkDeviceSpecBuilder(item);
        if (index < 0 || index >= this.devices.size()) {
            this._visitables.get((Object)"devices").add(builder);
            this.devices.add(builder);
        } else {
            this._visitables.get((Object)"devices").add(builder);
            this.devices.add(index, builder);
        }
        return (A)((Object)this);
    }

    public NetworkDeviceSpec buildDevice(int index) {
        return this.devices.get(index).build();
    }

    public List<NetworkDeviceSpec> buildDevices() {
        return this.devices != null ? NetworkSpecFluent.build(this.devices) : null;
    }

    public NetworkDeviceSpec buildFirstDevice() {
        return this.devices.get(0).build();
    }

    public NetworkDeviceSpec buildLastDevice() {
        return this.devices.get(this.devices.size() - 1).build();
    }

    public NetworkDeviceSpec buildMatchingDevice(Predicate<NetworkDeviceSpecBuilder> predicate) {
        for (NetworkDeviceSpecBuilder item : this.devices) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    protected void copyInstance(NetworkSpec instance) {
        NetworkSpec networkSpec = instance = instance != null ? instance : new NetworkSpec();
        if (instance != null) {
            this.withDevices(instance.getDevices());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public DevicesNested<A> editDevice(int index) {
        if (this.devices.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "devices"));
        }
        return this.setNewDeviceLike(index, this.buildDevice(index));
    }

    public DevicesNested<A> editFirstDevice() {
        if (this.devices.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "devices"));
        }
        return this.setNewDeviceLike(0, this.buildDevice(0));
    }

    public DevicesNested<A> editLastDevice() {
        int index = this.devices.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "devices"));
        }
        return this.setNewDeviceLike(index, this.buildDevice(index));
    }

    public DevicesNested<A> editMatchingDevice(Predicate<NetworkDeviceSpecBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.devices.size(); ++i) {
            if (!predicate.test(this.devices.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "devices"));
        }
        return this.setNewDeviceLike(index, this.buildDevice(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NetworkSpecFluent that = (NetworkSpecFluent)((Object)o);
        if (!Objects.equals(this.devices, that.devices)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasDevices() {
        return this.devices != null && !this.devices.isEmpty();
    }

    public boolean hasMatchingDevice(Predicate<NetworkDeviceSpecBuilder> predicate) {
        for (NetworkDeviceSpecBuilder item : this.devices) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.devices, this.additionalProperties);
    }

    public A removeAllFromDevices(Collection<NetworkDeviceSpec> items) {
        if (this.devices == null) {
            return (A)((Object)this);
        }
        for (NetworkDeviceSpec item : items) {
            NetworkDeviceSpecBuilder builder = new NetworkDeviceSpecBuilder(item);
            this._visitables.get((Object)"devices").remove((Object)builder);
            this.devices.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromDevices(NetworkDeviceSpec ... items) {
        if (this.devices == null) {
            return (A)((Object)this);
        }
        for (NetworkDeviceSpec item : items) {
            NetworkDeviceSpecBuilder builder = new NetworkDeviceSpecBuilder(item);
            this._visitables.get((Object)"devices").remove((Object)builder);
            this.devices.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromDevices(Predicate<NetworkDeviceSpecBuilder> predicate) {
        if (this.devices == null) {
            return (A)((Object)this);
        }
        Iterator<NetworkDeviceSpecBuilder> each = this.devices.iterator();
        List visitables = this._visitables.get((Object)"devices");
        while (each.hasNext()) {
            NetworkDeviceSpecBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public DevicesNested<A> setNewDeviceLike(int index, NetworkDeviceSpec item) {
        return new DevicesNested(index, item);
    }

    public A setToDevices(int index, NetworkDeviceSpec item) {
        if (this.devices == null) {
            this.devices = new ArrayList();
        }
        NetworkDeviceSpecBuilder builder = new NetworkDeviceSpecBuilder(item);
        if (index < 0 || index >= this.devices.size()) {
            this._visitables.get((Object)"devices").add(builder);
            this.devices.add(builder);
        } else {
            this._visitables.get((Object)"devices").add(builder);
            this.devices.set(index, builder);
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.devices != null && !this.devices.isEmpty()) {
            sb.append("devices:");
            sb.append(this.devices);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withDevices(List<NetworkDeviceSpec> devices) {
        if (this.devices != null) {
            this._visitables.get((Object)"devices").clear();
        }
        if (devices != null) {
            this.devices = new ArrayList();
            for (NetworkDeviceSpec item : devices) {
                this.addToDevices(item);
            }
        } else {
            this.devices = null;
        }
        return (A)((Object)this);
    }

    public A withDevices(NetworkDeviceSpec ... devices) {
        if (this.devices != null) {
            this.devices.clear();
            this._visitables.remove((Object)"devices");
        }
        if (devices != null) {
            for (NetworkDeviceSpec item : devices) {
                this.addToDevices(item);
            }
        }
        return (A)((Object)this);
    }

    public class DevicesNested<N>
    extends NetworkDeviceSpecFluent<DevicesNested<N>>
    implements Nested<N> {
        NetworkDeviceSpecBuilder builder;
        int index;

        DevicesNested(int index, NetworkDeviceSpec item) {
            this.index = index;
            this.builder = new NetworkDeviceSpecBuilder(this, item);
        }

        public N and() {
            return (N)NetworkSpecFluent.this.setToDevices(this.index, this.builder.build());
        }

        public N endDevice() {
            return this.and();
        }
    }
}

