/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.machine.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import io.fabric8.openshift.api.model.machine.v1beta1.MachineSetSpec;
import io.fabric8.openshift.api.model.machine.v1beta1.MachineTemplateSpec;
import io.fabric8.openshift.api.model.machine.v1beta1.MachineTemplateSpecBuilder;
import io.fabric8.openshift.api.model.machine.v1beta1.MachineTemplateSpecFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class MachineSetSpecFluent<A extends MachineSetSpecFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private String authoritativeAPI;
    private String deletePolicy;
    private Integer minReadySeconds;
    private Integer replicas;
    private LabelSelectorBuilder selector;
    private MachineTemplateSpecBuilder template;

    public MachineSetSpecFluent() {
    }

    public MachineSetSpecFluent(MachineSetSpec instance) {
        this.copyInstance(instance);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public LabelSelector buildSelector() {
        return this.selector != null ? this.selector.build() : null;
    }

    public MachineTemplateSpec buildTemplate() {
        return this.template != null ? this.template.build() : null;
    }

    protected void copyInstance(MachineSetSpec instance) {
        MachineSetSpec machineSetSpec = instance = instance != null ? instance : new MachineSetSpec();
        if (instance != null) {
            this.withAuthoritativeAPI(instance.getAuthoritativeAPI());
            this.withDeletePolicy(instance.getDeletePolicy());
            this.withMinReadySeconds(instance.getMinReadySeconds());
            this.withReplicas(instance.getReplicas());
            this.withSelector(instance.getSelector());
            this.withTemplate(instance.getTemplate());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public SelectorNested<A> editOrNewSelector() {
        return this.withNewSelectorLike(Optional.ofNullable(this.buildSelector()).orElse(new LabelSelectorBuilder().build()));
    }

    public SelectorNested<A> editOrNewSelectorLike(LabelSelector item) {
        return this.withNewSelectorLike(Optional.ofNullable(this.buildSelector()).orElse(item));
    }

    public TemplateNested<A> editOrNewTemplate() {
        return this.withNewTemplateLike(Optional.ofNullable(this.buildTemplate()).orElse(new MachineTemplateSpecBuilder().build()));
    }

    public TemplateNested<A> editOrNewTemplateLike(MachineTemplateSpec item) {
        return this.withNewTemplateLike(Optional.ofNullable(this.buildTemplate()).orElse(item));
    }

    public SelectorNested<A> editSelector() {
        return this.withNewSelectorLike(Optional.ofNullable(this.buildSelector()).orElse(null));
    }

    public TemplateNested<A> editTemplate() {
        return this.withNewTemplateLike(Optional.ofNullable(this.buildTemplate()).orElse(null));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MachineSetSpecFluent that = (MachineSetSpecFluent)((Object)o);
        if (!Objects.equals(this.authoritativeAPI, that.authoritativeAPI)) {
            return false;
        }
        if (!Objects.equals(this.deletePolicy, that.deletePolicy)) {
            return false;
        }
        if (!Objects.equals(this.minReadySeconds, that.minReadySeconds)) {
            return false;
        }
        if (!Objects.equals(this.replicas, that.replicas)) {
            return false;
        }
        if (!Objects.equals(this.selector, that.selector)) {
            return false;
        }
        if (!Objects.equals((Object)this.template, (Object)that.template)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getAuthoritativeAPI() {
        return this.authoritativeAPI;
    }

    public String getDeletePolicy() {
        return this.deletePolicy;
    }

    public Integer getMinReadySeconds() {
        return this.minReadySeconds;
    }

    public Integer getReplicas() {
        return this.replicas;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasAuthoritativeAPI() {
        return this.authoritativeAPI != null;
    }

    public boolean hasDeletePolicy() {
        return this.deletePolicy != null;
    }

    public boolean hasMinReadySeconds() {
        return this.minReadySeconds != null;
    }

    public boolean hasReplicas() {
        return this.replicas != null;
    }

    public boolean hasSelector() {
        return this.selector != null;
    }

    public boolean hasTemplate() {
        return this.template != null;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.authoritativeAPI, this.deletePolicy, this.minReadySeconds, this.replicas, this.selector, this.template, this.additionalProperties});
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.authoritativeAPI != null) {
            sb.append("authoritativeAPI:");
            sb.append(this.authoritativeAPI);
            sb.append(",");
        }
        if (this.deletePolicy != null) {
            sb.append("deletePolicy:");
            sb.append(this.deletePolicy);
            sb.append(",");
        }
        if (this.minReadySeconds != null) {
            sb.append("minReadySeconds:");
            sb.append(this.minReadySeconds);
            sb.append(",");
        }
        if (this.replicas != null) {
            sb.append("replicas:");
            sb.append(this.replicas);
            sb.append(",");
        }
        if (this.selector != null) {
            sb.append("selector:");
            sb.append(this.selector);
            sb.append(",");
        }
        if (this.template != null) {
            sb.append("template:");
            sb.append((Object)this.template);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withAuthoritativeAPI(String authoritativeAPI) {
        this.authoritativeAPI = authoritativeAPI;
        return (A)((Object)this);
    }

    public A withDeletePolicy(String deletePolicy) {
        this.deletePolicy = deletePolicy;
        return (A)((Object)this);
    }

    public A withMinReadySeconds(Integer minReadySeconds) {
        this.minReadySeconds = minReadySeconds;
        return (A)((Object)this);
    }

    public SelectorNested<A> withNewSelector() {
        return new SelectorNested(null);
    }

    public SelectorNested<A> withNewSelectorLike(LabelSelector item) {
        return new SelectorNested(item);
    }

    public TemplateNested<A> withNewTemplate() {
        return new TemplateNested(null);
    }

    public TemplateNested<A> withNewTemplateLike(MachineTemplateSpec item) {
        return new TemplateNested(item);
    }

    public A withReplicas(Integer replicas) {
        this.replicas = replicas;
        return (A)((Object)this);
    }

    public A withSelector(LabelSelector selector) {
        this._visitables.remove((Object)"selector");
        if (selector != null) {
            this.selector = new LabelSelectorBuilder(selector);
            this._visitables.get((Object)"selector").add(this.selector);
        } else {
            this.selector = null;
            this._visitables.get((Object)"selector").remove(this.selector);
        }
        return (A)((Object)this);
    }

    public A withTemplate(MachineTemplateSpec template) {
        this._visitables.remove((Object)"template");
        if (template != null) {
            this.template = new MachineTemplateSpecBuilder(template);
            this._visitables.get((Object)"template").add(this.template);
        } else {
            this.template = null;
            this._visitables.get((Object)"template").remove((Object)this.template);
        }
        return (A)((Object)this);
    }

    public class TemplateNested<N>
    extends MachineTemplateSpecFluent<TemplateNested<N>>
    implements Nested<N> {
        MachineTemplateSpecBuilder builder;

        TemplateNested(MachineTemplateSpec item) {
            this.builder = new MachineTemplateSpecBuilder(this, item);
        }

        public N and() {
            return (N)MachineSetSpecFluent.this.withTemplate(this.builder.build());
        }

        public N endTemplate() {
            return this.and();
        }
    }

    public class SelectorNested<N>
    extends LabelSelectorFluent<SelectorNested<N>>
    implements Nested<N> {
        LabelSelectorBuilder builder;

        SelectorNested(LabelSelector item) {
            this.builder = new LabelSelectorBuilder((LabelSelectorFluent)this, item);
        }

        public N and() {
            return (N)MachineSetSpecFluent.this.withSelector(this.builder.build());
        }

        public N endSelector() {
            return this.and();
        }
    }
}

