/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.machine.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.machine.v1alpha1.SubnetFilter;
import io.fabric8.openshift.api.model.machine.v1alpha1.SubnetFilterBuilder;
import io.fabric8.openshift.api.model.machine.v1alpha1.SubnetFilterFluent;
import io.fabric8.openshift.api.model.machine.v1alpha1.SubnetParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class SubnetParamFluent<A extends SubnetParamFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private SubnetFilterBuilder filter;
    private Boolean portSecurity;
    private List<String> portTags = new ArrayList<String>();
    private String uuid;

    public SubnetParamFluent() {
    }

    public SubnetParamFluent(SubnetParam instance) {
        this.copyInstance(instance);
    }

    public A addAllToPortTags(Collection<String> items) {
        if (this.portTags == null) {
            this.portTags = new ArrayList<String>();
        }
        for (String item : items) {
            this.portTags.add(item);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToPortTags(String ... items) {
        if (this.portTags == null) {
            this.portTags = new ArrayList<String>();
        }
        for (String item : items) {
            this.portTags.add(item);
        }
        return (A)((Object)this);
    }

    public A addToPortTags(int index, String item) {
        if (this.portTags == null) {
            this.portTags = new ArrayList<String>();
        }
        this.portTags.add(index, item);
        return (A)((Object)this);
    }

    public SubnetFilter buildFilter() {
        return this.filter != null ? this.filter.build() : null;
    }

    protected void copyInstance(SubnetParam instance) {
        SubnetParam subnetParam = instance = instance != null ? instance : new SubnetParam();
        if (instance != null) {
            this.withFilter(instance.getFilter());
            this.withPortSecurity(instance.getPortSecurity());
            this.withPortTags(instance.getPortTags());
            this.withUuid(instance.getUuid());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public FilterNested<A> editFilter() {
        return this.withNewFilterLike(Optional.ofNullable(this.buildFilter()).orElse(null));
    }

    public FilterNested<A> editOrNewFilter() {
        return this.withNewFilterLike(Optional.ofNullable(this.buildFilter()).orElse(new SubnetFilterBuilder().build()));
    }

    public FilterNested<A> editOrNewFilterLike(SubnetFilter item) {
        return this.withNewFilterLike(Optional.ofNullable(this.buildFilter()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SubnetParamFluent that = (SubnetParamFluent)((Object)o);
        if (!Objects.equals((Object)this.filter, (Object)that.filter)) {
            return false;
        }
        if (!Objects.equals(this.portSecurity, that.portSecurity)) {
            return false;
        }
        if (!Objects.equals(this.portTags, that.portTags)) {
            return false;
        }
        if (!Objects.equals(this.uuid, that.uuid)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getFirstPortTag() {
        return this.portTags.get(0);
    }

    public String getLastPortTag() {
        return this.portTags.get(this.portTags.size() - 1);
    }

    public String getMatchingPortTag(Predicate<String> predicate) {
        for (String item : this.portTags) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public Boolean getPortSecurity() {
        return this.portSecurity;
    }

    public String getPortTag(int index) {
        return this.portTags.get(index);
    }

    public List<String> getPortTags() {
        return this.portTags;
    }

    public String getUuid() {
        return this.uuid;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasFilter() {
        return this.filter != null;
    }

    public boolean hasMatchingPortTag(Predicate<String> predicate) {
        for (String item : this.portTags) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasPortSecurity() {
        return this.portSecurity != null;
    }

    public boolean hasPortTags() {
        return this.portTags != null && !this.portTags.isEmpty();
    }

    public boolean hasUuid() {
        return this.uuid != null;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.filter, this.portSecurity, this.portTags, this.uuid, this.additionalProperties});
    }

    public A removeAllFromPortTags(Collection<String> items) {
        if (this.portTags == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.portTags.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromPortTags(String ... items) {
        if (this.portTags == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.portTags.remove(item);
        }
        return (A)((Object)this);
    }

    public A setToPortTags(int index, String item) {
        if (this.portTags == null) {
            this.portTags = new ArrayList<String>();
        }
        this.portTags.set(index, item);
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.filter != null) {
            sb.append("filter:");
            sb.append((Object)this.filter);
            sb.append(",");
        }
        if (this.portSecurity != null) {
            sb.append("portSecurity:");
            sb.append(this.portSecurity);
            sb.append(",");
        }
        if (this.portTags != null && !this.portTags.isEmpty()) {
            sb.append("portTags:");
            sb.append(this.portTags);
            sb.append(",");
        }
        if (this.uuid != null) {
            sb.append("uuid:");
            sb.append(this.uuid);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withFilter(SubnetFilter filter) {
        this._visitables.remove((Object)"filter");
        if (filter != null) {
            this.filter = new SubnetFilterBuilder(filter);
            this._visitables.get((Object)"filter").add(this.filter);
        } else {
            this.filter = null;
            this._visitables.get((Object)"filter").remove((Object)this.filter);
        }
        return (A)((Object)this);
    }

    public FilterNested<A> withNewFilter() {
        return new FilterNested(null);
    }

    public FilterNested<A> withNewFilterLike(SubnetFilter item) {
        return new FilterNested(item);
    }

    public A withPortSecurity() {
        return this.withPortSecurity(true);
    }

    public A withPortSecurity(Boolean portSecurity) {
        this.portSecurity = portSecurity;
        return (A)((Object)this);
    }

    public A withPortTags(List<String> portTags) {
        if (portTags != null) {
            this.portTags = new ArrayList<String>();
            for (String item : portTags) {
                this.addToPortTags(item);
            }
        } else {
            this.portTags = null;
        }
        return (A)((Object)this);
    }

    public A withPortTags(String ... portTags) {
        if (this.portTags != null) {
            this.portTags.clear();
            this._visitables.remove((Object)"portTags");
        }
        if (portTags != null) {
            for (String item : portTags) {
                this.addToPortTags(item);
            }
        }
        return (A)((Object)this);
    }

    public A withUuid(String uuid) {
        this.uuid = uuid;
        return (A)((Object)this);
    }

    public class FilterNested<N>
    extends SubnetFilterFluent<FilterNested<N>>
    implements Nested<N> {
        SubnetFilterBuilder builder;

        FilterNested(SubnetFilter item) {
            this.builder = new SubnetFilterBuilder(this, item);
        }

        public N and() {
            return (N)SubnetParamFluent.this.withFilter(this.builder.build());
        }

        public N endFilter() {
            return this.and();
        }
    }
}

