package io.fabric8.openshift.api.model.machine.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class NetworkSpecFluent<A extends NetworkSpecFluent<A>> extends BaseFluent<A>{
  public NetworkSpecFluent() {
  }
  
  public NetworkSpecFluent(NetworkSpec instance) {
    this.copyInstance(instance);
  }
  private ArrayList<NetworkDeviceSpecBuilder> devices = new ArrayList<NetworkDeviceSpecBuilder>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(NetworkSpec instance) {
    instance = (instance != null ? instance : new NetworkSpec());
    if (instance != null) {
          this.withDevices(instance.getDevices());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToDevices(int index,NetworkDeviceSpec item) {
    if (this.devices == null) {this.devices = new ArrayList<NetworkDeviceSpecBuilder>();}
    NetworkDeviceSpecBuilder builder = new NetworkDeviceSpecBuilder(item);
    if (index < 0 || index >= devices.size()) {
        _visitables.get("devices").add(builder);
        devices.add(builder);
    } else {
        _visitables.get("devices").add(builder);
        devices.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToDevices(int index,NetworkDeviceSpec item) {
    if (this.devices == null) {this.devices = new ArrayList<NetworkDeviceSpecBuilder>();}
    NetworkDeviceSpecBuilder builder = new NetworkDeviceSpecBuilder(item);
    if (index < 0 || index >= devices.size()) {
        _visitables.get("devices").add(builder);
        devices.add(builder);
    } else {
        _visitables.get("devices").add(builder);
        devices.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToDevices(io.fabric8.openshift.api.model.machine.v1beta1.NetworkDeviceSpec... items) {
    if (this.devices == null) {this.devices = new ArrayList<NetworkDeviceSpecBuilder>();}
    for (NetworkDeviceSpec item : items) {NetworkDeviceSpecBuilder builder = new NetworkDeviceSpecBuilder(item);_visitables.get("devices").add(builder);this.devices.add(builder);} return (A)this;
  }
  
  public A addAllToDevices(Collection<NetworkDeviceSpec> items) {
    if (this.devices == null) {this.devices = new ArrayList<NetworkDeviceSpecBuilder>();}
    for (NetworkDeviceSpec item : items) {NetworkDeviceSpecBuilder builder = new NetworkDeviceSpecBuilder(item);_visitables.get("devices").add(builder);this.devices.add(builder);} return (A)this;
  }
  
  public A removeFromDevices(io.fabric8.openshift.api.model.machine.v1beta1.NetworkDeviceSpec... items) {
    if (this.devices == null) return (A)this;
    for (NetworkDeviceSpec item : items) {NetworkDeviceSpecBuilder builder = new NetworkDeviceSpecBuilder(item);_visitables.get("devices").remove(builder); this.devices.remove(builder);} return (A)this;
  }
  
  public A removeAllFromDevices(Collection<NetworkDeviceSpec> items) {
    if (this.devices == null) return (A)this;
    for (NetworkDeviceSpec item : items) {NetworkDeviceSpecBuilder builder = new NetworkDeviceSpecBuilder(item);_visitables.get("devices").remove(builder); this.devices.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromDevices(Predicate<NetworkDeviceSpecBuilder> predicate) {
    if (devices == null) return (A) this;
    final Iterator<NetworkDeviceSpecBuilder> each = devices.iterator();
    final List visitables = _visitables.get("devices");
    while (each.hasNext()) {
      NetworkDeviceSpecBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<NetworkDeviceSpec> buildDevices() {
    return this.devices != null ? build(devices) : null;
  }
  
  public NetworkDeviceSpec buildDevice(int index) {
    return this.devices.get(index).build();
  }
  
  public NetworkDeviceSpec buildFirstDevice() {
    return this.devices.get(0).build();
  }
  
  public NetworkDeviceSpec buildLastDevice() {
    return this.devices.get(devices.size() - 1).build();
  }
  
  public NetworkDeviceSpec buildMatchingDevice(Predicate<NetworkDeviceSpecBuilder> predicate) {
      for (NetworkDeviceSpecBuilder item : devices) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingDevice(Predicate<NetworkDeviceSpecBuilder> predicate) {
      for (NetworkDeviceSpecBuilder item : devices) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withDevices(List<NetworkDeviceSpec> devices) {
    if (this.devices != null) {
      this._visitables.get("devices").clear();
    }
    if (devices != null) {
        this.devices = new ArrayList();
        for (NetworkDeviceSpec item : devices) {
          this.addToDevices(item);
        }
    } else {
      this.devices = null;
    }
    return (A) this;
  }
  
  public A withDevices(io.fabric8.openshift.api.model.machine.v1beta1.NetworkDeviceSpec... devices) {
    if (this.devices != null) {
        this.devices.clear();
        _visitables.remove("devices");
    }
    if (devices != null) {
      for (NetworkDeviceSpec item : devices) {
        this.addToDevices(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasDevices() {
    return this.devices != null && !this.devices.isEmpty();
  }
  
  public DevicesNested<A> addNewDevice() {
    return new DevicesNested(-1, null);
  }
  
  public DevicesNested<A> addNewDeviceLike(NetworkDeviceSpec item) {
    return new DevicesNested(-1, item);
  }
  
  public DevicesNested<A> setNewDeviceLike(int index,NetworkDeviceSpec item) {
    return new DevicesNested(index, item);
  }
  
  public DevicesNested<A> editDevice(int index) {
    if (devices.size() <= index) throw new RuntimeException("Can't edit devices. Index exceeds size.");
    return setNewDeviceLike(index, buildDevice(index));
  }
  
  public DevicesNested<A> editFirstDevice() {
    if (devices.size() == 0) throw new RuntimeException("Can't edit first devices. The list is empty.");
    return setNewDeviceLike(0, buildDevice(0));
  }
  
  public DevicesNested<A> editLastDevice() {
    int index = devices.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last devices. The list is empty.");
    return setNewDeviceLike(index, buildDevice(index));
  }
  
  public DevicesNested<A> editMatchingDevice(Predicate<NetworkDeviceSpecBuilder> predicate) {
    int index = -1;
    for (int i=0;i<devices.size();i++) { 
    if (predicate.test(devices.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching devices. No match found.");
    return setNewDeviceLike(index, buildDevice(index));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    NetworkSpecFluent that = (NetworkSpecFluent) o;
    if (!java.util.Objects.equals(devices, that.devices)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(devices,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (devices != null && !devices.isEmpty()) { sb.append("devices:"); sb.append(devices + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class DevicesNested<N> extends NetworkDeviceSpecFluent<DevicesNested<N>> implements Nested<N>{
    DevicesNested(int index,NetworkDeviceSpec item) {
      this.index = index;
      this.builder = new NetworkDeviceSpecBuilder(this, item);
    }
    NetworkDeviceSpecBuilder builder;
    int index;
    
    public N and() {
      return (N) NetworkSpecFluent.this.setToDevices(index,builder.build());
    }
    
    public N endDevice() {
      return and();
    }
    
  
  }

}