package io.fabric8.openshift.api.model.machine.v1;

import io.fabric8.kubernetes.api.model.Condition;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class NutanixMachineProviderStatusFluent<A extends NutanixMachineProviderStatusFluent<A>> extends BaseFluent<A>{
  public NutanixMachineProviderStatusFluent() {
  }
  
  public NutanixMachineProviderStatusFluent(NutanixMachineProviderStatus instance) {
    this.copyInstance(instance);
  }
  private String apiVersion;
  private List<Condition> conditions = new ArrayList<Condition>();
  private String kind;
  private String vmUUID;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(NutanixMachineProviderStatus instance) {
    instance = (instance != null ? instance : new NutanixMachineProviderStatus());
    if (instance != null) {
          this.withApiVersion(instance.getApiVersion());
          this.withConditions(instance.getConditions());
          this.withKind(instance.getKind());
          this.withVmUUID(instance.getVmUUID());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getApiVersion() {
    return this.apiVersion;
  }
  
  public A withApiVersion(String apiVersion) {
    this.apiVersion = apiVersion;
    return (A) this;
  }
  
  public boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  
  public A addToConditions(int index,Condition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<Condition>();}
    this.conditions.add(index, item);
    return (A)this;
  }
  
  public A setToConditions(int index,Condition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<Condition>();}
    this.conditions.set(index, item); return (A)this;
  }
  
  public A addToConditions(io.fabric8.kubernetes.api.model.Condition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<Condition>();}
    for (Condition item : items) {this.conditions.add(item);} return (A)this;
  }
  
  public A addAllToConditions(Collection<Condition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<Condition>();}
    for (Condition item : items) {this.conditions.add(item);} return (A)this;
  }
  
  public A removeFromConditions(io.fabric8.kubernetes.api.model.Condition... items) {
    if (this.conditions == null) return (A)this;
    for (Condition item : items) { this.conditions.remove(item);} return (A)this;
  }
  
  public A removeAllFromConditions(Collection<Condition> items) {
    if (this.conditions == null) return (A)this;
    for (Condition item : items) { this.conditions.remove(item);} return (A)this;
  }
  
  public List<Condition> getConditions() {
    return this.conditions;
  }
  
  public Condition getCondition(int index) {
    return this.conditions.get(index);
  }
  
  public Condition getFirstCondition() {
    return this.conditions.get(0);
  }
  
  public Condition getLastCondition() {
    return this.conditions.get(conditions.size() - 1);
  }
  
  public Condition getMatchingCondition(Predicate<Condition> predicate) {
      for (Condition item : conditions) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingCondition(Predicate<Condition> predicate) {
      for (Condition item : conditions) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withConditions(List<Condition> conditions) {
    if (conditions != null) {
        this.conditions = new ArrayList();
        for (Condition item : conditions) {
          this.addToConditions(item);
        }
    } else {
      this.conditions = null;
    }
    return (A) this;
  }
  
  public A withConditions(io.fabric8.kubernetes.api.model.Condition... conditions) {
    if (this.conditions != null) {
        this.conditions.clear();
        _visitables.remove("conditions");
    }
    if (conditions != null) {
      for (Condition item : conditions) {
        this.addToConditions(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasConditions() {
    return this.conditions != null && !this.conditions.isEmpty();
  }
  
  public String getKind() {
    return this.kind;
  }
  
  public A withKind(String kind) {
    this.kind = kind;
    return (A) this;
  }
  
  public boolean hasKind() {
    return this.kind != null;
  }
  
  public String getVmUUID() {
    return this.vmUUID;
  }
  
  public A withVmUUID(String vmUUID) {
    this.vmUUID = vmUUID;
    return (A) this;
  }
  
  public boolean hasVmUUID() {
    return this.vmUUID != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    NutanixMachineProviderStatusFluent that = (NutanixMachineProviderStatusFluent) o;
    if (!java.util.Objects.equals(apiVersion, that.apiVersion)) return false;
    if (!java.util.Objects.equals(conditions, that.conditions)) return false;
    if (!java.util.Objects.equals(kind, that.kind)) return false;
    if (!java.util.Objects.equals(vmUUID, that.vmUUID)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  conditions,  kind,  vmUUID,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (conditions != null && !conditions.isEmpty()) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (vmUUID != null) { sb.append("vmUUID:"); sb.append(vmUUID + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  

}