/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.machine.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.machine.v1.NutanixStorageResourceIdentifier;
import io.fabric8.openshift.api.model.machine.v1.NutanixStorageResourceIdentifierBuilder;
import io.fabric8.openshift.api.model.machine.v1.NutanixStorageResourceIdentifierFluent;
import io.fabric8.openshift.api.model.machine.v1.NutanixVMStorageConfig;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class NutanixVMStorageConfigFluent<A extends NutanixVMStorageConfigFluent<A>>
extends BaseFluent<A> {
    private String diskMode;
    private NutanixStorageResourceIdentifierBuilder storageContainer;
    private Map<String, Object> additionalProperties;

    public NutanixVMStorageConfigFluent() {
    }

    public NutanixVMStorageConfigFluent(NutanixVMStorageConfig instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(NutanixVMStorageConfig instance) {
        NutanixVMStorageConfig nutanixVMStorageConfig = instance = instance != null ? instance : new NutanixVMStorageConfig();
        if (instance != null) {
            this.withDiskMode(instance.getDiskMode());
            this.withStorageContainer(instance.getStorageContainer());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getDiskMode() {
        return this.diskMode;
    }

    public A withDiskMode(String diskMode) {
        this.diskMode = diskMode;
        return (A)((Object)this);
    }

    public boolean hasDiskMode() {
        return this.diskMode != null;
    }

    public NutanixStorageResourceIdentifier buildStorageContainer() {
        return this.storageContainer != null ? this.storageContainer.build() : null;
    }

    public A withStorageContainer(NutanixStorageResourceIdentifier storageContainer) {
        this._visitables.remove((Object)"storageContainer");
        if (storageContainer != null) {
            this.storageContainer = new NutanixStorageResourceIdentifierBuilder(storageContainer);
            this._visitables.get((Object)"storageContainer").add(this.storageContainer);
        } else {
            this.storageContainer = null;
            this._visitables.get((Object)"storageContainer").remove((Object)this.storageContainer);
        }
        return (A)((Object)this);
    }

    public boolean hasStorageContainer() {
        return this.storageContainer != null;
    }

    public A withNewStorageContainer(String type, String uuid) {
        return this.withStorageContainer(new NutanixStorageResourceIdentifier(type, uuid));
    }

    public StorageContainerNested<A> withNewStorageContainer() {
        return new StorageContainerNested(null);
    }

    public StorageContainerNested<A> withNewStorageContainerLike(NutanixStorageResourceIdentifier item) {
        return new StorageContainerNested(item);
    }

    public StorageContainerNested<A> editStorageContainer() {
        return this.withNewStorageContainerLike(Optional.ofNullable(this.buildStorageContainer()).orElse(null));
    }

    public StorageContainerNested<A> editOrNewStorageContainer() {
        return this.withNewStorageContainerLike(Optional.ofNullable(this.buildStorageContainer()).orElse(new NutanixStorageResourceIdentifierBuilder().build()));
    }

    public StorageContainerNested<A> editOrNewStorageContainerLike(NutanixStorageResourceIdentifier item) {
        return this.withNewStorageContainerLike(Optional.ofNullable(this.buildStorageContainer()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NutanixVMStorageConfigFluent that = (NutanixVMStorageConfigFluent)((Object)o);
        if (!Objects.equals(this.diskMode, that.diskMode)) {
            return false;
        }
        if (!Objects.equals((Object)this.storageContainer, (Object)that.storageContainer)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.diskMode, this.storageContainer, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.diskMode != null) {
            sb.append("diskMode:");
            sb.append(this.diskMode + ",");
        }
        if (this.storageContainer != null) {
            sb.append("storageContainer:");
            sb.append(String.valueOf((Object)this.storageContainer) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class StorageContainerNested<N>
    extends NutanixStorageResourceIdentifierFluent<StorageContainerNested<N>>
    implements Nested<N> {
        NutanixStorageResourceIdentifierBuilder builder;

        StorageContainerNested(NutanixStorageResourceIdentifier item) {
            this.builder = new NutanixStorageResourceIdentifierBuilder(this, item);
        }

        public N and() {
            return (N)NutanixVMStorageConfigFluent.this.withStorageContainer(this.builder.build());
        }

        public N endStorageContainer() {
            return this.and();
        }
    }
}

