/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.machine.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.machine.v1.OpenStackFailureDomain;
import io.fabric8.openshift.api.model.machine.v1.RootVolume;
import io.fabric8.openshift.api.model.machine.v1.RootVolumeBuilder;
import io.fabric8.openshift.api.model.machine.v1.RootVolumeFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class OpenStackFailureDomainFluent<A extends OpenStackFailureDomainFluent<A>>
extends BaseFluent<A> {
    private String availabilityZone;
    private RootVolumeBuilder rootVolume;
    private Map<String, Object> additionalProperties;

    public OpenStackFailureDomainFluent() {
    }

    public OpenStackFailureDomainFluent(OpenStackFailureDomain instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(OpenStackFailureDomain instance) {
        OpenStackFailureDomain openStackFailureDomain = instance = instance != null ? instance : new OpenStackFailureDomain();
        if (instance != null) {
            this.withAvailabilityZone(instance.getAvailabilityZone());
            this.withRootVolume(instance.getRootVolume());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getAvailabilityZone() {
        return this.availabilityZone;
    }

    public A withAvailabilityZone(String availabilityZone) {
        this.availabilityZone = availabilityZone;
        return (A)((Object)this);
    }

    public boolean hasAvailabilityZone() {
        return this.availabilityZone != null;
    }

    public RootVolume buildRootVolume() {
        return this.rootVolume != null ? this.rootVolume.build() : null;
    }

    public A withRootVolume(RootVolume rootVolume) {
        this._visitables.remove((Object)"rootVolume");
        if (rootVolume != null) {
            this.rootVolume = new RootVolumeBuilder(rootVolume);
            this._visitables.get((Object)"rootVolume").add(this.rootVolume);
        } else {
            this.rootVolume = null;
            this._visitables.get((Object)"rootVolume").remove((Object)this.rootVolume);
        }
        return (A)((Object)this);
    }

    public boolean hasRootVolume() {
        return this.rootVolume != null;
    }

    public A withNewRootVolume(String availabilityZone, String volumeType) {
        return this.withRootVolume(new RootVolume(availabilityZone, volumeType));
    }

    public RootVolumeNested<A> withNewRootVolume() {
        return new RootVolumeNested(null);
    }

    public RootVolumeNested<A> withNewRootVolumeLike(RootVolume item) {
        return new RootVolumeNested(item);
    }

    public RootVolumeNested<A> editRootVolume() {
        return this.withNewRootVolumeLike(Optional.ofNullable(this.buildRootVolume()).orElse(null));
    }

    public RootVolumeNested<A> editOrNewRootVolume() {
        return this.withNewRootVolumeLike(Optional.ofNullable(this.buildRootVolume()).orElse(new RootVolumeBuilder().build()));
    }

    public RootVolumeNested<A> editOrNewRootVolumeLike(RootVolume item) {
        return this.withNewRootVolumeLike(Optional.ofNullable(this.buildRootVolume()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OpenStackFailureDomainFluent that = (OpenStackFailureDomainFluent)((Object)o);
        if (!Objects.equals(this.availabilityZone, that.availabilityZone)) {
            return false;
        }
        if (!Objects.equals((Object)this.rootVolume, (Object)that.rootVolume)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.availabilityZone, this.rootVolume, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.availabilityZone != null) {
            sb.append("availabilityZone:");
            sb.append(this.availabilityZone + ",");
        }
        if (this.rootVolume != null) {
            sb.append("rootVolume:");
            sb.append(this.rootVolume + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class RootVolumeNested<N>
    extends RootVolumeFluent<RootVolumeNested<N>>
    implements Nested<N> {
        RootVolumeBuilder builder;

        RootVolumeNested(RootVolume item) {
            this.builder = new RootVolumeBuilder(this, item);
        }

        public N and() {
            return (N)OpenStackFailureDomainFluent.this.withRootVolume(this.builder.build());
        }

        public N endRootVolume() {
            return this.and();
        }
    }
}

