package io.fabric8.openshift.api.model.machine.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ProviderSpecBuilder extends ProviderSpecFluentImpl<ProviderSpecBuilder> implements VisitableBuilder<ProviderSpec,ProviderSpecBuilder>{
  public ProviderSpecBuilder() {
    this(false);
  }
  public ProviderSpecBuilder(Boolean validationEnabled) {
    this(new ProviderSpec(), validationEnabled);
  }
  public ProviderSpecBuilder(ProviderSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ProviderSpecBuilder(ProviderSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ProviderSpec(), validationEnabled);
  }
  public ProviderSpecBuilder(ProviderSpecFluent<?> fluent,ProviderSpec instance) {
    this(fluent, instance, false);
  }
  public ProviderSpecBuilder(ProviderSpecFluent<?> fluent,ProviderSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withValue(instance.getValue()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ProviderSpecBuilder(ProviderSpec instance) {
    this(instance,false);
  }
  public ProviderSpecBuilder(ProviderSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withValue(instance.getValue()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ProviderSpecFluent<?> fluent;
  Boolean validationEnabled;
  public ProviderSpec build() {
    ProviderSpec buildable = new ProviderSpec(fluent.getValue());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}