package io.fabric8.openshift.api.model.machine.v1beta1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.Taint;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class MachineSpecFluentImpl<A extends MachineSpecFluent<A>> extends BaseFluent<A> implements MachineSpecFluent<A>{
  public MachineSpecFluentImpl() {
  }
  public MachineSpecFluentImpl(MachineSpec instance) {
    this.withLifecycleHooks(instance.getLifecycleHooks()); 
    this.withMetadata(instance.getMetadata()); 
    this.withProviderID(instance.getProviderID()); 
    this.withProviderSpec(instance.getProviderSpec()); 
    this.withTaints(instance.getTaints()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private LifecycleHooksBuilder lifecycleHooks;
  private ObjectMetaBuilder metadata;
  private String providerID;
  private ProviderSpecBuilder providerSpec;
  private List<Taint> taints = new ArrayList<Taint>();
  private Map<String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildLifecycleHooks instead.
   * @return The buildable object.
   */
  @Deprecated
  public LifecycleHooks getLifecycleHooks() {
    return this.lifecycleHooks!=null ?this.lifecycleHooks.build():null;
  }
  public LifecycleHooks buildLifecycleHooks() {
    return this.lifecycleHooks!=null ?this.lifecycleHooks.build():null;
  }
  public A withLifecycleHooks(LifecycleHooks lifecycleHooks) {
    _visitables.get("lifecycleHooks").remove(this.lifecycleHooks);
    if (lifecycleHooks!=null){ this.lifecycleHooks= new LifecycleHooksBuilder(lifecycleHooks); _visitables.get("lifecycleHooks").add(this.lifecycleHooks);} else { this.lifecycleHooks = null; _visitables.get("lifecycleHooks").remove(this.lifecycleHooks); } return (A) this;
  }
  public Boolean hasLifecycleHooks() {
    return this.lifecycleHooks != null;
  }
  public MachineSpecFluent.LifecycleHooksNested<A> withNewLifecycleHooks() {
    return new MachineSpecFluentImpl.LifecycleHooksNestedImpl();
  }
  public MachineSpecFluent.LifecycleHooksNested<A> withNewLifecycleHooksLike(LifecycleHooks item) {
    return new MachineSpecFluentImpl.LifecycleHooksNestedImpl(item);
  }
  public MachineSpecFluent.LifecycleHooksNested<A> editLifecycleHooks() {
    return withNewLifecycleHooksLike(getLifecycleHooks());
  }
  public MachineSpecFluent.LifecycleHooksNested<A> editOrNewLifecycleHooks() {
    return withNewLifecycleHooksLike(getLifecycleHooks() != null ? getLifecycleHooks(): new LifecycleHooksBuilder().build());
  }
  public MachineSpecFluent.LifecycleHooksNested<A> editOrNewLifecycleHooksLike(LifecycleHooks item) {
    return withNewLifecycleHooksLike(getLifecycleHooks() != null ? getLifecycleHooks(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public ObjectMeta buildMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public A withMetadata(ObjectMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} else { this.metadata = null; _visitables.get("metadata").remove(this.metadata); } return (A) this;
  }
  public Boolean hasMetadata() {
    return this.metadata != null;
  }
  public MachineSpecFluent.MetadataNested<A> withNewMetadata() {
    return new MachineSpecFluentImpl.MetadataNestedImpl();
  }
  public MachineSpecFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
    return new MachineSpecFluentImpl.MetadataNestedImpl(item);
  }
  public MachineSpecFluent.MetadataNested<A> editMetadata() {
    return withNewMetadataLike(getMetadata());
  }
  public MachineSpecFluent.MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
  }
  public MachineSpecFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
  }
  public String getProviderID() {
    return this.providerID;
  }
  public A withProviderID(String providerID) {
    this.providerID=providerID; return (A) this;
  }
  public Boolean hasProviderID() {
    return this.providerID != null;
  }
  
  /**
   * This method has been deprecated, please use method buildProviderSpec instead.
   * @return The buildable object.
   */
  @Deprecated
  public ProviderSpec getProviderSpec() {
    return this.providerSpec!=null ?this.providerSpec.build():null;
  }
  public ProviderSpec buildProviderSpec() {
    return this.providerSpec!=null ?this.providerSpec.build():null;
  }
  public A withProviderSpec(ProviderSpec providerSpec) {
    _visitables.get("providerSpec").remove(this.providerSpec);
    if (providerSpec!=null){ this.providerSpec= new ProviderSpecBuilder(providerSpec); _visitables.get("providerSpec").add(this.providerSpec);} else { this.providerSpec = null; _visitables.get("providerSpec").remove(this.providerSpec); } return (A) this;
  }
  public Boolean hasProviderSpec() {
    return this.providerSpec != null;
  }
  public MachineSpecFluent.ProviderSpecNested<A> withNewProviderSpec() {
    return new MachineSpecFluentImpl.ProviderSpecNestedImpl();
  }
  public MachineSpecFluent.ProviderSpecNested<A> withNewProviderSpecLike(ProviderSpec item) {
    return new MachineSpecFluentImpl.ProviderSpecNestedImpl(item);
  }
  public MachineSpecFluent.ProviderSpecNested<A> editProviderSpec() {
    return withNewProviderSpecLike(getProviderSpec());
  }
  public MachineSpecFluent.ProviderSpecNested<A> editOrNewProviderSpec() {
    return withNewProviderSpecLike(getProviderSpec() != null ? getProviderSpec(): new ProviderSpecBuilder().build());
  }
  public MachineSpecFluent.ProviderSpecNested<A> editOrNewProviderSpecLike(ProviderSpec item) {
    return withNewProviderSpecLike(getProviderSpec() != null ? getProviderSpec(): item);
  }
  public A addToTaints(Integer index,Taint item) {
    if (this.taints == null) {this.taints = new ArrayList<Taint>();}
    this.taints.add(index, item);
    return (A)this;
  }
  public A setToTaints(Integer index,Taint item) {
    if (this.taints == null) {this.taints = new ArrayList<Taint>();}
    this.taints.set(index, item); return (A)this;
  }
  public A addToTaints(io.fabric8.kubernetes.api.model.Taint... items) {
    if (this.taints == null) {this.taints = new ArrayList<Taint>();}
    for (Taint item : items) {this.taints.add(item);} return (A)this;
  }
  public A addAllToTaints(Collection<Taint> items) {
    if (this.taints == null) {this.taints = new ArrayList<Taint>();}
    for (Taint item : items) {this.taints.add(item);} return (A)this;
  }
  public A removeFromTaints(io.fabric8.kubernetes.api.model.Taint... items) {
    for (Taint item : items) {if (this.taints!= null){ this.taints.remove(item);}} return (A)this;
  }
  public A removeAllFromTaints(Collection<Taint> items) {
    for (Taint item : items) {if (this.taints!= null){ this.taints.remove(item);}} return (A)this;
  }
  public List<Taint> getTaints() {
    return this.taints;
  }
  public Taint getTaint(Integer index) {
    return this.taints.get(index);
  }
  public Taint getFirstTaint() {
    return this.taints.get(0);
  }
  public Taint getLastTaint() {
    return this.taints.get(taints.size() - 1);
  }
  public Taint getMatchingTaint(Predicate<Taint> predicate) {
    for (Taint item: taints) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingTaint(Predicate<Taint> predicate) {
    for (Taint item: taints) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withTaints(List<Taint> taints) {
    if (taints != null) {this.taints = new ArrayList(); for (Taint item : taints){this.addToTaints(item);}} else { this.taints = null;} return (A) this;
  }
  public A withTaints(io.fabric8.kubernetes.api.model.Taint... taints) {
    if (this.taints != null) {this.taints.clear();}
    if (taints != null) {for (Taint item :taints){ this.addToTaints(item);}} return (A) this;
  }
  public Boolean hasTaints() {
    return taints != null && !taints.isEmpty();
  }
  public A addNewTaint(String effect,String key,String timeAdded,String value) {
    return (A)addToTaints(new Taint(effect, key, timeAdded, value));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MachineSpecFluentImpl that = (MachineSpecFluentImpl) o;
    if (lifecycleHooks != null ? !lifecycleHooks.equals(that.lifecycleHooks) :that.lifecycleHooks != null) return false;
    if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
    if (providerID != null ? !providerID.equals(that.providerID) :that.providerID != null) return false;
    if (providerSpec != null ? !providerSpec.equals(that.providerSpec) :that.providerSpec != null) return false;
    if (taints != null ? !taints.equals(that.taints) :that.taints != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(lifecycleHooks,  metadata,  providerID,  providerSpec,  taints,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (lifecycleHooks != null) { sb.append("lifecycleHooks:"); sb.append(lifecycleHooks + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (providerID != null) { sb.append("providerID:"); sb.append(providerID + ","); }
    if (providerSpec != null) { sb.append("providerSpec:"); sb.append(providerSpec + ","); }
    if (taints != null && !taints.isEmpty()) { sb.append("taints:"); sb.append(taints + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class LifecycleHooksNestedImpl<N> extends LifecycleHooksFluentImpl<MachineSpecFluent.LifecycleHooksNested<N>> implements MachineSpecFluent.LifecycleHooksNested<N>,Nested<N>{
    LifecycleHooksNestedImpl(LifecycleHooks item) {
      this.builder = new LifecycleHooksBuilder(this, item);
    }
    LifecycleHooksNestedImpl() {
      this.builder = new LifecycleHooksBuilder(this);
    }
    LifecycleHooksBuilder builder;
    public N and() {
      return (N) MachineSpecFluentImpl.this.withLifecycleHooks(builder.build());
    }
    public N endLifecycleHooks() {
      return and();
    }
    
  }
  class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<MachineSpecFluent.MetadataNested<N>> implements MachineSpecFluent.MetadataNested<N>,Nested<N>{
    MetadataNestedImpl(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    MetadataNestedImpl() {
      this.builder = new ObjectMetaBuilder(this);
    }
    ObjectMetaBuilder builder;
    public N and() {
      return (N) MachineSpecFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  class ProviderSpecNestedImpl<N> extends ProviderSpecFluentImpl<MachineSpecFluent.ProviderSpecNested<N>> implements MachineSpecFluent.ProviderSpecNested<N>,Nested<N>{
    ProviderSpecNestedImpl(ProviderSpec item) {
      this.builder = new ProviderSpecBuilder(this, item);
    }
    ProviderSpecNestedImpl() {
      this.builder = new ProviderSpecBuilder(this);
    }
    ProviderSpecBuilder builder;
    public N and() {
      return (N) MachineSpecFluentImpl.this.withProviderSpec(builder.build());
    }
    public N endProviderSpec() {
      return and();
    }
    
  }
  
}