package io.fabric8.openshift.api.model.machine.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class RootVolumeBuilder extends RootVolumeFluent<RootVolumeBuilder> implements VisitableBuilder<RootVolume,RootVolumeBuilder>{
  public RootVolumeBuilder() {
    this(new RootVolume());
  }
  
  public RootVolumeBuilder(RootVolumeFluent<?> fluent) {
    this(fluent, new RootVolume());
  }
  
  public RootVolumeBuilder(RootVolumeFluent<?> fluent,RootVolume instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public RootVolumeBuilder(RootVolume instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  RootVolumeFluent<?> fluent;
  
  public RootVolume build() {
    RootVolume buildable = new RootVolume(fluent.getAvailabilityZone(),fluent.getDeviceType(),fluent.getDiskSize(),fluent.getSourceType(),fluent.getSourceUUID(),fluent.getVolumeType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}