/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.installer.powervs.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.IntOrStringBuilder;
import io.fabric8.kubernetes.api.model.IntOrStringFluent;
import io.fabric8.openshift.api.model.installer.powervs.v1.MachinePool;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class MachinePoolFluent<A extends MachinePoolFluent<A>>
extends BaseFluent<A> {
    private Integer memoryGiB;
    private String procType;
    private IntOrStringBuilder processors;
    private String smtLevel;
    private String sysType;
    private List<String> volumeIDs = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public MachinePoolFluent() {
    }

    public MachinePoolFluent(MachinePool instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(MachinePool instance) {
        MachinePool machinePool = instance = instance != null ? instance : new MachinePool();
        if (instance != null) {
            this.withMemoryGiB(instance.getMemoryGiB());
            this.withProcType(instance.getProcType());
            this.withProcessors(instance.getProcessors());
            this.withSmtLevel(instance.getSmtLevel());
            this.withSysType(instance.getSysType());
            this.withVolumeIDs(instance.getVolumeIDs());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public Integer getMemoryGiB() {
        return this.memoryGiB;
    }

    public A withMemoryGiB(Integer memoryGiB) {
        this.memoryGiB = memoryGiB;
        return (A)((Object)this);
    }

    public boolean hasMemoryGiB() {
        return this.memoryGiB != null;
    }

    public String getProcType() {
        return this.procType;
    }

    public A withProcType(String procType) {
        this.procType = procType;
        return (A)((Object)this);
    }

    public boolean hasProcType() {
        return this.procType != null;
    }

    public IntOrString buildProcessors() {
        return this.processors != null ? this.processors.build() : null;
    }

    public A withProcessors(IntOrString processors) {
        this._visitables.remove((Object)"processors");
        if (processors != null) {
            this.processors = new IntOrStringBuilder(processors);
            this._visitables.get((Object)"processors").add(this.processors);
        } else {
            this.processors = null;
            this._visitables.get((Object)"processors").remove(this.processors);
        }
        return (A)((Object)this);
    }

    public boolean hasProcessors() {
        return this.processors != null;
    }

    public A withNewProcessors(Object value) {
        return this.withProcessors(new IntOrString(value));
    }

    public ProcessorsNested<A> withNewProcessors() {
        return new ProcessorsNested(null);
    }

    public ProcessorsNested<A> withNewProcessorsLike(IntOrString item) {
        return new ProcessorsNested(item);
    }

    public ProcessorsNested<A> editProcessors() {
        return this.withNewProcessorsLike(Optional.ofNullable(this.buildProcessors()).orElse(null));
    }

    public ProcessorsNested<A> editOrNewProcessors() {
        return this.withNewProcessorsLike(Optional.ofNullable(this.buildProcessors()).orElse(new IntOrStringBuilder().build()));
    }

    public ProcessorsNested<A> editOrNewProcessorsLike(IntOrString item) {
        return this.withNewProcessorsLike(Optional.ofNullable(this.buildProcessors()).orElse(item));
    }

    public String getSmtLevel() {
        return this.smtLevel;
    }

    public A withSmtLevel(String smtLevel) {
        this.smtLevel = smtLevel;
        return (A)((Object)this);
    }

    public boolean hasSmtLevel() {
        return this.smtLevel != null;
    }

    public String getSysType() {
        return this.sysType;
    }

    public A withSysType(String sysType) {
        this.sysType = sysType;
        return (A)((Object)this);
    }

    public boolean hasSysType() {
        return this.sysType != null;
    }

    public A addToVolumeIDs(int index, String item) {
        if (this.volumeIDs == null) {
            this.volumeIDs = new ArrayList<String>();
        }
        this.volumeIDs.add(index, item);
        return (A)((Object)this);
    }

    public A setToVolumeIDs(int index, String item) {
        if (this.volumeIDs == null) {
            this.volumeIDs = new ArrayList<String>();
        }
        this.volumeIDs.set(index, item);
        return (A)((Object)this);
    }

    public A addToVolumeIDs(String ... items) {
        if (this.volumeIDs == null) {
            this.volumeIDs = new ArrayList<String>();
        }
        for (String item : items) {
            this.volumeIDs.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToVolumeIDs(Collection<String> items) {
        if (this.volumeIDs == null) {
            this.volumeIDs = new ArrayList<String>();
        }
        for (String item : items) {
            this.volumeIDs.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromVolumeIDs(String ... items) {
        if (this.volumeIDs == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.volumeIDs.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromVolumeIDs(Collection<String> items) {
        if (this.volumeIDs == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.volumeIDs.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getVolumeIDs() {
        return this.volumeIDs;
    }

    public String getVolumeID(int index) {
        return this.volumeIDs.get(index);
    }

    public String getFirstVolumeID() {
        return this.volumeIDs.get(0);
    }

    public String getLastVolumeID() {
        return this.volumeIDs.get(this.volumeIDs.size() - 1);
    }

    public String getMatchingVolumeID(Predicate<String> predicate) {
        for (String item : this.volumeIDs) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingVolumeID(Predicate<String> predicate) {
        for (String item : this.volumeIDs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withVolumeIDs(List<String> volumeIDs) {
        if (volumeIDs != null) {
            this.volumeIDs = new ArrayList<String>();
            for (String item : volumeIDs) {
                this.addToVolumeIDs(item);
            }
        } else {
            this.volumeIDs = null;
        }
        return (A)((Object)this);
    }

    public A withVolumeIDs(String ... volumeIDs) {
        if (this.volumeIDs != null) {
            this.volumeIDs.clear();
            this._visitables.remove((Object)"volumeIDs");
        }
        if (volumeIDs != null) {
            for (String item : volumeIDs) {
                this.addToVolumeIDs(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasVolumeIDs() {
        return this.volumeIDs != null && !this.volumeIDs.isEmpty();
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MachinePoolFluent that = (MachinePoolFluent)((Object)o);
        if (!Objects.equals(this.memoryGiB, that.memoryGiB)) {
            return false;
        }
        if (!Objects.equals(this.procType, that.procType)) {
            return false;
        }
        if (!Objects.equals(this.processors, that.processors)) {
            return false;
        }
        if (!Objects.equals(this.smtLevel, that.smtLevel)) {
            return false;
        }
        if (!Objects.equals(this.sysType, that.sysType)) {
            return false;
        }
        if (!Objects.equals(this.volumeIDs, that.volumeIDs)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.memoryGiB, this.procType, this.processors, this.smtLevel, this.sysType, this.volumeIDs, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.memoryGiB != null) {
            sb.append("memoryGiB:");
            sb.append(this.memoryGiB + ",");
        }
        if (this.procType != null) {
            sb.append("procType:");
            sb.append(this.procType + ",");
        }
        if (this.processors != null) {
            sb.append("processors:");
            sb.append(String.valueOf(this.processors) + ",");
        }
        if (this.smtLevel != null) {
            sb.append("smtLevel:");
            sb.append(this.smtLevel + ",");
        }
        if (this.sysType != null) {
            sb.append("sysType:");
            sb.append(this.sysType + ",");
        }
        if (this.volumeIDs != null && !this.volumeIDs.isEmpty()) {
            sb.append("volumeIDs:");
            sb.append(String.valueOf(this.volumeIDs) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ProcessorsNested<N>
    extends IntOrStringFluent<ProcessorsNested<N>>
    implements Nested<N> {
        IntOrStringBuilder builder;

        ProcessorsNested(IntOrString item) {
            this.builder = new IntOrStringBuilder((IntOrStringFluent)this, item);
        }

        public N and() {
            return (N)MachinePoolFluent.this.withProcessors(this.builder.build());
        }

        public N endProcessors() {
            return this.and();
        }
    }
}

