/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.installer.nutanix.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.openshift.api.model.installer.nutanix.v1.DataDisk;
import io.fabric8.openshift.api.model.installer.nutanix.v1.StorageConfig;
import io.fabric8.openshift.api.model.installer.nutanix.v1.StorageConfigBuilder;
import io.fabric8.openshift.api.model.installer.nutanix.v1.StorageConfigFluent;
import io.fabric8.openshift.api.model.installer.nutanix.v1.StorageResourceReference;
import io.fabric8.openshift.api.model.installer.nutanix.v1.StorageResourceReferenceBuilder;
import io.fabric8.openshift.api.model.installer.nutanix.v1.StorageResourceReferenceFluent;
import io.fabric8.openshift.api.model.machine.v1.NutanixVMDiskDeviceProperties;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class DataDiskFluent<A extends DataDiskFluent<A>>
extends BaseFluent<A> {
    private StorageResourceReferenceBuilder dataSourceImage;
    private NutanixVMDiskDeviceProperties deviceProperties;
    private Quantity diskSize;
    private StorageConfigBuilder storageConfig;
    private Map<String, Object> additionalProperties;

    public DataDiskFluent() {
    }

    public DataDiskFluent(DataDisk instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(DataDisk instance) {
        DataDisk dataDisk = instance = instance != null ? instance : new DataDisk();
        if (instance != null) {
            this.withDataSourceImage(instance.getDataSourceImage());
            this.withDeviceProperties(instance.getDeviceProperties());
            this.withDiskSize(instance.getDiskSize());
            this.withStorageConfig(instance.getStorageConfig());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public StorageResourceReference buildDataSourceImage() {
        return this.dataSourceImage != null ? this.dataSourceImage.build() : null;
    }

    public A withDataSourceImage(StorageResourceReference dataSourceImage) {
        this._visitables.remove((Object)"dataSourceImage");
        if (dataSourceImage != null) {
            this.dataSourceImage = new StorageResourceReferenceBuilder(dataSourceImage);
            this._visitables.get((Object)"dataSourceImage").add(this.dataSourceImage);
        } else {
            this.dataSourceImage = null;
            this._visitables.get((Object)"dataSourceImage").remove((Object)this.dataSourceImage);
        }
        return (A)((Object)this);
    }

    public boolean hasDataSourceImage() {
        return this.dataSourceImage != null;
    }

    public A withNewDataSourceImage(String name, String referenceName, String uuid) {
        return this.withDataSourceImage(new StorageResourceReference(name, referenceName, uuid));
    }

    public DataSourceImageNested<A> withNewDataSourceImage() {
        return new DataSourceImageNested(null);
    }

    public DataSourceImageNested<A> withNewDataSourceImageLike(StorageResourceReference item) {
        return new DataSourceImageNested(item);
    }

    public DataSourceImageNested<A> editDataSourceImage() {
        return this.withNewDataSourceImageLike(Optional.ofNullable(this.buildDataSourceImage()).orElse(null));
    }

    public DataSourceImageNested<A> editOrNewDataSourceImage() {
        return this.withNewDataSourceImageLike(Optional.ofNullable(this.buildDataSourceImage()).orElse(new StorageResourceReferenceBuilder().build()));
    }

    public DataSourceImageNested<A> editOrNewDataSourceImageLike(StorageResourceReference item) {
        return this.withNewDataSourceImageLike(Optional.ofNullable(this.buildDataSourceImage()).orElse(item));
    }

    public NutanixVMDiskDeviceProperties getDeviceProperties() {
        return this.deviceProperties;
    }

    public A withDeviceProperties(NutanixVMDiskDeviceProperties deviceProperties) {
        this.deviceProperties = deviceProperties;
        return (A)((Object)this);
    }

    public boolean hasDeviceProperties() {
        return this.deviceProperties != null;
    }

    public A withNewDeviceProperties(String adapterType, Integer deviceIndex, String deviceType) {
        return this.withDeviceProperties(new NutanixVMDiskDeviceProperties(adapterType, deviceIndex, deviceType));
    }

    public Quantity getDiskSize() {
        return this.diskSize;
    }

    public A withDiskSize(Quantity diskSize) {
        this.diskSize = diskSize;
        return (A)((Object)this);
    }

    public boolean hasDiskSize() {
        return this.diskSize != null;
    }

    public A withNewDiskSize(String amount, String format) {
        return this.withDiskSize(new Quantity(amount, format));
    }

    public A withNewDiskSize(String amount) {
        return this.withDiskSize(new Quantity(amount));
    }

    public StorageConfig buildStorageConfig() {
        return this.storageConfig != null ? this.storageConfig.build() : null;
    }

    public A withStorageConfig(StorageConfig storageConfig) {
        this._visitables.remove((Object)"storageConfig");
        if (storageConfig != null) {
            this.storageConfig = new StorageConfigBuilder(storageConfig);
            this._visitables.get((Object)"storageConfig").add(this.storageConfig);
        } else {
            this.storageConfig = null;
            this._visitables.get((Object)"storageConfig").remove((Object)this.storageConfig);
        }
        return (A)((Object)this);
    }

    public boolean hasStorageConfig() {
        return this.storageConfig != null;
    }

    public StorageConfigNested<A> withNewStorageConfig() {
        return new StorageConfigNested(null);
    }

    public StorageConfigNested<A> withNewStorageConfigLike(StorageConfig item) {
        return new StorageConfigNested(item);
    }

    public StorageConfigNested<A> editStorageConfig() {
        return this.withNewStorageConfigLike(Optional.ofNullable(this.buildStorageConfig()).orElse(null));
    }

    public StorageConfigNested<A> editOrNewStorageConfig() {
        return this.withNewStorageConfigLike(Optional.ofNullable(this.buildStorageConfig()).orElse(new StorageConfigBuilder().build()));
    }

    public StorageConfigNested<A> editOrNewStorageConfigLike(StorageConfig item) {
        return this.withNewStorageConfigLike(Optional.ofNullable(this.buildStorageConfig()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DataDiskFluent that = (DataDiskFluent)((Object)o);
        if (!Objects.equals((Object)this.dataSourceImage, (Object)that.dataSourceImage)) {
            return false;
        }
        if (!Objects.equals(this.deviceProperties, that.deviceProperties)) {
            return false;
        }
        if (!Objects.equals(this.diskSize, that.diskSize)) {
            return false;
        }
        if (!Objects.equals((Object)this.storageConfig, (Object)that.storageConfig)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.dataSourceImage, this.deviceProperties, this.diskSize, this.storageConfig, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.dataSourceImage != null) {
            sb.append("dataSourceImage:");
            sb.append(String.valueOf((Object)this.dataSourceImage) + ",");
        }
        if (this.deviceProperties != null) {
            sb.append("deviceProperties:");
            sb.append(String.valueOf(this.deviceProperties) + ",");
        }
        if (this.diskSize != null) {
            sb.append("diskSize:");
            sb.append(String.valueOf(this.diskSize) + ",");
        }
        if (this.storageConfig != null) {
            sb.append("storageConfig:");
            sb.append(String.valueOf((Object)this.storageConfig) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class StorageConfigNested<N>
    extends StorageConfigFluent<StorageConfigNested<N>>
    implements Nested<N> {
        StorageConfigBuilder builder;

        StorageConfigNested(StorageConfig item) {
            this.builder = new StorageConfigBuilder(this, item);
        }

        public N and() {
            return (N)DataDiskFluent.this.withStorageConfig(this.builder.build());
        }

        public N endStorageConfig() {
            return this.and();
        }
    }

    public class DataSourceImageNested<N>
    extends StorageResourceReferenceFluent<DataSourceImageNested<N>>
    implements Nested<N> {
        StorageResourceReferenceBuilder builder;

        DataSourceImageNested(StorageResourceReference item) {
            this.builder = new StorageResourceReferenceBuilder(this, item);
        }

        public N and() {
            return (N)DataDiskFluent.this.withDataSourceImage(this.builder.build());
        }

        public N endDataSourceImage() {
            return this.and();
        }
    }
}

