/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.installer.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.installer.gcp.v1.QuotaUsage;
import io.fabric8.openshift.api.model.installer.gcp.v1.QuotaUsageBuilder;
import io.fabric8.openshift.api.model.installer.gcp.v1.QuotaUsageFluent;
import io.fabric8.openshift.api.model.installer.v1.ClusterQuota;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ClusterQuotaFluent<A extends ClusterQuotaFluent<A>>
extends BaseFluent<A> {
    private ArrayList<QuotaUsageBuilder> gcp = new ArrayList();
    private Map<String, Object> additionalProperties;

    public ClusterQuotaFluent() {
    }

    public ClusterQuotaFluent(ClusterQuota instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ClusterQuota instance) {
        ClusterQuota clusterQuota = instance = instance != null ? instance : new ClusterQuota();
        if (instance != null) {
            this.withGcp(instance.getGcp());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToGcp(int index, QuotaUsage item) {
        if (this.gcp == null) {
            this.gcp = new ArrayList();
        }
        QuotaUsageBuilder builder = new QuotaUsageBuilder(item);
        if (index < 0 || index >= this.gcp.size()) {
            this._visitables.get((Object)"gcp").add(builder);
            this.gcp.add(builder);
        } else {
            this._visitables.get((Object)"gcp").add(index, builder);
            this.gcp.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToGcp(int index, QuotaUsage item) {
        if (this.gcp == null) {
            this.gcp = new ArrayList();
        }
        QuotaUsageBuilder builder = new QuotaUsageBuilder(item);
        if (index < 0 || index >= this.gcp.size()) {
            this._visitables.get((Object)"gcp").add(builder);
            this.gcp.add(builder);
        } else {
            this._visitables.get((Object)"gcp").set(index, builder);
            this.gcp.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToGcp(QuotaUsage ... items) {
        if (this.gcp == null) {
            this.gcp = new ArrayList();
        }
        for (QuotaUsage item : items) {
            QuotaUsageBuilder builder = new QuotaUsageBuilder(item);
            this._visitables.get((Object)"gcp").add(builder);
            this.gcp.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToGcp(Collection<QuotaUsage> items) {
        if (this.gcp == null) {
            this.gcp = new ArrayList();
        }
        for (QuotaUsage item : items) {
            QuotaUsageBuilder builder = new QuotaUsageBuilder(item);
            this._visitables.get((Object)"gcp").add(builder);
            this.gcp.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromGcp(QuotaUsage ... items) {
        if (this.gcp == null) {
            return (A)((Object)this);
        }
        for (QuotaUsage item : items) {
            QuotaUsageBuilder builder = new QuotaUsageBuilder(item);
            this._visitables.get((Object)"gcp").remove((Object)builder);
            this.gcp.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromGcp(Collection<QuotaUsage> items) {
        if (this.gcp == null) {
            return (A)((Object)this);
        }
        for (QuotaUsage item : items) {
            QuotaUsageBuilder builder = new QuotaUsageBuilder(item);
            this._visitables.get((Object)"gcp").remove((Object)builder);
            this.gcp.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromGcp(Predicate<QuotaUsageBuilder> predicate) {
        if (this.gcp == null) {
            return (A)((Object)this);
        }
        Iterator<QuotaUsageBuilder> each = this.gcp.iterator();
        List visitables = this._visitables.get((Object)"gcp");
        while (each.hasNext()) {
            QuotaUsageBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<QuotaUsage> buildGcp() {
        return this.gcp != null ? ClusterQuotaFluent.build(this.gcp) : null;
    }

    public QuotaUsage buildGcp(int index) {
        return this.gcp.get(index).build();
    }

    public QuotaUsage buildFirstGcp() {
        return this.gcp.get(0).build();
    }

    public QuotaUsage buildLastGcp() {
        return this.gcp.get(this.gcp.size() - 1).build();
    }

    public QuotaUsage buildMatchingGcp(Predicate<QuotaUsageBuilder> predicate) {
        for (QuotaUsageBuilder item : this.gcp) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingGcp(Predicate<QuotaUsageBuilder> predicate) {
        for (QuotaUsageBuilder item : this.gcp) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withGcp(List<QuotaUsage> gcp) {
        if (this.gcp != null) {
            this._visitables.get((Object)"gcp").clear();
        }
        if (gcp != null) {
            this.gcp = new ArrayList();
            for (QuotaUsage item : gcp) {
                this.addToGcp(item);
            }
        } else {
            this.gcp = null;
        }
        return (A)((Object)this);
    }

    public A withGcp(QuotaUsage ... gcp) {
        if (this.gcp != null) {
            this.gcp.clear();
            this._visitables.remove((Object)"gcp");
        }
        if (gcp != null) {
            for (QuotaUsage item : gcp) {
                this.addToGcp(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasGcp() {
        return this.gcp != null && !this.gcp.isEmpty();
    }

    public GcpNested<A> addNewGcp() {
        return new GcpNested(-1, null);
    }

    public GcpNested<A> addNewGcpLike(QuotaUsage item) {
        return new GcpNested(-1, item);
    }

    public GcpNested<A> setNewGcpLike(int index, QuotaUsage item) {
        return new GcpNested(index, item);
    }

    public GcpNested<A> editGcp(int index) {
        if (this.gcp.size() <= index) {
            throw new RuntimeException("Can't edit gcp. Index exceeds size.");
        }
        return this.setNewGcpLike(index, this.buildGcp(index));
    }

    public GcpNested<A> editFirstGcp() {
        if (this.gcp.size() == 0) {
            throw new RuntimeException("Can't edit first gcp. The list is empty.");
        }
        return this.setNewGcpLike(0, this.buildGcp(0));
    }

    public GcpNested<A> editLastGcp() {
        int index = this.gcp.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last gcp. The list is empty.");
        }
        return this.setNewGcpLike(index, this.buildGcp(index));
    }

    public GcpNested<A> editMatchingGcp(Predicate<QuotaUsageBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.gcp.size(); ++i) {
            if (!predicate.test(this.gcp.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching gcp. No match found.");
        }
        return this.setNewGcpLike(index, this.buildGcp(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClusterQuotaFluent that = (ClusterQuotaFluent)((Object)o);
        if (!Objects.equals(this.gcp, that.gcp)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.gcp, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.gcp != null && !this.gcp.isEmpty()) {
            sb.append("gcp:");
            sb.append(this.gcp + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class GcpNested<N>
    extends QuotaUsageFluent<GcpNested<N>>
    implements Nested<N> {
        QuotaUsageBuilder builder;
        int index;

        GcpNested(int index, QuotaUsage item) {
            this.index = index;
            this.builder = new QuotaUsageBuilder(this, item);
        }

        public N and() {
            return (N)ClusterQuotaFluent.this.setToGcp(this.index, this.builder.build());
        }

        public N endGcp() {
            return this.and();
        }
    }
}

