package io.fabric8.openshift.api.model.installer.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class NetworkingFluentImpl<A extends NetworkingFluent<A>> extends BaseFluent<A> implements NetworkingFluent<A>{
  public NetworkingFluentImpl() {
  }
  public NetworkingFluentImpl(Networking instance) {
    this.withClusterNetwork(instance.getClusterNetwork()); 
    this.withDeprecatedClusterNetworks(instance.getDeprecatedClusterNetworks()); 
    this.withMachineCIDR(instance.getMachineCIDR()); 
    this.withMachineNetwork(instance.getMachineNetwork()); 
    this.withNetworkType(instance.getNetworkType()); 
    this.withServiceCIDR(instance.getServiceCIDR()); 
    this.withServiceNetwork(instance.getServiceNetwork()); 
    this.withType(instance.getType()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private ArrayList<ClusterNetworkEntryBuilder> clusterNetwork = new ArrayList<ClusterNetworkEntryBuilder>();
  private ArrayList<ClusterNetworkEntryBuilder> deprecatedClusterNetworks = new ArrayList<ClusterNetworkEntryBuilder>();
  private String machineCIDR;
  private ArrayList<MachineNetworkEntryBuilder> machineNetwork = new ArrayList<MachineNetworkEntryBuilder>();
  private String networkType;
  private String serviceCIDR;
  private List<String> serviceNetwork = new ArrayList<String>();
  private String type;
  private Map<String,Object> additionalProperties;
  public A addToClusterNetwork(Integer index,ClusterNetworkEntry item) {
    if (this.clusterNetwork == null) {this.clusterNetwork = new ArrayList<ClusterNetworkEntryBuilder>();}
    ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);_visitables.get("clusterNetwork").add(index >= 0 ? index : _visitables.get("clusterNetwork").size(), builder);this.clusterNetwork.add(index >= 0 ? index : clusterNetwork.size(), builder); return (A)this;
  }
  public A setToClusterNetwork(Integer index,ClusterNetworkEntry item) {
    if (this.clusterNetwork == null) {this.clusterNetwork = new ArrayList<ClusterNetworkEntryBuilder>();}
    ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);
    if (index < 0 || index >= _visitables.get("clusterNetwork").size()) { _visitables.get("clusterNetwork").add(builder); } else { _visitables.get("clusterNetwork").set(index, builder);}
    if (index < 0 || index >= clusterNetwork.size()) { clusterNetwork.add(builder); } else { clusterNetwork.set(index, builder);}
     return (A)this;
  }
  public A addToClusterNetwork(io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntry... items) {
    if (this.clusterNetwork == null) {this.clusterNetwork = new ArrayList<ClusterNetworkEntryBuilder>();}
    for (ClusterNetworkEntry item : items) {ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);_visitables.get("clusterNetwork").add(builder);this.clusterNetwork.add(builder);} return (A)this;
  }
  public A addAllToClusterNetwork(Collection<ClusterNetworkEntry> items) {
    if (this.clusterNetwork == null) {this.clusterNetwork = new ArrayList<ClusterNetworkEntryBuilder>();}
    for (ClusterNetworkEntry item : items) {ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);_visitables.get("clusterNetwork").add(builder);this.clusterNetwork.add(builder);} return (A)this;
  }
  public A removeFromClusterNetwork(io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntry... items) {
    for (ClusterNetworkEntry item : items) {ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);_visitables.get("clusterNetwork").remove(builder);if (this.clusterNetwork != null) {this.clusterNetwork.remove(builder);}} return (A)this;
  }
  public A removeAllFromClusterNetwork(Collection<ClusterNetworkEntry> items) {
    for (ClusterNetworkEntry item : items) {ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);_visitables.get("clusterNetwork").remove(builder);if (this.clusterNetwork != null) {this.clusterNetwork.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate) {
    if (clusterNetwork == null) return (A) this;
    final Iterator<ClusterNetworkEntryBuilder> each = clusterNetwork.iterator();
    final List visitables = _visitables.get("clusterNetwork");
    while (each.hasNext()) {
      ClusterNetworkEntryBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildClusterNetwork instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ClusterNetworkEntry> getClusterNetwork() {
    return clusterNetwork != null ? build(clusterNetwork) : null;
  }
  public List<ClusterNetworkEntry> buildClusterNetwork() {
    return clusterNetwork != null ? build(clusterNetwork) : null;
  }
  public ClusterNetworkEntry buildClusterNetwork(Integer index) {
    return this.clusterNetwork.get(index).build();
  }
  public ClusterNetworkEntry buildFirstClusterNetwork() {
    return this.clusterNetwork.get(0).build();
  }
  public ClusterNetworkEntry buildLastClusterNetwork() {
    return this.clusterNetwork.get(clusterNetwork.size() - 1).build();
  }
  public ClusterNetworkEntry buildMatchingClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate) {
    for (ClusterNetworkEntryBuilder item: clusterNetwork) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate) {
    for (ClusterNetworkEntryBuilder item: clusterNetwork) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withClusterNetwork(List<ClusterNetworkEntry> clusterNetwork) {
    if (this.clusterNetwork != null) { _visitables.get("clusterNetwork").removeAll(this.clusterNetwork);}
    if (clusterNetwork != null) {this.clusterNetwork = new ArrayList(); for (ClusterNetworkEntry item : clusterNetwork){this.addToClusterNetwork(item);}} else { this.clusterNetwork = null;} return (A) this;
  }
  public A withClusterNetwork(io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntry... clusterNetwork) {
    if (this.clusterNetwork != null) {this.clusterNetwork.clear();}
    if (clusterNetwork != null) {for (ClusterNetworkEntry item :clusterNetwork){ this.addToClusterNetwork(item);}} return (A) this;
  }
  public Boolean hasClusterNetwork() {
    return clusterNetwork != null && !clusterNetwork.isEmpty();
  }
  public A addNewClusterNetwork(String cidr,Integer hostPrefix,Integer hostSubnetLength) {
    return (A)addToClusterNetwork(new ClusterNetworkEntry(cidr, hostPrefix, hostSubnetLength));
  }
  public NetworkingFluent.ClusterNetworkNested<A> addNewClusterNetwork() {
    return new NetworkingFluentImpl.ClusterNetworkNestedImpl();
  }
  public NetworkingFluent.ClusterNetworkNested<A> addNewClusterNetworkLike(ClusterNetworkEntry item) {
    return new NetworkingFluentImpl.ClusterNetworkNestedImpl(-1, item);
  }
  public NetworkingFluent.ClusterNetworkNested<A> setNewClusterNetworkLike(Integer index,ClusterNetworkEntry item) {
    return new NetworkingFluentImpl.ClusterNetworkNestedImpl(index, item);
  }
  public NetworkingFluent.ClusterNetworkNested<A> editClusterNetwork(Integer index) {
    if (clusterNetwork.size() <= index) throw new RuntimeException("Can't edit clusterNetwork. Index exceeds size.");
    return setNewClusterNetworkLike(index, buildClusterNetwork(index));
  }
  public NetworkingFluent.ClusterNetworkNested<A> editFirstClusterNetwork() {
    if (clusterNetwork.size() == 0) throw new RuntimeException("Can't edit first clusterNetwork. The list is empty.");
    return setNewClusterNetworkLike(0, buildClusterNetwork(0));
  }
  public NetworkingFluent.ClusterNetworkNested<A> editLastClusterNetwork() {
    int index = clusterNetwork.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last clusterNetwork. The list is empty.");
    return setNewClusterNetworkLike(index, buildClusterNetwork(index));
  }
  public NetworkingFluent.ClusterNetworkNested<A> editMatchingClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate) {
    int index = -1;
    for (int i=0;i<clusterNetwork.size();i++) { 
    if (predicate.test(clusterNetwork.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching clusterNetwork. No match found.");
    return setNewClusterNetworkLike(index, buildClusterNetwork(index));
  }
  public A addToDeprecatedClusterNetworks(Integer index,ClusterNetworkEntry item) {
    if (this.deprecatedClusterNetworks == null) {this.deprecatedClusterNetworks = new ArrayList<ClusterNetworkEntryBuilder>();}
    ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);_visitables.get("deprecatedClusterNetworks").add(index >= 0 ? index : _visitables.get("deprecatedClusterNetworks").size(), builder);this.deprecatedClusterNetworks.add(index >= 0 ? index : deprecatedClusterNetworks.size(), builder); return (A)this;
  }
  public A setToDeprecatedClusterNetworks(Integer index,ClusterNetworkEntry item) {
    if (this.deprecatedClusterNetworks == null) {this.deprecatedClusterNetworks = new ArrayList<ClusterNetworkEntryBuilder>();}
    ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);
    if (index < 0 || index >= _visitables.get("deprecatedClusterNetworks").size()) { _visitables.get("deprecatedClusterNetworks").add(builder); } else { _visitables.get("deprecatedClusterNetworks").set(index, builder);}
    if (index < 0 || index >= deprecatedClusterNetworks.size()) { deprecatedClusterNetworks.add(builder); } else { deprecatedClusterNetworks.set(index, builder);}
     return (A)this;
  }
  public A addToDeprecatedClusterNetworks(io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntry... items) {
    if (this.deprecatedClusterNetworks == null) {this.deprecatedClusterNetworks = new ArrayList<ClusterNetworkEntryBuilder>();}
    for (ClusterNetworkEntry item : items) {ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);_visitables.get("deprecatedClusterNetworks").add(builder);this.deprecatedClusterNetworks.add(builder);} return (A)this;
  }
  public A addAllToDeprecatedClusterNetworks(Collection<ClusterNetworkEntry> items) {
    if (this.deprecatedClusterNetworks == null) {this.deprecatedClusterNetworks = new ArrayList<ClusterNetworkEntryBuilder>();}
    for (ClusterNetworkEntry item : items) {ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);_visitables.get("deprecatedClusterNetworks").add(builder);this.deprecatedClusterNetworks.add(builder);} return (A)this;
  }
  public A removeFromDeprecatedClusterNetworks(io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntry... items) {
    for (ClusterNetworkEntry item : items) {ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);_visitables.get("deprecatedClusterNetworks").remove(builder);if (this.deprecatedClusterNetworks != null) {this.deprecatedClusterNetworks.remove(builder);}} return (A)this;
  }
  public A removeAllFromDeprecatedClusterNetworks(Collection<ClusterNetworkEntry> items) {
    for (ClusterNetworkEntry item : items) {ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);_visitables.get("deprecatedClusterNetworks").remove(builder);if (this.deprecatedClusterNetworks != null) {this.deprecatedClusterNetworks.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromDeprecatedClusterNetworks(Predicate<ClusterNetworkEntryBuilder> predicate) {
    if (deprecatedClusterNetworks == null) return (A) this;
    final Iterator<ClusterNetworkEntryBuilder> each = deprecatedClusterNetworks.iterator();
    final List visitables = _visitables.get("deprecatedClusterNetworks");
    while (each.hasNext()) {
      ClusterNetworkEntryBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildDeprecatedClusterNetworks instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ClusterNetworkEntry> getDeprecatedClusterNetworks() {
    return deprecatedClusterNetworks != null ? build(deprecatedClusterNetworks) : null;
  }
  public List<ClusterNetworkEntry> buildDeprecatedClusterNetworks() {
    return deprecatedClusterNetworks != null ? build(deprecatedClusterNetworks) : null;
  }
  public ClusterNetworkEntry buildDeprecatedClusterNetwork(Integer index) {
    return this.deprecatedClusterNetworks.get(index).build();
  }
  public ClusterNetworkEntry buildFirstDeprecatedClusterNetwork() {
    return this.deprecatedClusterNetworks.get(0).build();
  }
  public ClusterNetworkEntry buildLastDeprecatedClusterNetwork() {
    return this.deprecatedClusterNetworks.get(deprecatedClusterNetworks.size() - 1).build();
  }
  public ClusterNetworkEntry buildMatchingDeprecatedClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate) {
    for (ClusterNetworkEntryBuilder item: deprecatedClusterNetworks) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingDeprecatedClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate) {
    for (ClusterNetworkEntryBuilder item: deprecatedClusterNetworks) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withDeprecatedClusterNetworks(List<ClusterNetworkEntry> deprecatedClusterNetworks) {
    if (this.deprecatedClusterNetworks != null) { _visitables.get("deprecatedClusterNetworks").removeAll(this.deprecatedClusterNetworks);}
    if (deprecatedClusterNetworks != null) {this.deprecatedClusterNetworks = new ArrayList(); for (ClusterNetworkEntry item : deprecatedClusterNetworks){this.addToDeprecatedClusterNetworks(item);}} else { this.deprecatedClusterNetworks = null;} return (A) this;
  }
  public A withDeprecatedClusterNetworks(io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntry... deprecatedClusterNetworks) {
    if (this.deprecatedClusterNetworks != null) {this.deprecatedClusterNetworks.clear();}
    if (deprecatedClusterNetworks != null) {for (ClusterNetworkEntry item :deprecatedClusterNetworks){ this.addToDeprecatedClusterNetworks(item);}} return (A) this;
  }
  public Boolean hasDeprecatedClusterNetworks() {
    return deprecatedClusterNetworks != null && !deprecatedClusterNetworks.isEmpty();
  }
  public A addNewDeprecatedClusterNetwork(String cidr,Integer hostPrefix,Integer hostSubnetLength) {
    return (A)addToDeprecatedClusterNetworks(new ClusterNetworkEntry(cidr, hostPrefix, hostSubnetLength));
  }
  public NetworkingFluent.DeprecatedClusterNetworksNested<A> addNewDeprecatedClusterNetwork() {
    return new NetworkingFluentImpl.DeprecatedClusterNetworksNestedImpl();
  }
  public NetworkingFluent.DeprecatedClusterNetworksNested<A> addNewDeprecatedClusterNetworkLike(ClusterNetworkEntry item) {
    return new NetworkingFluentImpl.DeprecatedClusterNetworksNestedImpl(-1, item);
  }
  public NetworkingFluent.DeprecatedClusterNetworksNested<A> setNewDeprecatedClusterNetworkLike(Integer index,ClusterNetworkEntry item) {
    return new NetworkingFluentImpl.DeprecatedClusterNetworksNestedImpl(index, item);
  }
  public NetworkingFluent.DeprecatedClusterNetworksNested<A> editDeprecatedClusterNetwork(Integer index) {
    if (deprecatedClusterNetworks.size() <= index) throw new RuntimeException("Can't edit deprecatedClusterNetworks. Index exceeds size.");
    return setNewDeprecatedClusterNetworkLike(index, buildDeprecatedClusterNetwork(index));
  }
  public NetworkingFluent.DeprecatedClusterNetworksNested<A> editFirstDeprecatedClusterNetwork() {
    if (deprecatedClusterNetworks.size() == 0) throw new RuntimeException("Can't edit first deprecatedClusterNetworks. The list is empty.");
    return setNewDeprecatedClusterNetworkLike(0, buildDeprecatedClusterNetwork(0));
  }
  public NetworkingFluent.DeprecatedClusterNetworksNested<A> editLastDeprecatedClusterNetwork() {
    int index = deprecatedClusterNetworks.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last deprecatedClusterNetworks. The list is empty.");
    return setNewDeprecatedClusterNetworkLike(index, buildDeprecatedClusterNetwork(index));
  }
  public NetworkingFluent.DeprecatedClusterNetworksNested<A> editMatchingDeprecatedClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate) {
    int index = -1;
    for (int i=0;i<deprecatedClusterNetworks.size();i++) { 
    if (predicate.test(deprecatedClusterNetworks.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching deprecatedClusterNetworks. No match found.");
    return setNewDeprecatedClusterNetworkLike(index, buildDeprecatedClusterNetwork(index));
  }
  public String getMachineCIDR() {
    return this.machineCIDR;
  }
  public A withMachineCIDR(String machineCIDR) {
    this.machineCIDR=machineCIDR; return (A) this;
  }
  public Boolean hasMachineCIDR() {
    return this.machineCIDR != null;
  }
  public A addToMachineNetwork(Integer index,MachineNetworkEntry item) {
    if (this.machineNetwork == null) {this.machineNetwork = new ArrayList<MachineNetworkEntryBuilder>();}
    MachineNetworkEntryBuilder builder = new MachineNetworkEntryBuilder(item);_visitables.get("machineNetwork").add(index >= 0 ? index : _visitables.get("machineNetwork").size(), builder);this.machineNetwork.add(index >= 0 ? index : machineNetwork.size(), builder); return (A)this;
  }
  public A setToMachineNetwork(Integer index,MachineNetworkEntry item) {
    if (this.machineNetwork == null) {this.machineNetwork = new ArrayList<MachineNetworkEntryBuilder>();}
    MachineNetworkEntryBuilder builder = new MachineNetworkEntryBuilder(item);
    if (index < 0 || index >= _visitables.get("machineNetwork").size()) { _visitables.get("machineNetwork").add(builder); } else { _visitables.get("machineNetwork").set(index, builder);}
    if (index < 0 || index >= machineNetwork.size()) { machineNetwork.add(builder); } else { machineNetwork.set(index, builder);}
     return (A)this;
  }
  public A addToMachineNetwork(io.fabric8.openshift.api.model.installer.v1.MachineNetworkEntry... items) {
    if (this.machineNetwork == null) {this.machineNetwork = new ArrayList<MachineNetworkEntryBuilder>();}
    for (MachineNetworkEntry item : items) {MachineNetworkEntryBuilder builder = new MachineNetworkEntryBuilder(item);_visitables.get("machineNetwork").add(builder);this.machineNetwork.add(builder);} return (A)this;
  }
  public A addAllToMachineNetwork(Collection<MachineNetworkEntry> items) {
    if (this.machineNetwork == null) {this.machineNetwork = new ArrayList<MachineNetworkEntryBuilder>();}
    for (MachineNetworkEntry item : items) {MachineNetworkEntryBuilder builder = new MachineNetworkEntryBuilder(item);_visitables.get("machineNetwork").add(builder);this.machineNetwork.add(builder);} return (A)this;
  }
  public A removeFromMachineNetwork(io.fabric8.openshift.api.model.installer.v1.MachineNetworkEntry... items) {
    for (MachineNetworkEntry item : items) {MachineNetworkEntryBuilder builder = new MachineNetworkEntryBuilder(item);_visitables.get("machineNetwork").remove(builder);if (this.machineNetwork != null) {this.machineNetwork.remove(builder);}} return (A)this;
  }
  public A removeAllFromMachineNetwork(Collection<MachineNetworkEntry> items) {
    for (MachineNetworkEntry item : items) {MachineNetworkEntryBuilder builder = new MachineNetworkEntryBuilder(item);_visitables.get("machineNetwork").remove(builder);if (this.machineNetwork != null) {this.machineNetwork.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromMachineNetwork(Predicate<MachineNetworkEntryBuilder> predicate) {
    if (machineNetwork == null) return (A) this;
    final Iterator<MachineNetworkEntryBuilder> each = machineNetwork.iterator();
    final List visitables = _visitables.get("machineNetwork");
    while (each.hasNext()) {
      MachineNetworkEntryBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildMachineNetwork instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<MachineNetworkEntry> getMachineNetwork() {
    return machineNetwork != null ? build(machineNetwork) : null;
  }
  public List<MachineNetworkEntry> buildMachineNetwork() {
    return machineNetwork != null ? build(machineNetwork) : null;
  }
  public MachineNetworkEntry buildMachineNetwork(Integer index) {
    return this.machineNetwork.get(index).build();
  }
  public MachineNetworkEntry buildFirstMachineNetwork() {
    return this.machineNetwork.get(0).build();
  }
  public MachineNetworkEntry buildLastMachineNetwork() {
    return this.machineNetwork.get(machineNetwork.size() - 1).build();
  }
  public MachineNetworkEntry buildMatchingMachineNetwork(Predicate<MachineNetworkEntryBuilder> predicate) {
    for (MachineNetworkEntryBuilder item: machineNetwork) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingMachineNetwork(Predicate<MachineNetworkEntryBuilder> predicate) {
    for (MachineNetworkEntryBuilder item: machineNetwork) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withMachineNetwork(List<MachineNetworkEntry> machineNetwork) {
    if (this.machineNetwork != null) { _visitables.get("machineNetwork").removeAll(this.machineNetwork);}
    if (machineNetwork != null) {this.machineNetwork = new ArrayList(); for (MachineNetworkEntry item : machineNetwork){this.addToMachineNetwork(item);}} else { this.machineNetwork = null;} return (A) this;
  }
  public A withMachineNetwork(io.fabric8.openshift.api.model.installer.v1.MachineNetworkEntry... machineNetwork) {
    if (this.machineNetwork != null) {this.machineNetwork.clear();}
    if (machineNetwork != null) {for (MachineNetworkEntry item :machineNetwork){ this.addToMachineNetwork(item);}} return (A) this;
  }
  public Boolean hasMachineNetwork() {
    return machineNetwork != null && !machineNetwork.isEmpty();
  }
  public A addNewMachineNetwork(String cidr) {
    return (A)addToMachineNetwork(new MachineNetworkEntry(cidr));
  }
  public NetworkingFluent.MachineNetworkNested<A> addNewMachineNetwork() {
    return new NetworkingFluentImpl.MachineNetworkNestedImpl();
  }
  public NetworkingFluent.MachineNetworkNested<A> addNewMachineNetworkLike(MachineNetworkEntry item) {
    return new NetworkingFluentImpl.MachineNetworkNestedImpl(-1, item);
  }
  public NetworkingFluent.MachineNetworkNested<A> setNewMachineNetworkLike(Integer index,MachineNetworkEntry item) {
    return new NetworkingFluentImpl.MachineNetworkNestedImpl(index, item);
  }
  public NetworkingFluent.MachineNetworkNested<A> editMachineNetwork(Integer index) {
    if (machineNetwork.size() <= index) throw new RuntimeException("Can't edit machineNetwork. Index exceeds size.");
    return setNewMachineNetworkLike(index, buildMachineNetwork(index));
  }
  public NetworkingFluent.MachineNetworkNested<A> editFirstMachineNetwork() {
    if (machineNetwork.size() == 0) throw new RuntimeException("Can't edit first machineNetwork. The list is empty.");
    return setNewMachineNetworkLike(0, buildMachineNetwork(0));
  }
  public NetworkingFluent.MachineNetworkNested<A> editLastMachineNetwork() {
    int index = machineNetwork.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last machineNetwork. The list is empty.");
    return setNewMachineNetworkLike(index, buildMachineNetwork(index));
  }
  public NetworkingFluent.MachineNetworkNested<A> editMatchingMachineNetwork(Predicate<MachineNetworkEntryBuilder> predicate) {
    int index = -1;
    for (int i=0;i<machineNetwork.size();i++) { 
    if (predicate.test(machineNetwork.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching machineNetwork. No match found.");
    return setNewMachineNetworkLike(index, buildMachineNetwork(index));
  }
  public String getNetworkType() {
    return this.networkType;
  }
  public A withNetworkType(String networkType) {
    this.networkType=networkType; return (A) this;
  }
  public Boolean hasNetworkType() {
    return this.networkType != null;
  }
  public String getServiceCIDR() {
    return this.serviceCIDR;
  }
  public A withServiceCIDR(String serviceCIDR) {
    this.serviceCIDR=serviceCIDR; return (A) this;
  }
  public Boolean hasServiceCIDR() {
    return this.serviceCIDR != null;
  }
  public A addToServiceNetwork(Integer index,String item) {
    if (this.serviceNetwork == null) {this.serviceNetwork = new ArrayList<String>();}
    this.serviceNetwork.add(index, item);
    return (A)this;
  }
  public A setToServiceNetwork(Integer index,String item) {
    if (this.serviceNetwork == null) {this.serviceNetwork = new ArrayList<String>();}
    this.serviceNetwork.set(index, item); return (A)this;
  }
  public A addToServiceNetwork(java.lang.String... items) {
    if (this.serviceNetwork == null) {this.serviceNetwork = new ArrayList<String>();}
    for (String item : items) {this.serviceNetwork.add(item);} return (A)this;
  }
  public A addAllToServiceNetwork(Collection<String> items) {
    if (this.serviceNetwork == null) {this.serviceNetwork = new ArrayList<String>();}
    for (String item : items) {this.serviceNetwork.add(item);} return (A)this;
  }
  public A removeFromServiceNetwork(java.lang.String... items) {
    for (String item : items) {if (this.serviceNetwork!= null){ this.serviceNetwork.remove(item);}} return (A)this;
  }
  public A removeAllFromServiceNetwork(Collection<String> items) {
    for (String item : items) {if (this.serviceNetwork!= null){ this.serviceNetwork.remove(item);}} return (A)this;
  }
  public List<String> getServiceNetwork() {
    return this.serviceNetwork;
  }
  public String getServiceNetwork(Integer index) {
    return this.serviceNetwork.get(index);
  }
  public String getFirstServiceNetwork() {
    return this.serviceNetwork.get(0);
  }
  public String getLastServiceNetwork() {
    return this.serviceNetwork.get(serviceNetwork.size() - 1);
  }
  public String getMatchingServiceNetwork(Predicate<String> predicate) {
    for (String item: serviceNetwork) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingServiceNetwork(Predicate<String> predicate) {
    for (String item: serviceNetwork) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withServiceNetwork(List<String> serviceNetwork) {
    if (serviceNetwork != null) {this.serviceNetwork = new ArrayList(); for (String item : serviceNetwork){this.addToServiceNetwork(item);}} else { this.serviceNetwork = null;} return (A) this;
  }
  public A withServiceNetwork(java.lang.String... serviceNetwork) {
    if (this.serviceNetwork != null) {this.serviceNetwork.clear();}
    if (serviceNetwork != null) {for (String item :serviceNetwork){ this.addToServiceNetwork(item);}} return (A) this;
  }
  public Boolean hasServiceNetwork() {
    return serviceNetwork != null && !serviceNetwork.isEmpty();
  }
  public String getType() {
    return this.type;
  }
  public A withType(String type) {
    this.type=type; return (A) this;
  }
  public Boolean hasType() {
    return this.type != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    NetworkingFluentImpl that = (NetworkingFluentImpl) o;
    if (clusterNetwork != null ? !clusterNetwork.equals(that.clusterNetwork) :that.clusterNetwork != null) return false;
    if (deprecatedClusterNetworks != null ? !deprecatedClusterNetworks.equals(that.deprecatedClusterNetworks) :that.deprecatedClusterNetworks != null) return false;
    if (machineCIDR != null ? !machineCIDR.equals(that.machineCIDR) :that.machineCIDR != null) return false;
    if (machineNetwork != null ? !machineNetwork.equals(that.machineNetwork) :that.machineNetwork != null) return false;
    if (networkType != null ? !networkType.equals(that.networkType) :that.networkType != null) return false;
    if (serviceCIDR != null ? !serviceCIDR.equals(that.serviceCIDR) :that.serviceCIDR != null) return false;
    if (serviceNetwork != null ? !serviceNetwork.equals(that.serviceNetwork) :that.serviceNetwork != null) return false;
    if (type != null ? !type.equals(that.type) :that.type != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(clusterNetwork,  deprecatedClusterNetworks,  machineCIDR,  machineNetwork,  networkType,  serviceCIDR,  serviceNetwork,  type,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (clusterNetwork != null && !clusterNetwork.isEmpty()) { sb.append("clusterNetwork:"); sb.append(clusterNetwork + ","); }
    if (deprecatedClusterNetworks != null && !deprecatedClusterNetworks.isEmpty()) { sb.append("deprecatedClusterNetworks:"); sb.append(deprecatedClusterNetworks + ","); }
    if (machineCIDR != null) { sb.append("machineCIDR:"); sb.append(machineCIDR + ","); }
    if (machineNetwork != null && !machineNetwork.isEmpty()) { sb.append("machineNetwork:"); sb.append(machineNetwork + ","); }
    if (networkType != null) { sb.append("networkType:"); sb.append(networkType + ","); }
    if (serviceCIDR != null) { sb.append("serviceCIDR:"); sb.append(serviceCIDR + ","); }
    if (serviceNetwork != null && !serviceNetwork.isEmpty()) { sb.append("serviceNetwork:"); sb.append(serviceNetwork + ","); }
    if (type != null) { sb.append("type:"); sb.append(type + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class ClusterNetworkNestedImpl<N> extends ClusterNetworkEntryFluentImpl<NetworkingFluent.ClusterNetworkNested<N>> implements NetworkingFluent.ClusterNetworkNested<N>,Nested<N>{
    ClusterNetworkNestedImpl(Integer index,ClusterNetworkEntry item) {
      this.index = index;
      this.builder = new ClusterNetworkEntryBuilder(this, item);
    }
    ClusterNetworkNestedImpl() {
      this.index = -1;
      this.builder = new ClusterNetworkEntryBuilder(this);
    }
    ClusterNetworkEntryBuilder builder;
    Integer index;
    public N and() {
      return (N) NetworkingFluentImpl.this.setToClusterNetwork(index,builder.build());
    }
    public N endClusterNetwork() {
      return and();
    }
    
  }
  class DeprecatedClusterNetworksNestedImpl<N> extends ClusterNetworkEntryFluentImpl<NetworkingFluent.DeprecatedClusterNetworksNested<N>> implements NetworkingFluent.DeprecatedClusterNetworksNested<N>,Nested<N>{
    DeprecatedClusterNetworksNestedImpl(Integer index,ClusterNetworkEntry item) {
      this.index = index;
      this.builder = new ClusterNetworkEntryBuilder(this, item);
    }
    DeprecatedClusterNetworksNestedImpl() {
      this.index = -1;
      this.builder = new ClusterNetworkEntryBuilder(this);
    }
    ClusterNetworkEntryBuilder builder;
    Integer index;
    public N and() {
      return (N) NetworkingFluentImpl.this.setToDeprecatedClusterNetworks(index,builder.build());
    }
    public N endDeprecatedClusterNetwork() {
      return and();
    }
    
  }
  class MachineNetworkNestedImpl<N> extends MachineNetworkEntryFluentImpl<NetworkingFluent.MachineNetworkNested<N>> implements NetworkingFluent.MachineNetworkNested<N>,Nested<N>{
    MachineNetworkNestedImpl(Integer index,MachineNetworkEntry item) {
      this.index = index;
      this.builder = new MachineNetworkEntryBuilder(this, item);
    }
    MachineNetworkNestedImpl() {
      this.index = -1;
      this.builder = new MachineNetworkEntryBuilder(this);
    }
    MachineNetworkEntryBuilder builder;
    Integer index;
    public N and() {
      return (N) NetworkingFluentImpl.this.setToMachineNetwork(index,builder.build());
    }
    public N endMachineNetwork() {
      return and();
    }
    
  }
  
}