package io.fabric8.openshift.api.model.installer.openstack.v1;

import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface PlatformFluent<A extends PlatformFluent<A>> extends Fluent<A>{
  public String getApiFloatingIP();
  public A withApiFloatingIP(String apiFloatingIP);
  public Boolean hasApiFloatingIP();
  public String getApiVIP();
  public A withApiVIP(String apiVIP);
  public Boolean hasApiVIP();
  public String getCloud();
  public A withCloud(String cloud);
  public Boolean hasCloud();
  public String getClusterOSImage();
  public A withClusterOSImage(String clusterOSImage);
  public Boolean hasClusterOSImage();
  public A addToClusterOSImageProperties(String key,String value);
  public A addToClusterOSImageProperties(Map<String,String> map);
  public A removeFromClusterOSImageProperties(String key);
  public A removeFromClusterOSImageProperties(Map<String,String> map);
  public Map<String,String> getClusterOSImageProperties();
  public <K,V>A withClusterOSImageProperties(Map<String,String> clusterOSImageProperties);
  public Boolean hasClusterOSImageProperties();
  public String getComputeFlavor();
  public A withComputeFlavor(String computeFlavor);
  public Boolean hasComputeFlavor();
  
  /**
   * This method has been deprecated, please use method buildDefaultMachinePlatform instead.
   * @return The buildable object.
   */
  @Deprecated
  public MachinePool getDefaultMachinePlatform();
  public MachinePool buildDefaultMachinePlatform();
  public A withDefaultMachinePlatform(MachinePool defaultMachinePlatform);
  public Boolean hasDefaultMachinePlatform();
  public PlatformFluent.DefaultMachinePlatformNested<A> withNewDefaultMachinePlatform();
  public PlatformFluent.DefaultMachinePlatformNested<A> withNewDefaultMachinePlatformLike(MachinePool item);
  public PlatformFluent.DefaultMachinePlatformNested<A> editDefaultMachinePlatform();
  public PlatformFluent.DefaultMachinePlatformNested<A> editOrNewDefaultMachinePlatform();
  public PlatformFluent.DefaultMachinePlatformNested<A> editOrNewDefaultMachinePlatformLike(MachinePool item);
  public A addToExternalDNS(Integer index,String item);
  public A setToExternalDNS(Integer index,String item);
  public A addToExternalDNS(java.lang.String... items);
  public A addAllToExternalDNS(Collection<String> items);
  public A removeFromExternalDNS(java.lang.String... items);
  public A removeAllFromExternalDNS(Collection<String> items);
  public List<String> getExternalDNS();
  public String getExternalDN(Integer index);
  public String getFirstExternalDN();
  public String getLastExternalDN();
  public String getMatchingExternalDN(Predicate<String> predicate);
  public Boolean hasMatchingExternalDN(Predicate<String> predicate);
  public A withExternalDNS(List<String> externalDNS);
  public A withExternalDNS(java.lang.String... externalDNS);
  public Boolean hasExternalDNS();
  public String getExternalNetwork();
  public A withExternalNetwork(String externalNetwork);
  public Boolean hasExternalNetwork();
  public String getIngressFloatingIP();
  public A withIngressFloatingIP(String ingressFloatingIP);
  public Boolean hasIngressFloatingIP();
  public String getIngressVIP();
  public A withIngressVIP(String ingressVIP);
  public Boolean hasIngressVIP();
  public String getLbFloatingIP();
  public A withLbFloatingIP(String lbFloatingIP);
  public Boolean hasLbFloatingIP();
  public String getMachinesSubnet();
  public A withMachinesSubnet(String machinesSubnet);
  public Boolean hasMachinesSubnet();
  public String getOctaviaSupport();
  public A withOctaviaSupport(String octaviaSupport);
  public Boolean hasOctaviaSupport();
  public String getRegion();
  public A withRegion(String region);
  public Boolean hasRegion();
  public String getTrunkSupport();
  public A withTrunkSupport(String trunkSupport);
  public Boolean hasTrunkSupport();
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface DefaultMachinePlatformNested<N> extends Nested<N>,MachinePoolFluent<PlatformFluent.DefaultMachinePlatformNested<N>>{
    public N and();
    public N endDefaultMachinePlatform();
    
  }
  
}