package io.fabric8.openshift.api.model.installer.alibabacloud.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PlatformBuilder extends PlatformFluentImpl<PlatformBuilder> implements VisitableBuilder<Platform,PlatformBuilder>{
  public PlatformBuilder() {
    this(false);
  }
  public PlatformBuilder(Boolean validationEnabled) {
    this(new Platform(), validationEnabled);
  }
  public PlatformBuilder(PlatformFluent<?> fluent) {
    this(fluent, false);
  }
  public PlatformBuilder(PlatformFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Platform(), validationEnabled);
  }
  public PlatformBuilder(PlatformFluent<?> fluent,Platform instance) {
    this(fluent, instance, false);
  }
  public PlatformBuilder(PlatformFluent<?> fluent,Platform instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withDefaultMachinePlatform(instance.getDefaultMachinePlatform()); 
    fluent.withPrivateZoneID(instance.getPrivateZoneID()); 
    fluent.withRegion(instance.getRegion()); 
    fluent.withResourceGroupID(instance.getResourceGroupID()); 
    fluent.withTags(instance.getTags()); 
    fluent.withVpcID(instance.getVpcID()); 
    fluent.withVswitchIDs(instance.getVswitchIDs()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public PlatformBuilder(Platform instance) {
    this(instance,false);
  }
  public PlatformBuilder(Platform instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withDefaultMachinePlatform(instance.getDefaultMachinePlatform()); 
    this.withPrivateZoneID(instance.getPrivateZoneID()); 
    this.withRegion(instance.getRegion()); 
    this.withResourceGroupID(instance.getResourceGroupID()); 
    this.withTags(instance.getTags()); 
    this.withVpcID(instance.getVpcID()); 
    this.withVswitchIDs(instance.getVswitchIDs()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  PlatformFluent<?> fluent;
  Boolean validationEnabled;
  public Platform build() {
    Platform buildable = new Platform(fluent.getDefaultMachinePlatform(),fluent.getPrivateZoneID(),fluent.getRegion(),fluent.getResourceGroupID(),fluent.getTags(),fluent.getVpcID(),fluent.getVswitchIDs());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}