package io.fabric8.openshift.api.model.installer.vsphere.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class MachinePoolFluentImpl<A extends MachinePoolFluent<A>> extends BaseFluent<A> implements MachinePoolFluent<A>{
  public MachinePoolFluentImpl() {
  }
  public MachinePoolFluentImpl(MachinePool instance) {
    this.withCoresPerSocket(instance.getCoresPerSocket()); 
    this.withCpus(instance.getCpus()); 
    this.withMemoryMB(instance.getMemoryMB()); 
    this.withOsDisk(instance.getOsDisk()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private Integer coresPerSocket;
  private Integer cpus;
  private Long memoryMB;
  private OSDiskBuilder osDisk;
  private Map<String,Object> additionalProperties;
  public Integer getCoresPerSocket() {
    return this.coresPerSocket;
  }
  public A withCoresPerSocket(Integer coresPerSocket) {
    this.coresPerSocket=coresPerSocket; return (A) this;
  }
  public Boolean hasCoresPerSocket() {
    return this.coresPerSocket != null;
  }
  public Integer getCpus() {
    return this.cpus;
  }
  public A withCpus(Integer cpus) {
    this.cpus=cpus; return (A) this;
  }
  public Boolean hasCpus() {
    return this.cpus != null;
  }
  public Long getMemoryMB() {
    return this.memoryMB;
  }
  public A withMemoryMB(Long memoryMB) {
    this.memoryMB=memoryMB; return (A) this;
  }
  public Boolean hasMemoryMB() {
    return this.memoryMB != null;
  }
  
  /**
   * This method has been deprecated, please use method buildOsDisk instead.
   * @return The buildable object.
   */
  @Deprecated
  public OSDisk getOsDisk() {
    return this.osDisk!=null ?this.osDisk.build():null;
  }
  public OSDisk buildOsDisk() {
    return this.osDisk!=null ?this.osDisk.build():null;
  }
  public A withOsDisk(OSDisk osDisk) {
    _visitables.get("osDisk").remove(this.osDisk);
    if (osDisk!=null){ this.osDisk= new OSDiskBuilder(osDisk); _visitables.get("osDisk").add(this.osDisk);} else { this.osDisk = null; _visitables.get("osDisk").remove(this.osDisk); } return (A) this;
  }
  public Boolean hasOsDisk() {
    return this.osDisk != null;
  }
  public A withNewOsDisk(Integer diskSizeGB) {
    return (A)withOsDisk(new OSDisk(diskSizeGB));
  }
  public MachinePoolFluent.OsDiskNested<A> withNewOsDisk() {
    return new MachinePoolFluentImpl.OsDiskNestedImpl();
  }
  public MachinePoolFluent.OsDiskNested<A> withNewOsDiskLike(OSDisk item) {
    return new MachinePoolFluentImpl.OsDiskNestedImpl(item);
  }
  public MachinePoolFluent.OsDiskNested<A> editOsDisk() {
    return withNewOsDiskLike(getOsDisk());
  }
  public MachinePoolFluent.OsDiskNested<A> editOrNewOsDisk() {
    return withNewOsDiskLike(getOsDisk() != null ? getOsDisk(): new OSDiskBuilder().build());
  }
  public MachinePoolFluent.OsDiskNested<A> editOrNewOsDiskLike(OSDisk item) {
    return withNewOsDiskLike(getOsDisk() != null ? getOsDisk(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MachinePoolFluentImpl that = (MachinePoolFluentImpl) o;
    if (coresPerSocket != null ? !coresPerSocket.equals(that.coresPerSocket) :that.coresPerSocket != null) return false;
    if (cpus != null ? !cpus.equals(that.cpus) :that.cpus != null) return false;
    if (memoryMB != null ? !memoryMB.equals(that.memoryMB) :that.memoryMB != null) return false;
    if (osDisk != null ? !osDisk.equals(that.osDisk) :that.osDisk != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(coresPerSocket,  cpus,  memoryMB,  osDisk,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (coresPerSocket != null) { sb.append("coresPerSocket:"); sb.append(coresPerSocket + ","); }
    if (cpus != null) { sb.append("cpus:"); sb.append(cpus + ","); }
    if (memoryMB != null) { sb.append("memoryMB:"); sb.append(memoryMB + ","); }
    if (osDisk != null) { sb.append("osDisk:"); sb.append(osDisk + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class OsDiskNestedImpl<N> extends OSDiskFluentImpl<MachinePoolFluent.OsDiskNested<N>> implements MachinePoolFluent.OsDiskNested<N>,Nested<N>{
    OsDiskNestedImpl(OSDisk item) {
      this.builder = new OSDiskBuilder(this, item);
    }
    OsDiskNestedImpl() {
      this.builder = new OSDiskBuilder(this);
    }
    OSDiskBuilder builder;
    public N and() {
      return (N) MachinePoolFluentImpl.this.withOsDisk(builder.build());
    }
    public N endOsDisk() {
      return and();
    }
    
  }
  
}