package io.fabric8.openshift.api.model.installer.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class InstallConfigBuilder extends InstallConfigFluentImpl<InstallConfigBuilder> implements VisitableBuilder<InstallConfig,InstallConfigBuilder>{
  public InstallConfigBuilder() {
    this(false);
  }
  public InstallConfigBuilder(Boolean validationEnabled) {
    this(new InstallConfig(), validationEnabled);
  }
  public InstallConfigBuilder(InstallConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public InstallConfigBuilder(InstallConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new InstallConfig(), validationEnabled);
  }
  public InstallConfigBuilder(InstallConfigFluent<?> fluent,InstallConfig instance) {
    this(fluent, instance, false);
  }
  public InstallConfigBuilder(InstallConfigFluent<?> fluent,InstallConfig instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAdditionalTrustBundle(instance.getAdditionalTrustBundle()); 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withBaseDomain(instance.getBaseDomain()); 
    fluent.withBootstrapInPlace(instance.getBootstrapInPlace()); 
    fluent.withCompute(instance.getCompute()); 
    fluent.withControlPlane(instance.getControlPlane()); 
    fluent.withCredentialsMode(instance.getCredentialsMode()); 
    fluent.withFips(instance.getFips()); 
    fluent.withImageContentSources(instance.getImageContentSources()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withNetworking(instance.getNetworking()); 
    fluent.withPlatform(instance.getPlatform()); 
    fluent.withProxy(instance.getProxy()); 
    fluent.withPublish(instance.getPublish()); 
    fluent.withPullSecret(instance.getPullSecret()); 
    fluent.withSshKey(instance.getSshKey()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public InstallConfigBuilder(InstallConfig instance) {
    this(instance,false);
  }
  public InstallConfigBuilder(InstallConfig instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAdditionalTrustBundle(instance.getAdditionalTrustBundle()); 
    this.withApiVersion(instance.getApiVersion()); 
    this.withBaseDomain(instance.getBaseDomain()); 
    this.withBootstrapInPlace(instance.getBootstrapInPlace()); 
    this.withCompute(instance.getCompute()); 
    this.withControlPlane(instance.getControlPlane()); 
    this.withCredentialsMode(instance.getCredentialsMode()); 
    this.withFips(instance.getFips()); 
    this.withImageContentSources(instance.getImageContentSources()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withNetworking(instance.getNetworking()); 
    this.withPlatform(instance.getPlatform()); 
    this.withProxy(instance.getProxy()); 
    this.withPublish(instance.getPublish()); 
    this.withPullSecret(instance.getPullSecret()); 
    this.withSshKey(instance.getSshKey()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  InstallConfigFluent<?> fluent;
  Boolean validationEnabled;
  public InstallConfig build() {
    InstallConfig buildable = new InstallConfig(fluent.getAdditionalTrustBundle(),fluent.getApiVersion(),fluent.getBaseDomain(),fluent.getBootstrapInPlace(),fluent.getCompute(),fluent.getControlPlane(),fluent.getCredentialsMode(),fluent.getFips(),fluent.getImageContentSources(),fluent.getKind(),fluent.getMetadata(),fluent.getNetworking(),fluent.getPlatform(),fluent.getProxy(),fluent.getPublish(),fluent.getPullSecret(),fluent.getSshKey());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}