package io.fabric8.openshift.api.model.installer.ovirt.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CPUBuilder extends CPUFluentImpl<CPUBuilder> implements VisitableBuilder<CPU,CPUBuilder>{
  public CPUBuilder() {
    this(false);
  }
  public CPUBuilder(Boolean validationEnabled) {
    this(new CPU(), validationEnabled);
  }
  public CPUBuilder(CPUFluent<?> fluent) {
    this(fluent, false);
  }
  public CPUBuilder(CPUFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CPU(), validationEnabled);
  }
  public CPUBuilder(CPUFluent<?> fluent,CPU instance) {
    this(fluent, instance, false);
  }
  public CPUBuilder(CPUFluent<?> fluent,CPU instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withCores(instance.getCores()); 
    fluent.withSockets(instance.getSockets()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public CPUBuilder(CPU instance) {
    this(instance,false);
  }
  public CPUBuilder(CPU instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withCores(instance.getCores()); 
    this.withSockets(instance.getSockets()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  CPUFluent<?> fluent;
  Boolean validationEnabled;
  public CPU build() {
    CPU buildable = new CPU(fluent.getCores(),fluent.getSockets());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}