package io.fabric8.openshift.api.model.installer.libvirt.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class DnsmasqOptionBuilder extends DnsmasqOptionFluent<DnsmasqOptionBuilder> implements VisitableBuilder<DnsmasqOption,DnsmasqOptionBuilder>{
  public DnsmasqOptionBuilder() {
    this(new DnsmasqOption());
  }
  
  public DnsmasqOptionBuilder(DnsmasqOptionFluent<?> fluent) {
    this(fluent, new DnsmasqOption());
  }
  
  public DnsmasqOptionBuilder(DnsmasqOptionFluent<?> fluent,DnsmasqOption instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public DnsmasqOptionBuilder(DnsmasqOption instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  DnsmasqOptionFluent<?> fluent;
  
  public DnsmasqOption build() {
    DnsmasqOption buildable = new DnsmasqOption(fluent.getName(),fluent.getValue());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}