/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.installer.baremetal.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.installer.baremetal.v1.Host;
import io.fabric8.openshift.api.model.installer.baremetal.v1.HostFluent;
import io.fabric8.openshift.api.model.installer.baremetal.v1.HostFluentImpl;
import java.util.Objects;

public class HostBuilder
extends HostFluentImpl<HostBuilder>
implements VisitableBuilder<Host, HostBuilder> {
    HostFluent<?> fluent;
    Boolean validationEnabled;

    public HostBuilder() {
        this(false);
    }

    public HostBuilder(Boolean validationEnabled) {
        this(new Host(), validationEnabled);
    }

    public HostBuilder(HostFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public HostBuilder(HostFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Host(), validationEnabled);
    }

    public HostBuilder(HostFluent<?> fluent, Host instance) {
        this(fluent, instance, false);
    }

    public HostBuilder(HostFluent<?> fluent, Host instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withBmc(instance.getBmc());
        fluent.withBootMACAddress(instance.getBootMACAddress());
        fluent.withBootMode(instance.getBootMode());
        fluent.withHardwareProfile(instance.getHardwareProfile());
        fluent.withName(instance.getName());
        fluent.withNetworkConfig(instance.getNetworkConfig());
        fluent.withRole(instance.getRole());
        fluent.withRootDeviceHints(instance.getRootDeviceHints());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public HostBuilder(Host instance) {
        this(instance, (Boolean)false);
    }

    public HostBuilder(Host instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withBmc(instance.getBmc());
        this.withBootMACAddress(instance.getBootMACAddress());
        this.withBootMode(instance.getBootMode());
        this.withHardwareProfile(instance.getHardwareProfile());
        this.withName(instance.getName());
        this.withNetworkConfig(instance.getNetworkConfig());
        this.withRole(instance.getRole());
        this.withRootDeviceHints(instance.getRootDeviceHints());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public Host build() {
        Host buildable = new Host(this.fluent.getBmc(), this.fluent.getBootMACAddress(), this.fluent.getBootMode(), this.fluent.getHardwareProfile(), this.fluent.getName(), this.fluent.getNetworkConfig(), this.fluent.getRole(), this.fluent.getRootDeviceHints());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HostBuilder that = (HostBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

