package io.fabric8.openshift.api.model.console.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ConsolePluginProxyServiceBuilder extends ConsolePluginProxyServiceFluentImpl<ConsolePluginProxyServiceBuilder> implements VisitableBuilder<ConsolePluginProxyService,ConsolePluginProxyServiceBuilder>{
  public ConsolePluginProxyServiceBuilder() {
    this(false);
  }
  public ConsolePluginProxyServiceBuilder(Boolean validationEnabled) {
    this(new ConsolePluginProxyService(), validationEnabled);
  }
  public ConsolePluginProxyServiceBuilder(ConsolePluginProxyServiceFluent<?> fluent) {
    this(fluent, false);
  }
  public ConsolePluginProxyServiceBuilder(ConsolePluginProxyServiceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ConsolePluginProxyService(), validationEnabled);
  }
  public ConsolePluginProxyServiceBuilder(ConsolePluginProxyServiceFluent<?> fluent,ConsolePluginProxyService instance) {
    this(fluent, instance, false);
  }
  public ConsolePluginProxyServiceBuilder(ConsolePluginProxyServiceFluent<?> fluent,ConsolePluginProxyService instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAuthorize(instance.getAuthorize()); 
    fluent.withCaCertificate(instance.getCaCertificate()); 
    fluent.withName(instance.getName()); 
    fluent.withNamespace(instance.getNamespace()); 
    fluent.withPort(instance.getPort()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ConsolePluginProxyServiceBuilder(ConsolePluginProxyService instance) {
    this(instance,false);
  }
  public ConsolePluginProxyServiceBuilder(ConsolePluginProxyService instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAuthorize(instance.getAuthorize()); 
    this.withCaCertificate(instance.getCaCertificate()); 
    this.withName(instance.getName()); 
    this.withNamespace(instance.getNamespace()); 
    this.withPort(instance.getPort()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ConsolePluginProxyServiceFluent<?> fluent;
  Boolean validationEnabled;
  public ConsolePluginProxyService build() {
    ConsolePluginProxyService buildable = new ConsolePluginProxyService(fluent.getAuthorize(),fluent.getCaCertificate(),fluent.getName(),fluent.getNamespace(),fluent.getPort());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}