package io.fabric8.openshift.api.model.console.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ConsoleLinkSpecBuilder extends ConsoleLinkSpecFluentImpl<ConsoleLinkSpecBuilder> implements VisitableBuilder<ConsoleLinkSpec,ConsoleLinkSpecBuilder>{
  public ConsoleLinkSpecBuilder() {
    this(false);
  }
  public ConsoleLinkSpecBuilder(Boolean validationEnabled) {
    this(new ConsoleLinkSpec(), validationEnabled);
  }
  public ConsoleLinkSpecBuilder(ConsoleLinkSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ConsoleLinkSpecBuilder(ConsoleLinkSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ConsoleLinkSpec(), validationEnabled);
  }
  public ConsoleLinkSpecBuilder(ConsoleLinkSpecFluent<?> fluent,ConsoleLinkSpec instance) {
    this(fluent, instance, false);
  }
  public ConsoleLinkSpecBuilder(ConsoleLinkSpecFluent<?> fluent,ConsoleLinkSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApplicationMenu(instance.getApplicationMenu()); 
    fluent.withHref(instance.getHref()); 
    fluent.withLocation(instance.getLocation()); 
    fluent.withNamespaceDashboard(instance.getNamespaceDashboard()); 
    fluent.withText(instance.getText()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ConsoleLinkSpecBuilder(ConsoleLinkSpec instance) {
    this(instance,false);
  }
  public ConsoleLinkSpecBuilder(ConsoleLinkSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApplicationMenu(instance.getApplicationMenu()); 
    this.withHref(instance.getHref()); 
    this.withLocation(instance.getLocation()); 
    this.withNamespaceDashboard(instance.getNamespaceDashboard()); 
    this.withText(instance.getText()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ConsoleLinkSpecFluent<?> fluent;
  Boolean validationEnabled;
  public ConsoleLinkSpec build() {
    ConsoleLinkSpec buildable = new ConsoleLinkSpec(fluent.getApplicationMenu(),fluent.getHref(),fluent.getLocation(),fluent.getNamespaceDashboard(),fluent.getText());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}