package io.fabric8.openshift.api.model.config.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class UsernameClaimMappingFluent<A extends UsernameClaimMappingFluent<A>> extends BaseFluent<A>{
  public UsernameClaimMappingFluent() {
  }
  
  public UsernameClaimMappingFluent(UsernameClaimMapping instance) {
    this.copyInstance(instance);
  }
  private String claim;
  private UsernamePrefixBuilder prefix;
  private String prefixPolicy;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(UsernameClaimMapping instance) {
    instance = (instance != null ? instance : new UsernameClaimMapping());
    if (instance != null) {
          this.withClaim(instance.getClaim());
          this.withPrefix(instance.getPrefix());
          this.withPrefixPolicy(instance.getPrefixPolicy());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getClaim() {
    return this.claim;
  }
  
  public A withClaim(String claim) {
    this.claim = claim;
    return (A) this;
  }
  
  public boolean hasClaim() {
    return this.claim != null;
  }
  
  public UsernamePrefix buildPrefix() {
    return this.prefix != null ? this.prefix.build() : null;
  }
  
  public A withPrefix(UsernamePrefix prefix) {
    this._visitables.remove("prefix");
    if (prefix != null) {
        this.prefix = new UsernamePrefixBuilder(prefix);
        this._visitables.get("prefix").add(this.prefix);
    } else {
        this.prefix = null;
        this._visitables.get("prefix").remove(this.prefix);
    }
    return (A) this;
  }
  
  public boolean hasPrefix() {
    return this.prefix != null;
  }
  
  public A withNewPrefix(String prefixString) {
    return (A)withPrefix(new UsernamePrefix(prefixString));
  }
  
  public PrefixNested<A> withNewPrefix() {
    return new PrefixNested(null);
  }
  
  public PrefixNested<A> withNewPrefixLike(UsernamePrefix item) {
    return new PrefixNested(item);
  }
  
  public PrefixNested<A> editPrefix() {
    return withNewPrefixLike(java.util.Optional.ofNullable(buildPrefix()).orElse(null));
  }
  
  public PrefixNested<A> editOrNewPrefix() {
    return withNewPrefixLike(java.util.Optional.ofNullable(buildPrefix()).orElse(new UsernamePrefixBuilder().build()));
  }
  
  public PrefixNested<A> editOrNewPrefixLike(UsernamePrefix item) {
    return withNewPrefixLike(java.util.Optional.ofNullable(buildPrefix()).orElse(item));
  }
  
  public String getPrefixPolicy() {
    return this.prefixPolicy;
  }
  
  public A withPrefixPolicy(String prefixPolicy) {
    this.prefixPolicy = prefixPolicy;
    return (A) this;
  }
  
  public boolean hasPrefixPolicy() {
    return this.prefixPolicy != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    UsernameClaimMappingFluent that = (UsernameClaimMappingFluent) o;
    if (!java.util.Objects.equals(claim, that.claim)) return false;
    if (!java.util.Objects.equals(prefix, that.prefix)) return false;
    if (!java.util.Objects.equals(prefixPolicy, that.prefixPolicy)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(claim,  prefix,  prefixPolicy,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (claim != null) { sb.append("claim:"); sb.append(claim + ","); }
    if (prefix != null) { sb.append("prefix:"); sb.append(prefix + ","); }
    if (prefixPolicy != null) { sb.append("prefixPolicy:"); sb.append(prefixPolicy + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class PrefixNested<N> extends UsernamePrefixFluent<PrefixNested<N>> implements Nested<N>{
    PrefixNested(UsernamePrefix item) {
      this.builder = new UsernamePrefixBuilder(this, item);
    }
    UsernamePrefixBuilder builder;
    
    public N and() {
      return (N) UsernameClaimMappingFluent.this.withPrefix(builder.build());
    }
    
    public N endPrefix() {
      return and();
    }
    
  
  }

}