package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class TokenClaimValidationRuleBuilder extends TokenClaimValidationRuleFluent<TokenClaimValidationRuleBuilder> implements VisitableBuilder<TokenClaimValidationRule,TokenClaimValidationRuleBuilder>{
  public TokenClaimValidationRuleBuilder() {
    this(new TokenClaimValidationRule());
  }
  
  public TokenClaimValidationRuleBuilder(TokenClaimValidationRuleFluent<?> fluent) {
    this(fluent, new TokenClaimValidationRule());
  }
  
  public TokenClaimValidationRuleBuilder(TokenClaimValidationRuleFluent<?> fluent,TokenClaimValidationRule instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public TokenClaimValidationRuleBuilder(TokenClaimValidationRule instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  TokenClaimValidationRuleFluent<?> fluent;
  
  public TokenClaimValidationRule build() {
    TokenClaimValidationRule buildable = new TokenClaimValidationRule(fluent.buildRequiredClaim(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}