package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ReleaseBuilder extends ReleaseFluent<ReleaseBuilder> implements VisitableBuilder<Release,ReleaseBuilder>{
  public ReleaseBuilder() {
    this(new Release());
  }
  
  public ReleaseBuilder(ReleaseFluent<?> fluent) {
    this(fluent, new Release());
  }
  
  public ReleaseBuilder(ReleaseFluent<?> fluent,Release instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ReleaseBuilder(Release instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ReleaseFluent<?> fluent;
  
  public Release build() {
    Release buildable = new Release(fluent.getArchitecture(),fluent.getChannels(),fluent.getImage(),fluent.getUrl(),fluent.getVersion());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}