package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class OIDCClientStatusBuilder extends OIDCClientStatusFluent<OIDCClientStatusBuilder> implements VisitableBuilder<OIDCClientStatus,OIDCClientStatusBuilder>{
  public OIDCClientStatusBuilder() {
    this(new OIDCClientStatus());
  }
  
  public OIDCClientStatusBuilder(OIDCClientStatusFluent<?> fluent) {
    this(fluent, new OIDCClientStatus());
  }
  
  public OIDCClientStatusBuilder(OIDCClientStatusFluent<?> fluent,OIDCClientStatus instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public OIDCClientStatusBuilder(OIDCClientStatus instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  OIDCClientStatusFluent<?> fluent;
  
  public OIDCClientStatus build() {
    OIDCClientStatus buildable = new OIDCClientStatus(fluent.getComponentName(),fluent.getComponentNamespace(),fluent.getConditions(),fluent.getConsumingUsers(),fluent.buildCurrentOIDCClients());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}