package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class NutanixFailureDomainFluent<A extends NutanixFailureDomainFluent<A>> extends BaseFluent<A>{
  public NutanixFailureDomainFluent() {
  }
  
  public NutanixFailureDomainFluent(NutanixFailureDomain instance) {
    this.copyInstance(instance);
  }
  private NutanixResourceIdentifierBuilder cluster;
  private String name;
  private ArrayList<NutanixResourceIdentifierBuilder> subnets = new ArrayList<NutanixResourceIdentifierBuilder>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(NutanixFailureDomain instance) {
    instance = (instance != null ? instance : new NutanixFailureDomain());
    if (instance != null) {
          this.withCluster(instance.getCluster());
          this.withName(instance.getName());
          this.withSubnets(instance.getSubnets());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public NutanixResourceIdentifier buildCluster() {
    return this.cluster != null ? this.cluster.build() : null;
  }
  
  public A withCluster(NutanixResourceIdentifier cluster) {
    this._visitables.remove("cluster");
    if (cluster != null) {
        this.cluster = new NutanixResourceIdentifierBuilder(cluster);
        this._visitables.get("cluster").add(this.cluster);
    } else {
        this.cluster = null;
        this._visitables.get("cluster").remove(this.cluster);
    }
    return (A) this;
  }
  
  public boolean hasCluster() {
    return this.cluster != null;
  }
  
  public A withNewCluster(String name,String type,String uuid) {
    return (A)withCluster(new NutanixResourceIdentifier(name, type, uuid));
  }
  
  public ClusterNested<A> withNewCluster() {
    return new ClusterNested(null);
  }
  
  public ClusterNested<A> withNewClusterLike(NutanixResourceIdentifier item) {
    return new ClusterNested(item);
  }
  
  public ClusterNested<A> editCluster() {
    return withNewClusterLike(java.util.Optional.ofNullable(buildCluster()).orElse(null));
  }
  
  public ClusterNested<A> editOrNewCluster() {
    return withNewClusterLike(java.util.Optional.ofNullable(buildCluster()).orElse(new NutanixResourceIdentifierBuilder().build()));
  }
  
  public ClusterNested<A> editOrNewClusterLike(NutanixResourceIdentifier item) {
    return withNewClusterLike(java.util.Optional.ofNullable(buildCluster()).orElse(item));
  }
  
  public String getName() {
    return this.name;
  }
  
  public A withName(String name) {
    this.name = name;
    return (A) this;
  }
  
  public boolean hasName() {
    return this.name != null;
  }
  
  public A addToSubnets(int index,NutanixResourceIdentifier item) {
    if (this.subnets == null) {this.subnets = new ArrayList<NutanixResourceIdentifierBuilder>();}
    NutanixResourceIdentifierBuilder builder = new NutanixResourceIdentifierBuilder(item);
    if (index < 0 || index >= subnets.size()) {
        _visitables.get("subnets").add(builder);
        subnets.add(builder);
    } else {
        _visitables.get("subnets").add(builder);
        subnets.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToSubnets(int index,NutanixResourceIdentifier item) {
    if (this.subnets == null) {this.subnets = new ArrayList<NutanixResourceIdentifierBuilder>();}
    NutanixResourceIdentifierBuilder builder = new NutanixResourceIdentifierBuilder(item);
    if (index < 0 || index >= subnets.size()) {
        _visitables.get("subnets").add(builder);
        subnets.add(builder);
    } else {
        _visitables.get("subnets").add(builder);
        subnets.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToSubnets(io.fabric8.openshift.api.model.config.v1.NutanixResourceIdentifier... items) {
    if (this.subnets == null) {this.subnets = new ArrayList<NutanixResourceIdentifierBuilder>();}
    for (NutanixResourceIdentifier item : items) {NutanixResourceIdentifierBuilder builder = new NutanixResourceIdentifierBuilder(item);_visitables.get("subnets").add(builder);this.subnets.add(builder);} return (A)this;
  }
  
  public A addAllToSubnets(Collection<NutanixResourceIdentifier> items) {
    if (this.subnets == null) {this.subnets = new ArrayList<NutanixResourceIdentifierBuilder>();}
    for (NutanixResourceIdentifier item : items) {NutanixResourceIdentifierBuilder builder = new NutanixResourceIdentifierBuilder(item);_visitables.get("subnets").add(builder);this.subnets.add(builder);} return (A)this;
  }
  
  public A removeFromSubnets(io.fabric8.openshift.api.model.config.v1.NutanixResourceIdentifier... items) {
    if (this.subnets == null) return (A)this;
    for (NutanixResourceIdentifier item : items) {NutanixResourceIdentifierBuilder builder = new NutanixResourceIdentifierBuilder(item);_visitables.get("subnets").remove(builder); this.subnets.remove(builder);} return (A)this;
  }
  
  public A removeAllFromSubnets(Collection<NutanixResourceIdentifier> items) {
    if (this.subnets == null) return (A)this;
    for (NutanixResourceIdentifier item : items) {NutanixResourceIdentifierBuilder builder = new NutanixResourceIdentifierBuilder(item);_visitables.get("subnets").remove(builder); this.subnets.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromSubnets(Predicate<NutanixResourceIdentifierBuilder> predicate) {
    if (subnets == null) return (A) this;
    final Iterator<NutanixResourceIdentifierBuilder> each = subnets.iterator();
    final List visitables = _visitables.get("subnets");
    while (each.hasNext()) {
      NutanixResourceIdentifierBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<NutanixResourceIdentifier> buildSubnets() {
    return this.subnets != null ? build(subnets) : null;
  }
  
  public NutanixResourceIdentifier buildSubnet(int index) {
    return this.subnets.get(index).build();
  }
  
  public NutanixResourceIdentifier buildFirstSubnet() {
    return this.subnets.get(0).build();
  }
  
  public NutanixResourceIdentifier buildLastSubnet() {
    return this.subnets.get(subnets.size() - 1).build();
  }
  
  public NutanixResourceIdentifier buildMatchingSubnet(Predicate<NutanixResourceIdentifierBuilder> predicate) {
      for (NutanixResourceIdentifierBuilder item : subnets) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingSubnet(Predicate<NutanixResourceIdentifierBuilder> predicate) {
      for (NutanixResourceIdentifierBuilder item : subnets) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withSubnets(List<NutanixResourceIdentifier> subnets) {
    if (this.subnets != null) {
      this._visitables.get("subnets").clear();
    }
    if (subnets != null) {
        this.subnets = new ArrayList();
        for (NutanixResourceIdentifier item : subnets) {
          this.addToSubnets(item);
        }
    } else {
      this.subnets = null;
    }
    return (A) this;
  }
  
  public A withSubnets(io.fabric8.openshift.api.model.config.v1.NutanixResourceIdentifier... subnets) {
    if (this.subnets != null) {
        this.subnets.clear();
        _visitables.remove("subnets");
    }
    if (subnets != null) {
      for (NutanixResourceIdentifier item : subnets) {
        this.addToSubnets(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasSubnets() {
    return this.subnets != null && !this.subnets.isEmpty();
  }
  
  public A addNewSubnet(String name,String type,String uuid) {
    return (A)addToSubnets(new NutanixResourceIdentifier(name, type, uuid));
  }
  
  public SubnetsNested<A> addNewSubnet() {
    return new SubnetsNested(-1, null);
  }
  
  public SubnetsNested<A> addNewSubnetLike(NutanixResourceIdentifier item) {
    return new SubnetsNested(-1, item);
  }
  
  public SubnetsNested<A> setNewSubnetLike(int index,NutanixResourceIdentifier item) {
    return new SubnetsNested(index, item);
  }
  
  public SubnetsNested<A> editSubnet(int index) {
    if (subnets.size() <= index) throw new RuntimeException("Can't edit subnets. Index exceeds size.");
    return setNewSubnetLike(index, buildSubnet(index));
  }
  
  public SubnetsNested<A> editFirstSubnet() {
    if (subnets.size() == 0) throw new RuntimeException("Can't edit first subnets. The list is empty.");
    return setNewSubnetLike(0, buildSubnet(0));
  }
  
  public SubnetsNested<A> editLastSubnet() {
    int index = subnets.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last subnets. The list is empty.");
    return setNewSubnetLike(index, buildSubnet(index));
  }
  
  public SubnetsNested<A> editMatchingSubnet(Predicate<NutanixResourceIdentifierBuilder> predicate) {
    int index = -1;
    for (int i=0;i<subnets.size();i++) { 
    if (predicate.test(subnets.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching subnets. No match found.");
    return setNewSubnetLike(index, buildSubnet(index));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    NutanixFailureDomainFluent that = (NutanixFailureDomainFluent) o;
    if (!java.util.Objects.equals(cluster, that.cluster)) return false;
    if (!java.util.Objects.equals(name, that.name)) return false;
    if (!java.util.Objects.equals(subnets, that.subnets)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(cluster,  name,  subnets,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (cluster != null) { sb.append("cluster:"); sb.append(cluster + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (subnets != null && !subnets.isEmpty()) { sb.append("subnets:"); sb.append(subnets + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ClusterNested<N> extends NutanixResourceIdentifierFluent<ClusterNested<N>> implements Nested<N>{
    ClusterNested(NutanixResourceIdentifier item) {
      this.builder = new NutanixResourceIdentifierBuilder(this, item);
    }
    NutanixResourceIdentifierBuilder builder;
    
    public N and() {
      return (N) NutanixFailureDomainFluent.this.withCluster(builder.build());
    }
    
    public N endCluster() {
      return and();
    }
    
  
  }
  public class SubnetsNested<N> extends NutanixResourceIdentifierFluent<SubnetsNested<N>> implements Nested<N>{
    SubnetsNested(int index,NutanixResourceIdentifier item) {
      this.index = index;
      this.builder = new NutanixResourceIdentifierBuilder(this, item);
    }
    NutanixResourceIdentifierBuilder builder;
    int index;
    
    public N and() {
      return (N) NutanixFailureDomainFluent.this.setToSubnets(index,builder.build());
    }
    
    public N endSubnet() {
      return and();
    }
    
  
  }

}