package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class GCPPlatformStatusFluent<A extends GCPPlatformStatusFluent<A>> extends BaseFluent<A>{
  public GCPPlatformStatusFluent() {
  }
  
  public GCPPlatformStatusFluent(GCPPlatformStatus instance) {
    this.copyInstance(instance);
  }
  private CloudLoadBalancerConfigBuilder cloudLoadBalancerConfig;
  private String projectID;
  private String region;
  private ArrayList<GCPResourceLabelBuilder> resourceLabels = new ArrayList<GCPResourceLabelBuilder>();
  private ArrayList<GCPResourceTagBuilder> resourceTags = new ArrayList<GCPResourceTagBuilder>();
  private ArrayList<GCPServiceEndpointBuilder> serviceEndpoints = new ArrayList<GCPServiceEndpointBuilder>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(GCPPlatformStatus instance) {
    instance = (instance != null ? instance : new GCPPlatformStatus());
    if (instance != null) {
          this.withCloudLoadBalancerConfig(instance.getCloudLoadBalancerConfig());
          this.withProjectID(instance.getProjectID());
          this.withRegion(instance.getRegion());
          this.withResourceLabels(instance.getResourceLabels());
          this.withResourceTags(instance.getResourceTags());
          this.withServiceEndpoints(instance.getServiceEndpoints());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public CloudLoadBalancerConfig buildCloudLoadBalancerConfig() {
    return this.cloudLoadBalancerConfig != null ? this.cloudLoadBalancerConfig.build() : null;
  }
  
  public A withCloudLoadBalancerConfig(CloudLoadBalancerConfig cloudLoadBalancerConfig) {
    this._visitables.remove("cloudLoadBalancerConfig");
    if (cloudLoadBalancerConfig != null) {
        this.cloudLoadBalancerConfig = new CloudLoadBalancerConfigBuilder(cloudLoadBalancerConfig);
        this._visitables.get("cloudLoadBalancerConfig").add(this.cloudLoadBalancerConfig);
    } else {
        this.cloudLoadBalancerConfig = null;
        this._visitables.get("cloudLoadBalancerConfig").remove(this.cloudLoadBalancerConfig);
    }
    return (A) this;
  }
  
  public boolean hasCloudLoadBalancerConfig() {
    return this.cloudLoadBalancerConfig != null;
  }
  
  public CloudLoadBalancerConfigNested<A> withNewCloudLoadBalancerConfig() {
    return new CloudLoadBalancerConfigNested(null);
  }
  
  public CloudLoadBalancerConfigNested<A> withNewCloudLoadBalancerConfigLike(CloudLoadBalancerConfig item) {
    return new CloudLoadBalancerConfigNested(item);
  }
  
  public CloudLoadBalancerConfigNested<A> editCloudLoadBalancerConfig() {
    return withNewCloudLoadBalancerConfigLike(java.util.Optional.ofNullable(buildCloudLoadBalancerConfig()).orElse(null));
  }
  
  public CloudLoadBalancerConfigNested<A> editOrNewCloudLoadBalancerConfig() {
    return withNewCloudLoadBalancerConfigLike(java.util.Optional.ofNullable(buildCloudLoadBalancerConfig()).orElse(new CloudLoadBalancerConfigBuilder().build()));
  }
  
  public CloudLoadBalancerConfigNested<A> editOrNewCloudLoadBalancerConfigLike(CloudLoadBalancerConfig item) {
    return withNewCloudLoadBalancerConfigLike(java.util.Optional.ofNullable(buildCloudLoadBalancerConfig()).orElse(item));
  }
  
  public String getProjectID() {
    return this.projectID;
  }
  
  public A withProjectID(String projectID) {
    this.projectID = projectID;
    return (A) this;
  }
  
  public boolean hasProjectID() {
    return this.projectID != null;
  }
  
  public String getRegion() {
    return this.region;
  }
  
  public A withRegion(String region) {
    this.region = region;
    return (A) this;
  }
  
  public boolean hasRegion() {
    return this.region != null;
  }
  
  public A addToResourceLabels(int index,GCPResourceLabel item) {
    if (this.resourceLabels == null) {this.resourceLabels = new ArrayList<GCPResourceLabelBuilder>();}
    GCPResourceLabelBuilder builder = new GCPResourceLabelBuilder(item);
    if (index < 0 || index >= resourceLabels.size()) {
        _visitables.get("resourceLabels").add(builder);
        resourceLabels.add(builder);
    } else {
        _visitables.get("resourceLabels").add(builder);
        resourceLabels.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToResourceLabels(int index,GCPResourceLabel item) {
    if (this.resourceLabels == null) {this.resourceLabels = new ArrayList<GCPResourceLabelBuilder>();}
    GCPResourceLabelBuilder builder = new GCPResourceLabelBuilder(item);
    if (index < 0 || index >= resourceLabels.size()) {
        _visitables.get("resourceLabels").add(builder);
        resourceLabels.add(builder);
    } else {
        _visitables.get("resourceLabels").add(builder);
        resourceLabels.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToResourceLabels(io.fabric8.openshift.api.model.config.v1.GCPResourceLabel... items) {
    if (this.resourceLabels == null) {this.resourceLabels = new ArrayList<GCPResourceLabelBuilder>();}
    for (GCPResourceLabel item : items) {GCPResourceLabelBuilder builder = new GCPResourceLabelBuilder(item);_visitables.get("resourceLabels").add(builder);this.resourceLabels.add(builder);} return (A)this;
  }
  
  public A addAllToResourceLabels(Collection<GCPResourceLabel> items) {
    if (this.resourceLabels == null) {this.resourceLabels = new ArrayList<GCPResourceLabelBuilder>();}
    for (GCPResourceLabel item : items) {GCPResourceLabelBuilder builder = new GCPResourceLabelBuilder(item);_visitables.get("resourceLabels").add(builder);this.resourceLabels.add(builder);} return (A)this;
  }
  
  public A removeFromResourceLabels(io.fabric8.openshift.api.model.config.v1.GCPResourceLabel... items) {
    if (this.resourceLabels == null) return (A)this;
    for (GCPResourceLabel item : items) {GCPResourceLabelBuilder builder = new GCPResourceLabelBuilder(item);_visitables.get("resourceLabels").remove(builder); this.resourceLabels.remove(builder);} return (A)this;
  }
  
  public A removeAllFromResourceLabels(Collection<GCPResourceLabel> items) {
    if (this.resourceLabels == null) return (A)this;
    for (GCPResourceLabel item : items) {GCPResourceLabelBuilder builder = new GCPResourceLabelBuilder(item);_visitables.get("resourceLabels").remove(builder); this.resourceLabels.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromResourceLabels(Predicate<GCPResourceLabelBuilder> predicate) {
    if (resourceLabels == null) return (A) this;
    final Iterator<GCPResourceLabelBuilder> each = resourceLabels.iterator();
    final List visitables = _visitables.get("resourceLabels");
    while (each.hasNext()) {
      GCPResourceLabelBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<GCPResourceLabel> buildResourceLabels() {
    return this.resourceLabels != null ? build(resourceLabels) : null;
  }
  
  public GCPResourceLabel buildResourceLabel(int index) {
    return this.resourceLabels.get(index).build();
  }
  
  public GCPResourceLabel buildFirstResourceLabel() {
    return this.resourceLabels.get(0).build();
  }
  
  public GCPResourceLabel buildLastResourceLabel() {
    return this.resourceLabels.get(resourceLabels.size() - 1).build();
  }
  
  public GCPResourceLabel buildMatchingResourceLabel(Predicate<GCPResourceLabelBuilder> predicate) {
      for (GCPResourceLabelBuilder item : resourceLabels) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingResourceLabel(Predicate<GCPResourceLabelBuilder> predicate) {
      for (GCPResourceLabelBuilder item : resourceLabels) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withResourceLabels(List<GCPResourceLabel> resourceLabels) {
    if (this.resourceLabels != null) {
      this._visitables.get("resourceLabels").clear();
    }
    if (resourceLabels != null) {
        this.resourceLabels = new ArrayList();
        for (GCPResourceLabel item : resourceLabels) {
          this.addToResourceLabels(item);
        }
    } else {
      this.resourceLabels = null;
    }
    return (A) this;
  }
  
  public A withResourceLabels(io.fabric8.openshift.api.model.config.v1.GCPResourceLabel... resourceLabels) {
    if (this.resourceLabels != null) {
        this.resourceLabels.clear();
        _visitables.remove("resourceLabels");
    }
    if (resourceLabels != null) {
      for (GCPResourceLabel item : resourceLabels) {
        this.addToResourceLabels(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasResourceLabels() {
    return this.resourceLabels != null && !this.resourceLabels.isEmpty();
  }
  
  public A addNewResourceLabel(String key,String value) {
    return (A)addToResourceLabels(new GCPResourceLabel(key, value));
  }
  
  public ResourceLabelsNested<A> addNewResourceLabel() {
    return new ResourceLabelsNested(-1, null);
  }
  
  public ResourceLabelsNested<A> addNewResourceLabelLike(GCPResourceLabel item) {
    return new ResourceLabelsNested(-1, item);
  }
  
  public ResourceLabelsNested<A> setNewResourceLabelLike(int index,GCPResourceLabel item) {
    return new ResourceLabelsNested(index, item);
  }
  
  public ResourceLabelsNested<A> editResourceLabel(int index) {
    if (resourceLabels.size() <= index) throw new RuntimeException("Can't edit resourceLabels. Index exceeds size.");
    return setNewResourceLabelLike(index, buildResourceLabel(index));
  }
  
  public ResourceLabelsNested<A> editFirstResourceLabel() {
    if (resourceLabels.size() == 0) throw new RuntimeException("Can't edit first resourceLabels. The list is empty.");
    return setNewResourceLabelLike(0, buildResourceLabel(0));
  }
  
  public ResourceLabelsNested<A> editLastResourceLabel() {
    int index = resourceLabels.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last resourceLabels. The list is empty.");
    return setNewResourceLabelLike(index, buildResourceLabel(index));
  }
  
  public ResourceLabelsNested<A> editMatchingResourceLabel(Predicate<GCPResourceLabelBuilder> predicate) {
    int index = -1;
    for (int i=0;i<resourceLabels.size();i++) { 
    if (predicate.test(resourceLabels.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching resourceLabels. No match found.");
    return setNewResourceLabelLike(index, buildResourceLabel(index));
  }
  
  public A addToResourceTags(int index,GCPResourceTag item) {
    if (this.resourceTags == null) {this.resourceTags = new ArrayList<GCPResourceTagBuilder>();}
    GCPResourceTagBuilder builder = new GCPResourceTagBuilder(item);
    if (index < 0 || index >= resourceTags.size()) {
        _visitables.get("resourceTags").add(builder);
        resourceTags.add(builder);
    } else {
        _visitables.get("resourceTags").add(builder);
        resourceTags.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToResourceTags(int index,GCPResourceTag item) {
    if (this.resourceTags == null) {this.resourceTags = new ArrayList<GCPResourceTagBuilder>();}
    GCPResourceTagBuilder builder = new GCPResourceTagBuilder(item);
    if (index < 0 || index >= resourceTags.size()) {
        _visitables.get("resourceTags").add(builder);
        resourceTags.add(builder);
    } else {
        _visitables.get("resourceTags").add(builder);
        resourceTags.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToResourceTags(io.fabric8.openshift.api.model.config.v1.GCPResourceTag... items) {
    if (this.resourceTags == null) {this.resourceTags = new ArrayList<GCPResourceTagBuilder>();}
    for (GCPResourceTag item : items) {GCPResourceTagBuilder builder = new GCPResourceTagBuilder(item);_visitables.get("resourceTags").add(builder);this.resourceTags.add(builder);} return (A)this;
  }
  
  public A addAllToResourceTags(Collection<GCPResourceTag> items) {
    if (this.resourceTags == null) {this.resourceTags = new ArrayList<GCPResourceTagBuilder>();}
    for (GCPResourceTag item : items) {GCPResourceTagBuilder builder = new GCPResourceTagBuilder(item);_visitables.get("resourceTags").add(builder);this.resourceTags.add(builder);} return (A)this;
  }
  
  public A removeFromResourceTags(io.fabric8.openshift.api.model.config.v1.GCPResourceTag... items) {
    if (this.resourceTags == null) return (A)this;
    for (GCPResourceTag item : items) {GCPResourceTagBuilder builder = new GCPResourceTagBuilder(item);_visitables.get("resourceTags").remove(builder); this.resourceTags.remove(builder);} return (A)this;
  }
  
  public A removeAllFromResourceTags(Collection<GCPResourceTag> items) {
    if (this.resourceTags == null) return (A)this;
    for (GCPResourceTag item : items) {GCPResourceTagBuilder builder = new GCPResourceTagBuilder(item);_visitables.get("resourceTags").remove(builder); this.resourceTags.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromResourceTags(Predicate<GCPResourceTagBuilder> predicate) {
    if (resourceTags == null) return (A) this;
    final Iterator<GCPResourceTagBuilder> each = resourceTags.iterator();
    final List visitables = _visitables.get("resourceTags");
    while (each.hasNext()) {
      GCPResourceTagBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<GCPResourceTag> buildResourceTags() {
    return this.resourceTags != null ? build(resourceTags) : null;
  }
  
  public GCPResourceTag buildResourceTag(int index) {
    return this.resourceTags.get(index).build();
  }
  
  public GCPResourceTag buildFirstResourceTag() {
    return this.resourceTags.get(0).build();
  }
  
  public GCPResourceTag buildLastResourceTag() {
    return this.resourceTags.get(resourceTags.size() - 1).build();
  }
  
  public GCPResourceTag buildMatchingResourceTag(Predicate<GCPResourceTagBuilder> predicate) {
      for (GCPResourceTagBuilder item : resourceTags) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingResourceTag(Predicate<GCPResourceTagBuilder> predicate) {
      for (GCPResourceTagBuilder item : resourceTags) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withResourceTags(List<GCPResourceTag> resourceTags) {
    if (this.resourceTags != null) {
      this._visitables.get("resourceTags").clear();
    }
    if (resourceTags != null) {
        this.resourceTags = new ArrayList();
        for (GCPResourceTag item : resourceTags) {
          this.addToResourceTags(item);
        }
    } else {
      this.resourceTags = null;
    }
    return (A) this;
  }
  
  public A withResourceTags(io.fabric8.openshift.api.model.config.v1.GCPResourceTag... resourceTags) {
    if (this.resourceTags != null) {
        this.resourceTags.clear();
        _visitables.remove("resourceTags");
    }
    if (resourceTags != null) {
      for (GCPResourceTag item : resourceTags) {
        this.addToResourceTags(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasResourceTags() {
    return this.resourceTags != null && !this.resourceTags.isEmpty();
  }
  
  public A addNewResourceTag(String key,String parentID,String value) {
    return (A)addToResourceTags(new GCPResourceTag(key, parentID, value));
  }
  
  public ResourceTagsNested<A> addNewResourceTag() {
    return new ResourceTagsNested(-1, null);
  }
  
  public ResourceTagsNested<A> addNewResourceTagLike(GCPResourceTag item) {
    return new ResourceTagsNested(-1, item);
  }
  
  public ResourceTagsNested<A> setNewResourceTagLike(int index,GCPResourceTag item) {
    return new ResourceTagsNested(index, item);
  }
  
  public ResourceTagsNested<A> editResourceTag(int index) {
    if (resourceTags.size() <= index) throw new RuntimeException("Can't edit resourceTags. Index exceeds size.");
    return setNewResourceTagLike(index, buildResourceTag(index));
  }
  
  public ResourceTagsNested<A> editFirstResourceTag() {
    if (resourceTags.size() == 0) throw new RuntimeException("Can't edit first resourceTags. The list is empty.");
    return setNewResourceTagLike(0, buildResourceTag(0));
  }
  
  public ResourceTagsNested<A> editLastResourceTag() {
    int index = resourceTags.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last resourceTags. The list is empty.");
    return setNewResourceTagLike(index, buildResourceTag(index));
  }
  
  public ResourceTagsNested<A> editMatchingResourceTag(Predicate<GCPResourceTagBuilder> predicate) {
    int index = -1;
    for (int i=0;i<resourceTags.size();i++) { 
    if (predicate.test(resourceTags.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching resourceTags. No match found.");
    return setNewResourceTagLike(index, buildResourceTag(index));
  }
  
  public A addToServiceEndpoints(int index,GCPServiceEndpoint item) {
    if (this.serviceEndpoints == null) {this.serviceEndpoints = new ArrayList<GCPServiceEndpointBuilder>();}
    GCPServiceEndpointBuilder builder = new GCPServiceEndpointBuilder(item);
    if (index < 0 || index >= serviceEndpoints.size()) {
        _visitables.get("serviceEndpoints").add(builder);
        serviceEndpoints.add(builder);
    } else {
        _visitables.get("serviceEndpoints").add(builder);
        serviceEndpoints.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToServiceEndpoints(int index,GCPServiceEndpoint item) {
    if (this.serviceEndpoints == null) {this.serviceEndpoints = new ArrayList<GCPServiceEndpointBuilder>();}
    GCPServiceEndpointBuilder builder = new GCPServiceEndpointBuilder(item);
    if (index < 0 || index >= serviceEndpoints.size()) {
        _visitables.get("serviceEndpoints").add(builder);
        serviceEndpoints.add(builder);
    } else {
        _visitables.get("serviceEndpoints").add(builder);
        serviceEndpoints.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToServiceEndpoints(io.fabric8.openshift.api.model.config.v1.GCPServiceEndpoint... items) {
    if (this.serviceEndpoints == null) {this.serviceEndpoints = new ArrayList<GCPServiceEndpointBuilder>();}
    for (GCPServiceEndpoint item : items) {GCPServiceEndpointBuilder builder = new GCPServiceEndpointBuilder(item);_visitables.get("serviceEndpoints").add(builder);this.serviceEndpoints.add(builder);} return (A)this;
  }
  
  public A addAllToServiceEndpoints(Collection<GCPServiceEndpoint> items) {
    if (this.serviceEndpoints == null) {this.serviceEndpoints = new ArrayList<GCPServiceEndpointBuilder>();}
    for (GCPServiceEndpoint item : items) {GCPServiceEndpointBuilder builder = new GCPServiceEndpointBuilder(item);_visitables.get("serviceEndpoints").add(builder);this.serviceEndpoints.add(builder);} return (A)this;
  }
  
  public A removeFromServiceEndpoints(io.fabric8.openshift.api.model.config.v1.GCPServiceEndpoint... items) {
    if (this.serviceEndpoints == null) return (A)this;
    for (GCPServiceEndpoint item : items) {GCPServiceEndpointBuilder builder = new GCPServiceEndpointBuilder(item);_visitables.get("serviceEndpoints").remove(builder); this.serviceEndpoints.remove(builder);} return (A)this;
  }
  
  public A removeAllFromServiceEndpoints(Collection<GCPServiceEndpoint> items) {
    if (this.serviceEndpoints == null) return (A)this;
    for (GCPServiceEndpoint item : items) {GCPServiceEndpointBuilder builder = new GCPServiceEndpointBuilder(item);_visitables.get("serviceEndpoints").remove(builder); this.serviceEndpoints.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromServiceEndpoints(Predicate<GCPServiceEndpointBuilder> predicate) {
    if (serviceEndpoints == null) return (A) this;
    final Iterator<GCPServiceEndpointBuilder> each = serviceEndpoints.iterator();
    final List visitables = _visitables.get("serviceEndpoints");
    while (each.hasNext()) {
      GCPServiceEndpointBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<GCPServiceEndpoint> buildServiceEndpoints() {
    return this.serviceEndpoints != null ? build(serviceEndpoints) : null;
  }
  
  public GCPServiceEndpoint buildServiceEndpoint(int index) {
    return this.serviceEndpoints.get(index).build();
  }
  
  public GCPServiceEndpoint buildFirstServiceEndpoint() {
    return this.serviceEndpoints.get(0).build();
  }
  
  public GCPServiceEndpoint buildLastServiceEndpoint() {
    return this.serviceEndpoints.get(serviceEndpoints.size() - 1).build();
  }
  
  public GCPServiceEndpoint buildMatchingServiceEndpoint(Predicate<GCPServiceEndpointBuilder> predicate) {
      for (GCPServiceEndpointBuilder item : serviceEndpoints) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingServiceEndpoint(Predicate<GCPServiceEndpointBuilder> predicate) {
      for (GCPServiceEndpointBuilder item : serviceEndpoints) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withServiceEndpoints(List<GCPServiceEndpoint> serviceEndpoints) {
    if (this.serviceEndpoints != null) {
      this._visitables.get("serviceEndpoints").clear();
    }
    if (serviceEndpoints != null) {
        this.serviceEndpoints = new ArrayList();
        for (GCPServiceEndpoint item : serviceEndpoints) {
          this.addToServiceEndpoints(item);
        }
    } else {
      this.serviceEndpoints = null;
    }
    return (A) this;
  }
  
  public A withServiceEndpoints(io.fabric8.openshift.api.model.config.v1.GCPServiceEndpoint... serviceEndpoints) {
    if (this.serviceEndpoints != null) {
        this.serviceEndpoints.clear();
        _visitables.remove("serviceEndpoints");
    }
    if (serviceEndpoints != null) {
      for (GCPServiceEndpoint item : serviceEndpoints) {
        this.addToServiceEndpoints(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasServiceEndpoints() {
    return this.serviceEndpoints != null && !this.serviceEndpoints.isEmpty();
  }
  
  public A addNewServiceEndpoint(String name,String url) {
    return (A)addToServiceEndpoints(new GCPServiceEndpoint(name, url));
  }
  
  public ServiceEndpointsNested<A> addNewServiceEndpoint() {
    return new ServiceEndpointsNested(-1, null);
  }
  
  public ServiceEndpointsNested<A> addNewServiceEndpointLike(GCPServiceEndpoint item) {
    return new ServiceEndpointsNested(-1, item);
  }
  
  public ServiceEndpointsNested<A> setNewServiceEndpointLike(int index,GCPServiceEndpoint item) {
    return new ServiceEndpointsNested(index, item);
  }
  
  public ServiceEndpointsNested<A> editServiceEndpoint(int index) {
    if (serviceEndpoints.size() <= index) throw new RuntimeException("Can't edit serviceEndpoints. Index exceeds size.");
    return setNewServiceEndpointLike(index, buildServiceEndpoint(index));
  }
  
  public ServiceEndpointsNested<A> editFirstServiceEndpoint() {
    if (serviceEndpoints.size() == 0) throw new RuntimeException("Can't edit first serviceEndpoints. The list is empty.");
    return setNewServiceEndpointLike(0, buildServiceEndpoint(0));
  }
  
  public ServiceEndpointsNested<A> editLastServiceEndpoint() {
    int index = serviceEndpoints.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last serviceEndpoints. The list is empty.");
    return setNewServiceEndpointLike(index, buildServiceEndpoint(index));
  }
  
  public ServiceEndpointsNested<A> editMatchingServiceEndpoint(Predicate<GCPServiceEndpointBuilder> predicate) {
    int index = -1;
    for (int i=0;i<serviceEndpoints.size();i++) { 
    if (predicate.test(serviceEndpoints.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching serviceEndpoints. No match found.");
    return setNewServiceEndpointLike(index, buildServiceEndpoint(index));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    GCPPlatformStatusFluent that = (GCPPlatformStatusFluent) o;
    if (!java.util.Objects.equals(cloudLoadBalancerConfig, that.cloudLoadBalancerConfig)) return false;
    if (!java.util.Objects.equals(projectID, that.projectID)) return false;
    if (!java.util.Objects.equals(region, that.region)) return false;
    if (!java.util.Objects.equals(resourceLabels, that.resourceLabels)) return false;
    if (!java.util.Objects.equals(resourceTags, that.resourceTags)) return false;
    if (!java.util.Objects.equals(serviceEndpoints, that.serviceEndpoints)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(cloudLoadBalancerConfig,  projectID,  region,  resourceLabels,  resourceTags,  serviceEndpoints,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (cloudLoadBalancerConfig != null) { sb.append("cloudLoadBalancerConfig:"); sb.append(cloudLoadBalancerConfig + ","); }
    if (projectID != null) { sb.append("projectID:"); sb.append(projectID + ","); }
    if (region != null) { sb.append("region:"); sb.append(region + ","); }
    if (resourceLabels != null && !resourceLabels.isEmpty()) { sb.append("resourceLabels:"); sb.append(resourceLabels + ","); }
    if (resourceTags != null && !resourceTags.isEmpty()) { sb.append("resourceTags:"); sb.append(resourceTags + ","); }
    if (serviceEndpoints != null && !serviceEndpoints.isEmpty()) { sb.append("serviceEndpoints:"); sb.append(serviceEndpoints + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class CloudLoadBalancerConfigNested<N> extends CloudLoadBalancerConfigFluent<CloudLoadBalancerConfigNested<N>> implements Nested<N>{
    CloudLoadBalancerConfigNested(CloudLoadBalancerConfig item) {
      this.builder = new CloudLoadBalancerConfigBuilder(this, item);
    }
    CloudLoadBalancerConfigBuilder builder;
    
    public N and() {
      return (N) GCPPlatformStatusFluent.this.withCloudLoadBalancerConfig(builder.build());
    }
    
    public N endCloudLoadBalancerConfig() {
      return and();
    }
    
  
  }
  public class ResourceLabelsNested<N> extends GCPResourceLabelFluent<ResourceLabelsNested<N>> implements Nested<N>{
    ResourceLabelsNested(int index,GCPResourceLabel item) {
      this.index = index;
      this.builder = new GCPResourceLabelBuilder(this, item);
    }
    GCPResourceLabelBuilder builder;
    int index;
    
    public N and() {
      return (N) GCPPlatformStatusFluent.this.setToResourceLabels(index,builder.build());
    }
    
    public N endResourceLabel() {
      return and();
    }
    
  
  }
  public class ResourceTagsNested<N> extends GCPResourceTagFluent<ResourceTagsNested<N>> implements Nested<N>{
    ResourceTagsNested(int index,GCPResourceTag item) {
      this.index = index;
      this.builder = new GCPResourceTagBuilder(this, item);
    }
    GCPResourceTagBuilder builder;
    int index;
    
    public N and() {
      return (N) GCPPlatformStatusFluent.this.setToResourceTags(index,builder.build());
    }
    
    public N endResourceTag() {
      return and();
    }
    
  
  }
  public class ServiceEndpointsNested<N> extends GCPServiceEndpointFluent<ServiceEndpointsNested<N>> implements Nested<N>{
    ServiceEndpointsNested(int index,GCPServiceEndpoint item) {
      this.index = index;
      this.builder = new GCPServiceEndpointBuilder(this, item);
    }
    GCPServiceEndpointBuilder builder;
    int index;
    
    public N and() {
      return (N) GCPPlatformStatusFluent.this.setToServiceEndpoints(index,builder.build());
    }
    
    public N endServiceEndpoint() {
      return and();
    }
    
  
  }

}