package io.fabric8.openshift.api.model.config.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class CloudLoadBalancerConfigFluent<A extends CloudLoadBalancerConfigFluent<A>> extends BaseFluent<A>{
  public CloudLoadBalancerConfigFluent() {
  }
  
  public CloudLoadBalancerConfigFluent(CloudLoadBalancerConfig instance) {
    this.copyInstance(instance);
  }
  private CloudLoadBalancerIPsBuilder clusterHosted;
  private String dnsType;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(CloudLoadBalancerConfig instance) {
    instance = (instance != null ? instance : new CloudLoadBalancerConfig());
    if (instance != null) {
          this.withClusterHosted(instance.getClusterHosted());
          this.withDnsType(instance.getDnsType());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public CloudLoadBalancerIPs buildClusterHosted() {
    return this.clusterHosted != null ? this.clusterHosted.build() : null;
  }
  
  public A withClusterHosted(CloudLoadBalancerIPs clusterHosted) {
    this._visitables.remove("clusterHosted");
    if (clusterHosted != null) {
        this.clusterHosted = new CloudLoadBalancerIPsBuilder(clusterHosted);
        this._visitables.get("clusterHosted").add(this.clusterHosted);
    } else {
        this.clusterHosted = null;
        this._visitables.get("clusterHosted").remove(this.clusterHosted);
    }
    return (A) this;
  }
  
  public boolean hasClusterHosted() {
    return this.clusterHosted != null;
  }
  
  public ClusterHostedNested<A> withNewClusterHosted() {
    return new ClusterHostedNested(null);
  }
  
  public ClusterHostedNested<A> withNewClusterHostedLike(CloudLoadBalancerIPs item) {
    return new ClusterHostedNested(item);
  }
  
  public ClusterHostedNested<A> editClusterHosted() {
    return withNewClusterHostedLike(java.util.Optional.ofNullable(buildClusterHosted()).orElse(null));
  }
  
  public ClusterHostedNested<A> editOrNewClusterHosted() {
    return withNewClusterHostedLike(java.util.Optional.ofNullable(buildClusterHosted()).orElse(new CloudLoadBalancerIPsBuilder().build()));
  }
  
  public ClusterHostedNested<A> editOrNewClusterHostedLike(CloudLoadBalancerIPs item) {
    return withNewClusterHostedLike(java.util.Optional.ofNullable(buildClusterHosted()).orElse(item));
  }
  
  public String getDnsType() {
    return this.dnsType;
  }
  
  public A withDnsType(String dnsType) {
    this.dnsType = dnsType;
    return (A) this;
  }
  
  public boolean hasDnsType() {
    return this.dnsType != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    CloudLoadBalancerConfigFluent that = (CloudLoadBalancerConfigFluent) o;
    if (!java.util.Objects.equals(clusterHosted, that.clusterHosted)) return false;
    if (!java.util.Objects.equals(dnsType, that.dnsType)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(clusterHosted,  dnsType,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (clusterHosted != null) { sb.append("clusterHosted:"); sb.append(clusterHosted + ","); }
    if (dnsType != null) { sb.append("dnsType:"); sb.append(dnsType + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ClusterHostedNested<N> extends CloudLoadBalancerIPsFluent<ClusterHostedNested<N>> implements Nested<N>{
    ClusterHostedNested(CloudLoadBalancerIPs item) {
      this.builder = new CloudLoadBalancerIPsBuilder(this, item);
    }
    CloudLoadBalancerIPsBuilder builder;
    
    public N and() {
      return (N) CloudLoadBalancerConfigFluent.this.withClusterHosted(builder.build());
    }
    
    public N endClusterHosted() {
      return and();
    }
    
  
  }

}