/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.config.v1.ComponentRouteSpec;
import io.fabric8.openshift.api.model.config.v1.ComponentRouteSpecBuilder;
import io.fabric8.openshift.api.model.config.v1.ComponentRouteSpecFluent;
import io.fabric8.openshift.api.model.config.v1.IngressSpec;
import io.fabric8.openshift.api.model.config.v1.LoadBalancer;
import io.fabric8.openshift.api.model.config.v1.LoadBalancerBuilder;
import io.fabric8.openshift.api.model.config.v1.LoadBalancerFluent;
import io.fabric8.openshift.api.model.config.v1.RequiredHSTSPolicy;
import io.fabric8.openshift.api.model.config.v1.RequiredHSTSPolicyBuilder;
import io.fabric8.openshift.api.model.config.v1.RequiredHSTSPolicyFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class IngressSpecFluent<A extends IngressSpecFluent<A>>
extends BaseFluent<A> {
    private String appsDomain;
    private ArrayList<ComponentRouteSpecBuilder> componentRoutes = new ArrayList();
    private String domain;
    private LoadBalancerBuilder loadBalancer;
    private ArrayList<RequiredHSTSPolicyBuilder> requiredHSTSPolicies = new ArrayList();
    private Map<String, Object> additionalProperties;

    public IngressSpecFluent() {
    }

    public IngressSpecFluent(IngressSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(IngressSpec instance) {
        IngressSpec ingressSpec = instance = instance != null ? instance : new IngressSpec();
        if (instance != null) {
            this.withAppsDomain(instance.getAppsDomain());
            this.withComponentRoutes(instance.getComponentRoutes());
            this.withDomain(instance.getDomain());
            this.withLoadBalancer(instance.getLoadBalancer());
            this.withRequiredHSTSPolicies(instance.getRequiredHSTSPolicies());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getAppsDomain() {
        return this.appsDomain;
    }

    public A withAppsDomain(String appsDomain) {
        this.appsDomain = appsDomain;
        return (A)((Object)this);
    }

    public boolean hasAppsDomain() {
        return this.appsDomain != null;
    }

    public A addToComponentRoutes(int index, ComponentRouteSpec item) {
        if (this.componentRoutes == null) {
            this.componentRoutes = new ArrayList();
        }
        ComponentRouteSpecBuilder builder = new ComponentRouteSpecBuilder(item);
        if (index < 0 || index >= this.componentRoutes.size()) {
            this._visitables.get((Object)"componentRoutes").add(builder);
            this.componentRoutes.add(builder);
        } else {
            this._visitables.get((Object)"componentRoutes").add(builder);
            this.componentRoutes.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToComponentRoutes(int index, ComponentRouteSpec item) {
        if (this.componentRoutes == null) {
            this.componentRoutes = new ArrayList();
        }
        ComponentRouteSpecBuilder builder = new ComponentRouteSpecBuilder(item);
        if (index < 0 || index >= this.componentRoutes.size()) {
            this._visitables.get((Object)"componentRoutes").add(builder);
            this.componentRoutes.add(builder);
        } else {
            this._visitables.get((Object)"componentRoutes").add(builder);
            this.componentRoutes.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToComponentRoutes(ComponentRouteSpec ... items) {
        if (this.componentRoutes == null) {
            this.componentRoutes = new ArrayList();
        }
        for (ComponentRouteSpec item : items) {
            ComponentRouteSpecBuilder builder = new ComponentRouteSpecBuilder(item);
            this._visitables.get((Object)"componentRoutes").add(builder);
            this.componentRoutes.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToComponentRoutes(Collection<ComponentRouteSpec> items) {
        if (this.componentRoutes == null) {
            this.componentRoutes = new ArrayList();
        }
        for (ComponentRouteSpec item : items) {
            ComponentRouteSpecBuilder builder = new ComponentRouteSpecBuilder(item);
            this._visitables.get((Object)"componentRoutes").add(builder);
            this.componentRoutes.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromComponentRoutes(ComponentRouteSpec ... items) {
        if (this.componentRoutes == null) {
            return (A)((Object)this);
        }
        for (ComponentRouteSpec item : items) {
            ComponentRouteSpecBuilder builder = new ComponentRouteSpecBuilder(item);
            this._visitables.get((Object)"componentRoutes").remove((Object)builder);
            this.componentRoutes.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromComponentRoutes(Collection<ComponentRouteSpec> items) {
        if (this.componentRoutes == null) {
            return (A)((Object)this);
        }
        for (ComponentRouteSpec item : items) {
            ComponentRouteSpecBuilder builder = new ComponentRouteSpecBuilder(item);
            this._visitables.get((Object)"componentRoutes").remove((Object)builder);
            this.componentRoutes.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromComponentRoutes(Predicate<ComponentRouteSpecBuilder> predicate) {
        if (this.componentRoutes == null) {
            return (A)((Object)this);
        }
        Iterator<ComponentRouteSpecBuilder> each = this.componentRoutes.iterator();
        List visitables = this._visitables.get((Object)"componentRoutes");
        while (each.hasNext()) {
            ComponentRouteSpecBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<ComponentRouteSpec> buildComponentRoutes() {
        return this.componentRoutes != null ? IngressSpecFluent.build(this.componentRoutes) : null;
    }

    public ComponentRouteSpec buildComponentRoute(int index) {
        return this.componentRoutes.get(index).build();
    }

    public ComponentRouteSpec buildFirstComponentRoute() {
        return this.componentRoutes.get(0).build();
    }

    public ComponentRouteSpec buildLastComponentRoute() {
        return this.componentRoutes.get(this.componentRoutes.size() - 1).build();
    }

    public ComponentRouteSpec buildMatchingComponentRoute(Predicate<ComponentRouteSpecBuilder> predicate) {
        for (ComponentRouteSpecBuilder item : this.componentRoutes) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingComponentRoute(Predicate<ComponentRouteSpecBuilder> predicate) {
        for (ComponentRouteSpecBuilder item : this.componentRoutes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withComponentRoutes(List<ComponentRouteSpec> componentRoutes) {
        if (this.componentRoutes != null) {
            this._visitables.get((Object)"componentRoutes").clear();
        }
        if (componentRoutes != null) {
            this.componentRoutes = new ArrayList();
            for (ComponentRouteSpec item : componentRoutes) {
                this.addToComponentRoutes(item);
            }
        } else {
            this.componentRoutes = null;
        }
        return (A)((Object)this);
    }

    public A withComponentRoutes(ComponentRouteSpec ... componentRoutes) {
        if (this.componentRoutes != null) {
            this.componentRoutes.clear();
            this._visitables.remove((Object)"componentRoutes");
        }
        if (componentRoutes != null) {
            for (ComponentRouteSpec item : componentRoutes) {
                this.addToComponentRoutes(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasComponentRoutes() {
        return this.componentRoutes != null && !this.componentRoutes.isEmpty();
    }

    public ComponentRoutesNested<A> addNewComponentRoute() {
        return new ComponentRoutesNested(-1, null);
    }

    public ComponentRoutesNested<A> addNewComponentRouteLike(ComponentRouteSpec item) {
        return new ComponentRoutesNested(-1, item);
    }

    public ComponentRoutesNested<A> setNewComponentRouteLike(int index, ComponentRouteSpec item) {
        return new ComponentRoutesNested(index, item);
    }

    public ComponentRoutesNested<A> editComponentRoute(int index) {
        if (this.componentRoutes.size() <= index) {
            throw new RuntimeException("Can't edit componentRoutes. Index exceeds size.");
        }
        return this.setNewComponentRouteLike(index, this.buildComponentRoute(index));
    }

    public ComponentRoutesNested<A> editFirstComponentRoute() {
        if (this.componentRoutes.size() == 0) {
            throw new RuntimeException("Can't edit first componentRoutes. The list is empty.");
        }
        return this.setNewComponentRouteLike(0, this.buildComponentRoute(0));
    }

    public ComponentRoutesNested<A> editLastComponentRoute() {
        int index = this.componentRoutes.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last componentRoutes. The list is empty.");
        }
        return this.setNewComponentRouteLike(index, this.buildComponentRoute(index));
    }

    public ComponentRoutesNested<A> editMatchingComponentRoute(Predicate<ComponentRouteSpecBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.componentRoutes.size(); ++i) {
            if (!predicate.test(this.componentRoutes.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching componentRoutes. No match found.");
        }
        return this.setNewComponentRouteLike(index, this.buildComponentRoute(index));
    }

    public String getDomain() {
        return this.domain;
    }

    public A withDomain(String domain) {
        this.domain = domain;
        return (A)((Object)this);
    }

    public boolean hasDomain() {
        return this.domain != null;
    }

    public LoadBalancer buildLoadBalancer() {
        return this.loadBalancer != null ? this.loadBalancer.build() : null;
    }

    public A withLoadBalancer(LoadBalancer loadBalancer) {
        this._visitables.remove((Object)"loadBalancer");
        if (loadBalancer != null) {
            this.loadBalancer = new LoadBalancerBuilder(loadBalancer);
            this._visitables.get((Object)"loadBalancer").add(this.loadBalancer);
        } else {
            this.loadBalancer = null;
            this._visitables.get((Object)"loadBalancer").remove((Object)this.loadBalancer);
        }
        return (A)((Object)this);
    }

    public boolean hasLoadBalancer() {
        return this.loadBalancer != null;
    }

    public LoadBalancerNested<A> withNewLoadBalancer() {
        return new LoadBalancerNested(null);
    }

    public LoadBalancerNested<A> withNewLoadBalancerLike(LoadBalancer item) {
        return new LoadBalancerNested(item);
    }

    public LoadBalancerNested<A> editLoadBalancer() {
        return this.withNewLoadBalancerLike(Optional.ofNullable(this.buildLoadBalancer()).orElse(null));
    }

    public LoadBalancerNested<A> editOrNewLoadBalancer() {
        return this.withNewLoadBalancerLike(Optional.ofNullable(this.buildLoadBalancer()).orElse(new LoadBalancerBuilder().build()));
    }

    public LoadBalancerNested<A> editOrNewLoadBalancerLike(LoadBalancer item) {
        return this.withNewLoadBalancerLike(Optional.ofNullable(this.buildLoadBalancer()).orElse(item));
    }

    public A addToRequiredHSTSPolicies(int index, RequiredHSTSPolicy item) {
        if (this.requiredHSTSPolicies == null) {
            this.requiredHSTSPolicies = new ArrayList();
        }
        RequiredHSTSPolicyBuilder builder = new RequiredHSTSPolicyBuilder(item);
        if (index < 0 || index >= this.requiredHSTSPolicies.size()) {
            this._visitables.get((Object)"requiredHSTSPolicies").add(builder);
            this.requiredHSTSPolicies.add(builder);
        } else {
            this._visitables.get((Object)"requiredHSTSPolicies").add(builder);
            this.requiredHSTSPolicies.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToRequiredHSTSPolicies(int index, RequiredHSTSPolicy item) {
        if (this.requiredHSTSPolicies == null) {
            this.requiredHSTSPolicies = new ArrayList();
        }
        RequiredHSTSPolicyBuilder builder = new RequiredHSTSPolicyBuilder(item);
        if (index < 0 || index >= this.requiredHSTSPolicies.size()) {
            this._visitables.get((Object)"requiredHSTSPolicies").add(builder);
            this.requiredHSTSPolicies.add(builder);
        } else {
            this._visitables.get((Object)"requiredHSTSPolicies").add(builder);
            this.requiredHSTSPolicies.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToRequiredHSTSPolicies(RequiredHSTSPolicy ... items) {
        if (this.requiredHSTSPolicies == null) {
            this.requiredHSTSPolicies = new ArrayList();
        }
        for (RequiredHSTSPolicy item : items) {
            RequiredHSTSPolicyBuilder builder = new RequiredHSTSPolicyBuilder(item);
            this._visitables.get((Object)"requiredHSTSPolicies").add(builder);
            this.requiredHSTSPolicies.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToRequiredHSTSPolicies(Collection<RequiredHSTSPolicy> items) {
        if (this.requiredHSTSPolicies == null) {
            this.requiredHSTSPolicies = new ArrayList();
        }
        for (RequiredHSTSPolicy item : items) {
            RequiredHSTSPolicyBuilder builder = new RequiredHSTSPolicyBuilder(item);
            this._visitables.get((Object)"requiredHSTSPolicies").add(builder);
            this.requiredHSTSPolicies.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromRequiredHSTSPolicies(RequiredHSTSPolicy ... items) {
        if (this.requiredHSTSPolicies == null) {
            return (A)((Object)this);
        }
        for (RequiredHSTSPolicy item : items) {
            RequiredHSTSPolicyBuilder builder = new RequiredHSTSPolicyBuilder(item);
            this._visitables.get((Object)"requiredHSTSPolicies").remove((Object)builder);
            this.requiredHSTSPolicies.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromRequiredHSTSPolicies(Collection<RequiredHSTSPolicy> items) {
        if (this.requiredHSTSPolicies == null) {
            return (A)((Object)this);
        }
        for (RequiredHSTSPolicy item : items) {
            RequiredHSTSPolicyBuilder builder = new RequiredHSTSPolicyBuilder(item);
            this._visitables.get((Object)"requiredHSTSPolicies").remove((Object)builder);
            this.requiredHSTSPolicies.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromRequiredHSTSPolicies(Predicate<RequiredHSTSPolicyBuilder> predicate) {
        if (this.requiredHSTSPolicies == null) {
            return (A)((Object)this);
        }
        Iterator<RequiredHSTSPolicyBuilder> each = this.requiredHSTSPolicies.iterator();
        List visitables = this._visitables.get((Object)"requiredHSTSPolicies");
        while (each.hasNext()) {
            RequiredHSTSPolicyBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<RequiredHSTSPolicy> buildRequiredHSTSPolicies() {
        return this.requiredHSTSPolicies != null ? IngressSpecFluent.build(this.requiredHSTSPolicies) : null;
    }

    public RequiredHSTSPolicy buildRequiredHSTSPolicy(int index) {
        return this.requiredHSTSPolicies.get(index).build();
    }

    public RequiredHSTSPolicy buildFirstRequiredHSTSPolicy() {
        return this.requiredHSTSPolicies.get(0).build();
    }

    public RequiredHSTSPolicy buildLastRequiredHSTSPolicy() {
        return this.requiredHSTSPolicies.get(this.requiredHSTSPolicies.size() - 1).build();
    }

    public RequiredHSTSPolicy buildMatchingRequiredHSTSPolicy(Predicate<RequiredHSTSPolicyBuilder> predicate) {
        for (RequiredHSTSPolicyBuilder item : this.requiredHSTSPolicies) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingRequiredHSTSPolicy(Predicate<RequiredHSTSPolicyBuilder> predicate) {
        for (RequiredHSTSPolicyBuilder item : this.requiredHSTSPolicies) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withRequiredHSTSPolicies(List<RequiredHSTSPolicy> requiredHSTSPolicies) {
        if (this.requiredHSTSPolicies != null) {
            this._visitables.get((Object)"requiredHSTSPolicies").clear();
        }
        if (requiredHSTSPolicies != null) {
            this.requiredHSTSPolicies = new ArrayList();
            for (RequiredHSTSPolicy item : requiredHSTSPolicies) {
                this.addToRequiredHSTSPolicies(item);
            }
        } else {
            this.requiredHSTSPolicies = null;
        }
        return (A)((Object)this);
    }

    public A withRequiredHSTSPolicies(RequiredHSTSPolicy ... requiredHSTSPolicies) {
        if (this.requiredHSTSPolicies != null) {
            this.requiredHSTSPolicies.clear();
            this._visitables.remove((Object)"requiredHSTSPolicies");
        }
        if (requiredHSTSPolicies != null) {
            for (RequiredHSTSPolicy item : requiredHSTSPolicies) {
                this.addToRequiredHSTSPolicies(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasRequiredHSTSPolicies() {
        return this.requiredHSTSPolicies != null && !this.requiredHSTSPolicies.isEmpty();
    }

    public RequiredHSTSPoliciesNested<A> addNewRequiredHSTSPolicy() {
        return new RequiredHSTSPoliciesNested(-1, null);
    }

    public RequiredHSTSPoliciesNested<A> addNewRequiredHSTSPolicyLike(RequiredHSTSPolicy item) {
        return new RequiredHSTSPoliciesNested(-1, item);
    }

    public RequiredHSTSPoliciesNested<A> setNewRequiredHSTSPolicyLike(int index, RequiredHSTSPolicy item) {
        return new RequiredHSTSPoliciesNested(index, item);
    }

    public RequiredHSTSPoliciesNested<A> editRequiredHSTSPolicy(int index) {
        if (this.requiredHSTSPolicies.size() <= index) {
            throw new RuntimeException("Can't edit requiredHSTSPolicies. Index exceeds size.");
        }
        return this.setNewRequiredHSTSPolicyLike(index, this.buildRequiredHSTSPolicy(index));
    }

    public RequiredHSTSPoliciesNested<A> editFirstRequiredHSTSPolicy() {
        if (this.requiredHSTSPolicies.size() == 0) {
            throw new RuntimeException("Can't edit first requiredHSTSPolicies. The list is empty.");
        }
        return this.setNewRequiredHSTSPolicyLike(0, this.buildRequiredHSTSPolicy(0));
    }

    public RequiredHSTSPoliciesNested<A> editLastRequiredHSTSPolicy() {
        int index = this.requiredHSTSPolicies.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last requiredHSTSPolicies. The list is empty.");
        }
        return this.setNewRequiredHSTSPolicyLike(index, this.buildRequiredHSTSPolicy(index));
    }

    public RequiredHSTSPoliciesNested<A> editMatchingRequiredHSTSPolicy(Predicate<RequiredHSTSPolicyBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.requiredHSTSPolicies.size(); ++i) {
            if (!predicate.test(this.requiredHSTSPolicies.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching requiredHSTSPolicies. No match found.");
        }
        return this.setNewRequiredHSTSPolicyLike(index, this.buildRequiredHSTSPolicy(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IngressSpecFluent that = (IngressSpecFluent)((Object)o);
        if (!Objects.equals(this.appsDomain, that.appsDomain)) {
            return false;
        }
        if (!Objects.equals(this.componentRoutes, that.componentRoutes)) {
            return false;
        }
        if (!Objects.equals(this.domain, that.domain)) {
            return false;
        }
        if (!Objects.equals((Object)this.loadBalancer, (Object)that.loadBalancer)) {
            return false;
        }
        if (!Objects.equals(this.requiredHSTSPolicies, that.requiredHSTSPolicies)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.appsDomain, this.componentRoutes, this.domain, this.loadBalancer, this.requiredHSTSPolicies, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.appsDomain != null) {
            sb.append("appsDomain:");
            sb.append(this.appsDomain + ",");
        }
        if (this.componentRoutes != null && !this.componentRoutes.isEmpty()) {
            sb.append("componentRoutes:");
            sb.append(String.valueOf(this.componentRoutes) + ",");
        }
        if (this.domain != null) {
            sb.append("domain:");
            sb.append(this.domain + ",");
        }
        if (this.loadBalancer != null) {
            sb.append("loadBalancer:");
            sb.append(String.valueOf((Object)this.loadBalancer) + ",");
        }
        if (this.requiredHSTSPolicies != null && !this.requiredHSTSPolicies.isEmpty()) {
            sb.append("requiredHSTSPolicies:");
            sb.append(String.valueOf(this.requiredHSTSPolicies) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class RequiredHSTSPoliciesNested<N>
    extends RequiredHSTSPolicyFluent<RequiredHSTSPoliciesNested<N>>
    implements Nested<N> {
        RequiredHSTSPolicyBuilder builder;
        int index;

        RequiredHSTSPoliciesNested(int index, RequiredHSTSPolicy item) {
            this.index = index;
            this.builder = new RequiredHSTSPolicyBuilder(this, item);
        }

        public N and() {
            return (N)IngressSpecFluent.this.setToRequiredHSTSPolicies(this.index, this.builder.build());
        }

        public N endRequiredHSTSPolicy() {
            return this.and();
        }
    }

    public class LoadBalancerNested<N>
    extends LoadBalancerFluent<LoadBalancerNested<N>>
    implements Nested<N> {
        LoadBalancerBuilder builder;

        LoadBalancerNested(LoadBalancer item) {
            this.builder = new LoadBalancerBuilder(this, item);
        }

        public N and() {
            return (N)IngressSpecFluent.this.withLoadBalancer(this.builder.build());
        }

        public N endLoadBalancer() {
            return this.and();
        }
    }

    public class ComponentRoutesNested<N>
    extends ComponentRouteSpecFluent<ComponentRoutesNested<N>>
    implements Nested<N> {
        ComponentRouteSpecBuilder builder;
        int index;

        ComponentRoutesNested(int index, ComponentRouteSpec item) {
            this.index = index;
            this.builder = new ComponentRouteSpecBuilder(this, item);
        }

        public N and() {
            return (N)IngressSpecFluent.this.setToComponentRoutes(this.index, this.builder.build());
        }

        public N endComponentRoute() {
            return this.and();
        }
    }
}

