/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.config.v1.ProjectSpec;
import io.fabric8.openshift.api.model.config.v1.TemplateReference;
import io.fabric8.openshift.api.model.config.v1.TemplateReferenceBuilder;
import io.fabric8.openshift.api.model.config.v1.TemplateReferenceFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ProjectSpecFluent<A extends ProjectSpecFluent<A>>
extends BaseFluent<A> {
    private String projectRequestMessage;
    private TemplateReferenceBuilder projectRequestTemplate;
    private Map<String, Object> additionalProperties;

    public ProjectSpecFluent() {
    }

    public ProjectSpecFluent(ProjectSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ProjectSpec instance) {
        ProjectSpec projectSpec = instance = instance != null ? instance : new ProjectSpec();
        if (instance != null) {
            this.withProjectRequestMessage(instance.getProjectRequestMessage());
            this.withProjectRequestTemplate(instance.getProjectRequestTemplate());
            this.withProjectRequestMessage(instance.getProjectRequestMessage());
            this.withProjectRequestTemplate(instance.getProjectRequestTemplate());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getProjectRequestMessage() {
        return this.projectRequestMessage;
    }

    public A withProjectRequestMessage(String projectRequestMessage) {
        this.projectRequestMessage = projectRequestMessage;
        return (A)((Object)this);
    }

    public boolean hasProjectRequestMessage() {
        return this.projectRequestMessage != null;
    }

    public TemplateReference buildProjectRequestTemplate() {
        return this.projectRequestTemplate != null ? this.projectRequestTemplate.build() : null;
    }

    public A withProjectRequestTemplate(TemplateReference projectRequestTemplate) {
        this._visitables.get((Object)"projectRequestTemplate").remove((Object)this.projectRequestTemplate);
        if (projectRequestTemplate != null) {
            this.projectRequestTemplate = new TemplateReferenceBuilder(projectRequestTemplate);
            this._visitables.get((Object)"projectRequestTemplate").add(this.projectRequestTemplate);
        } else {
            this.projectRequestTemplate = null;
            this._visitables.get((Object)"projectRequestTemplate").remove((Object)this.projectRequestTemplate);
        }
        return (A)((Object)this);
    }

    public boolean hasProjectRequestTemplate() {
        return this.projectRequestTemplate != null;
    }

    public A withNewProjectRequestTemplate(String name) {
        return this.withProjectRequestTemplate(new TemplateReference(name));
    }

    public ProjectRequestTemplateNested<A> withNewProjectRequestTemplate() {
        return new ProjectRequestTemplateNested(null);
    }

    public ProjectRequestTemplateNested<A> withNewProjectRequestTemplateLike(TemplateReference item) {
        return new ProjectRequestTemplateNested(item);
    }

    public ProjectRequestTemplateNested<A> editProjectRequestTemplate() {
        return this.withNewProjectRequestTemplateLike(Optional.ofNullable(this.buildProjectRequestTemplate()).orElse(null));
    }

    public ProjectRequestTemplateNested<A> editOrNewProjectRequestTemplate() {
        return this.withNewProjectRequestTemplateLike(Optional.ofNullable(this.buildProjectRequestTemplate()).orElse(new TemplateReferenceBuilder().build()));
    }

    public ProjectRequestTemplateNested<A> editOrNewProjectRequestTemplateLike(TemplateReference item) {
        return this.withNewProjectRequestTemplateLike(Optional.ofNullable(this.buildProjectRequestTemplate()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ProjectSpecFluent that = (ProjectSpecFluent)((Object)o);
        if (!Objects.equals(this.projectRequestMessage, that.projectRequestMessage)) {
            return false;
        }
        if (!Objects.equals((Object)this.projectRequestTemplate, (Object)that.projectRequestTemplate)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.projectRequestMessage, this.projectRequestTemplate, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.projectRequestMessage != null) {
            sb.append("projectRequestMessage:");
            sb.append(this.projectRequestMessage + ",");
        }
        if (this.projectRequestTemplate != null) {
            sb.append("projectRequestTemplate:");
            sb.append((Object)((Object)this.projectRequestTemplate) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ProjectRequestTemplateNested<N>
    extends TemplateReferenceFluent<ProjectRequestTemplateNested<N>>
    implements Nested<N> {
        TemplateReferenceBuilder builder;

        ProjectRequestTemplateNested(TemplateReference item) {
            this.builder = new TemplateReferenceBuilder(this, item);
        }

        public N and() {
            return (N)ProjectSpecFluent.this.withProjectRequestTemplate(this.builder.build());
        }

        public N endProjectRequestTemplate() {
            return this.and();
        }
    }
}

