package io.fabric8.openshift.api.model.config.v1;

import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Object;
import java.util.Map;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Deprecated;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class PlatformSpecFluentImpl<A extends PlatformSpecFluent<A>> extends BaseFluent<A> implements PlatformSpecFluent<A>{
  public PlatformSpecFluentImpl() {
  }
  public PlatformSpecFluentImpl(PlatformSpec instance) {
    this.withAlibabaCloud(instance.getAlibabaCloud()); 
    this.withAws(instance.getAws()); 
    this.withAzure(instance.getAzure()); 
    this.withBaremetal(instance.getBaremetal()); 
    this.withEquinixMetal(instance.getEquinixMetal()); 
    this.withGcp(instance.getGcp()); 
    this.withIbmcloud(instance.getIbmcloud()); 
    this.withKubevirt(instance.getKubevirt()); 
    this.withOpenstack(instance.getOpenstack()); 
    this.withOvirt(instance.getOvirt()); 
    this.withPowervs(instance.getPowervs()); 
    this.withType(instance.getType()); 
    this.withVsphere(instance.getVsphere()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private AlibabaCloudPlatformSpecBuilder alibabaCloud;
  private AWSPlatformSpecBuilder aws;
  private AzurePlatformSpecBuilder azure;
  private BareMetalPlatformSpecBuilder baremetal;
  private EquinixMetalPlatformSpecBuilder equinixMetal;
  private GCPPlatformSpecBuilder gcp;
  private IBMCloudPlatformSpecBuilder ibmcloud;
  private KubevirtPlatformSpecBuilder kubevirt;
  private OpenStackPlatformSpecBuilder openstack;
  private OvirtPlatformSpecBuilder ovirt;
  private PowerVSPlatformSpecBuilder powervs;
  private String type;
  private VSpherePlatformSpecBuilder vsphere;
  private Map<String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildAlibabaCloud instead.
   * @return The buildable object.
   */
  @Deprecated
  public AlibabaCloudPlatformSpec getAlibabaCloud() {
    return this.alibabaCloud!=null ?this.alibabaCloud.build():null;
  }
  public AlibabaCloudPlatformSpec buildAlibabaCloud() {
    return this.alibabaCloud!=null ?this.alibabaCloud.build():null;
  }
  public A withAlibabaCloud(AlibabaCloudPlatformSpec alibabaCloud) {
    _visitables.get("alibabaCloud").remove(this.alibabaCloud);
    if (alibabaCloud!=null){ this.alibabaCloud= new AlibabaCloudPlatformSpecBuilder(alibabaCloud); _visitables.get("alibabaCloud").add(this.alibabaCloud);} else { this.alibabaCloud = null; _visitables.get("alibabaCloud").remove(this.alibabaCloud); } return (A) this;
  }
  public Boolean hasAlibabaCloud() {
    return this.alibabaCloud != null;
  }
  public PlatformSpecFluent.AlibabaCloudNested<A> withNewAlibabaCloud() {
    return new PlatformSpecFluentImpl.AlibabaCloudNestedImpl();
  }
  public PlatformSpecFluent.AlibabaCloudNested<A> withNewAlibabaCloudLike(AlibabaCloudPlatformSpec item) {
    return new PlatformSpecFluentImpl.AlibabaCloudNestedImpl(item);
  }
  public PlatformSpecFluent.AlibabaCloudNested<A> editAlibabaCloud() {
    return withNewAlibabaCloudLike(getAlibabaCloud());
  }
  public PlatformSpecFluent.AlibabaCloudNested<A> editOrNewAlibabaCloud() {
    return withNewAlibabaCloudLike(getAlibabaCloud() != null ? getAlibabaCloud(): new AlibabaCloudPlatformSpecBuilder().build());
  }
  public PlatformSpecFluent.AlibabaCloudNested<A> editOrNewAlibabaCloudLike(AlibabaCloudPlatformSpec item) {
    return withNewAlibabaCloudLike(getAlibabaCloud() != null ? getAlibabaCloud(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildAws instead.
   * @return The buildable object.
   */
  @Deprecated
  public AWSPlatformSpec getAws() {
    return this.aws!=null ?this.aws.build():null;
  }
  public AWSPlatformSpec buildAws() {
    return this.aws!=null ?this.aws.build():null;
  }
  public A withAws(AWSPlatformSpec aws) {
    _visitables.get("aws").remove(this.aws);
    if (aws!=null){ this.aws= new AWSPlatformSpecBuilder(aws); _visitables.get("aws").add(this.aws);} else { this.aws = null; _visitables.get("aws").remove(this.aws); } return (A) this;
  }
  public Boolean hasAws() {
    return this.aws != null;
  }
  public PlatformSpecFluent.AwsNested<A> withNewAws() {
    return new PlatformSpecFluentImpl.AwsNestedImpl();
  }
  public PlatformSpecFluent.AwsNested<A> withNewAwsLike(AWSPlatformSpec item) {
    return new PlatformSpecFluentImpl.AwsNestedImpl(item);
  }
  public PlatformSpecFluent.AwsNested<A> editAws() {
    return withNewAwsLike(getAws());
  }
  public PlatformSpecFluent.AwsNested<A> editOrNewAws() {
    return withNewAwsLike(getAws() != null ? getAws(): new AWSPlatformSpecBuilder().build());
  }
  public PlatformSpecFluent.AwsNested<A> editOrNewAwsLike(AWSPlatformSpec item) {
    return withNewAwsLike(getAws() != null ? getAws(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildAzure instead.
   * @return The buildable object.
   */
  @Deprecated
  public AzurePlatformSpec getAzure() {
    return this.azure!=null ?this.azure.build():null;
  }
  public AzurePlatformSpec buildAzure() {
    return this.azure!=null ?this.azure.build():null;
  }
  public A withAzure(AzurePlatformSpec azure) {
    _visitables.get("azure").remove(this.azure);
    if (azure!=null){ this.azure= new AzurePlatformSpecBuilder(azure); _visitables.get("azure").add(this.azure);} else { this.azure = null; _visitables.get("azure").remove(this.azure); } return (A) this;
  }
  public Boolean hasAzure() {
    return this.azure != null;
  }
  public PlatformSpecFluent.AzureNested<A> withNewAzure() {
    return new PlatformSpecFluentImpl.AzureNestedImpl();
  }
  public PlatformSpecFluent.AzureNested<A> withNewAzureLike(AzurePlatformSpec item) {
    return new PlatformSpecFluentImpl.AzureNestedImpl(item);
  }
  public PlatformSpecFluent.AzureNested<A> editAzure() {
    return withNewAzureLike(getAzure());
  }
  public PlatformSpecFluent.AzureNested<A> editOrNewAzure() {
    return withNewAzureLike(getAzure() != null ? getAzure(): new AzurePlatformSpecBuilder().build());
  }
  public PlatformSpecFluent.AzureNested<A> editOrNewAzureLike(AzurePlatformSpec item) {
    return withNewAzureLike(getAzure() != null ? getAzure(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildBaremetal instead.
   * @return The buildable object.
   */
  @Deprecated
  public BareMetalPlatformSpec getBaremetal() {
    return this.baremetal!=null ?this.baremetal.build():null;
  }
  public BareMetalPlatformSpec buildBaremetal() {
    return this.baremetal!=null ?this.baremetal.build():null;
  }
  public A withBaremetal(BareMetalPlatformSpec baremetal) {
    _visitables.get("baremetal").remove(this.baremetal);
    if (baremetal!=null){ this.baremetal= new BareMetalPlatformSpecBuilder(baremetal); _visitables.get("baremetal").add(this.baremetal);} else { this.baremetal = null; _visitables.get("baremetal").remove(this.baremetal); } return (A) this;
  }
  public Boolean hasBaremetal() {
    return this.baremetal != null;
  }
  public PlatformSpecFluent.BaremetalNested<A> withNewBaremetal() {
    return new PlatformSpecFluentImpl.BaremetalNestedImpl();
  }
  public PlatformSpecFluent.BaremetalNested<A> withNewBaremetalLike(BareMetalPlatformSpec item) {
    return new PlatformSpecFluentImpl.BaremetalNestedImpl(item);
  }
  public PlatformSpecFluent.BaremetalNested<A> editBaremetal() {
    return withNewBaremetalLike(getBaremetal());
  }
  public PlatformSpecFluent.BaremetalNested<A> editOrNewBaremetal() {
    return withNewBaremetalLike(getBaremetal() != null ? getBaremetal(): new BareMetalPlatformSpecBuilder().build());
  }
  public PlatformSpecFluent.BaremetalNested<A> editOrNewBaremetalLike(BareMetalPlatformSpec item) {
    return withNewBaremetalLike(getBaremetal() != null ? getBaremetal(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildEquinixMetal instead.
   * @return The buildable object.
   */
  @Deprecated
  public EquinixMetalPlatformSpec getEquinixMetal() {
    return this.equinixMetal!=null ?this.equinixMetal.build():null;
  }
  public EquinixMetalPlatformSpec buildEquinixMetal() {
    return this.equinixMetal!=null ?this.equinixMetal.build():null;
  }
  public A withEquinixMetal(EquinixMetalPlatformSpec equinixMetal) {
    _visitables.get("equinixMetal").remove(this.equinixMetal);
    if (equinixMetal!=null){ this.equinixMetal= new EquinixMetalPlatformSpecBuilder(equinixMetal); _visitables.get("equinixMetal").add(this.equinixMetal);} else { this.equinixMetal = null; _visitables.get("equinixMetal").remove(this.equinixMetal); } return (A) this;
  }
  public Boolean hasEquinixMetal() {
    return this.equinixMetal != null;
  }
  public PlatformSpecFluent.EquinixMetalNested<A> withNewEquinixMetal() {
    return new PlatformSpecFluentImpl.EquinixMetalNestedImpl();
  }
  public PlatformSpecFluent.EquinixMetalNested<A> withNewEquinixMetalLike(EquinixMetalPlatformSpec item) {
    return new PlatformSpecFluentImpl.EquinixMetalNestedImpl(item);
  }
  public PlatformSpecFluent.EquinixMetalNested<A> editEquinixMetal() {
    return withNewEquinixMetalLike(getEquinixMetal());
  }
  public PlatformSpecFluent.EquinixMetalNested<A> editOrNewEquinixMetal() {
    return withNewEquinixMetalLike(getEquinixMetal() != null ? getEquinixMetal(): new EquinixMetalPlatformSpecBuilder().build());
  }
  public PlatformSpecFluent.EquinixMetalNested<A> editOrNewEquinixMetalLike(EquinixMetalPlatformSpec item) {
    return withNewEquinixMetalLike(getEquinixMetal() != null ? getEquinixMetal(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildGcp instead.
   * @return The buildable object.
   */
  @Deprecated
  public GCPPlatformSpec getGcp() {
    return this.gcp!=null ?this.gcp.build():null;
  }
  public GCPPlatformSpec buildGcp() {
    return this.gcp!=null ?this.gcp.build():null;
  }
  public A withGcp(GCPPlatformSpec gcp) {
    _visitables.get("gcp").remove(this.gcp);
    if (gcp!=null){ this.gcp= new GCPPlatformSpecBuilder(gcp); _visitables.get("gcp").add(this.gcp);} else { this.gcp = null; _visitables.get("gcp").remove(this.gcp); } return (A) this;
  }
  public Boolean hasGcp() {
    return this.gcp != null;
  }
  public PlatformSpecFluent.GcpNested<A> withNewGcp() {
    return new PlatformSpecFluentImpl.GcpNestedImpl();
  }
  public PlatformSpecFluent.GcpNested<A> withNewGcpLike(GCPPlatformSpec item) {
    return new PlatformSpecFluentImpl.GcpNestedImpl(item);
  }
  public PlatformSpecFluent.GcpNested<A> editGcp() {
    return withNewGcpLike(getGcp());
  }
  public PlatformSpecFluent.GcpNested<A> editOrNewGcp() {
    return withNewGcpLike(getGcp() != null ? getGcp(): new GCPPlatformSpecBuilder().build());
  }
  public PlatformSpecFluent.GcpNested<A> editOrNewGcpLike(GCPPlatformSpec item) {
    return withNewGcpLike(getGcp() != null ? getGcp(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildIbmcloud instead.
   * @return The buildable object.
   */
  @Deprecated
  public IBMCloudPlatformSpec getIbmcloud() {
    return this.ibmcloud!=null ?this.ibmcloud.build():null;
  }
  public IBMCloudPlatformSpec buildIbmcloud() {
    return this.ibmcloud!=null ?this.ibmcloud.build():null;
  }
  public A withIbmcloud(IBMCloudPlatformSpec ibmcloud) {
    _visitables.get("ibmcloud").remove(this.ibmcloud);
    if (ibmcloud!=null){ this.ibmcloud= new IBMCloudPlatformSpecBuilder(ibmcloud); _visitables.get("ibmcloud").add(this.ibmcloud);} else { this.ibmcloud = null; _visitables.get("ibmcloud").remove(this.ibmcloud); } return (A) this;
  }
  public Boolean hasIbmcloud() {
    return this.ibmcloud != null;
  }
  public PlatformSpecFluent.IbmcloudNested<A> withNewIbmcloud() {
    return new PlatformSpecFluentImpl.IbmcloudNestedImpl();
  }
  public PlatformSpecFluent.IbmcloudNested<A> withNewIbmcloudLike(IBMCloudPlatformSpec item) {
    return new PlatformSpecFluentImpl.IbmcloudNestedImpl(item);
  }
  public PlatformSpecFluent.IbmcloudNested<A> editIbmcloud() {
    return withNewIbmcloudLike(getIbmcloud());
  }
  public PlatformSpecFluent.IbmcloudNested<A> editOrNewIbmcloud() {
    return withNewIbmcloudLike(getIbmcloud() != null ? getIbmcloud(): new IBMCloudPlatformSpecBuilder().build());
  }
  public PlatformSpecFluent.IbmcloudNested<A> editOrNewIbmcloudLike(IBMCloudPlatformSpec item) {
    return withNewIbmcloudLike(getIbmcloud() != null ? getIbmcloud(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildKubevirt instead.
   * @return The buildable object.
   */
  @Deprecated
  public KubevirtPlatformSpec getKubevirt() {
    return this.kubevirt!=null ?this.kubevirt.build():null;
  }
  public KubevirtPlatformSpec buildKubevirt() {
    return this.kubevirt!=null ?this.kubevirt.build():null;
  }
  public A withKubevirt(KubevirtPlatformSpec kubevirt) {
    _visitables.get("kubevirt").remove(this.kubevirt);
    if (kubevirt!=null){ this.kubevirt= new KubevirtPlatformSpecBuilder(kubevirt); _visitables.get("kubevirt").add(this.kubevirt);} else { this.kubevirt = null; _visitables.get("kubevirt").remove(this.kubevirt); } return (A) this;
  }
  public Boolean hasKubevirt() {
    return this.kubevirt != null;
  }
  public PlatformSpecFluent.KubevirtNested<A> withNewKubevirt() {
    return new PlatformSpecFluentImpl.KubevirtNestedImpl();
  }
  public PlatformSpecFluent.KubevirtNested<A> withNewKubevirtLike(KubevirtPlatformSpec item) {
    return new PlatformSpecFluentImpl.KubevirtNestedImpl(item);
  }
  public PlatformSpecFluent.KubevirtNested<A> editKubevirt() {
    return withNewKubevirtLike(getKubevirt());
  }
  public PlatformSpecFluent.KubevirtNested<A> editOrNewKubevirt() {
    return withNewKubevirtLike(getKubevirt() != null ? getKubevirt(): new KubevirtPlatformSpecBuilder().build());
  }
  public PlatformSpecFluent.KubevirtNested<A> editOrNewKubevirtLike(KubevirtPlatformSpec item) {
    return withNewKubevirtLike(getKubevirt() != null ? getKubevirt(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildOpenstack instead.
   * @return The buildable object.
   */
  @Deprecated
  public OpenStackPlatformSpec getOpenstack() {
    return this.openstack!=null ?this.openstack.build():null;
  }
  public OpenStackPlatformSpec buildOpenstack() {
    return this.openstack!=null ?this.openstack.build():null;
  }
  public A withOpenstack(OpenStackPlatformSpec openstack) {
    _visitables.get("openstack").remove(this.openstack);
    if (openstack!=null){ this.openstack= new OpenStackPlatformSpecBuilder(openstack); _visitables.get("openstack").add(this.openstack);} else { this.openstack = null; _visitables.get("openstack").remove(this.openstack); } return (A) this;
  }
  public Boolean hasOpenstack() {
    return this.openstack != null;
  }
  public PlatformSpecFluent.OpenstackNested<A> withNewOpenstack() {
    return new PlatformSpecFluentImpl.OpenstackNestedImpl();
  }
  public PlatformSpecFluent.OpenstackNested<A> withNewOpenstackLike(OpenStackPlatformSpec item) {
    return new PlatformSpecFluentImpl.OpenstackNestedImpl(item);
  }
  public PlatformSpecFluent.OpenstackNested<A> editOpenstack() {
    return withNewOpenstackLike(getOpenstack());
  }
  public PlatformSpecFluent.OpenstackNested<A> editOrNewOpenstack() {
    return withNewOpenstackLike(getOpenstack() != null ? getOpenstack(): new OpenStackPlatformSpecBuilder().build());
  }
  public PlatformSpecFluent.OpenstackNested<A> editOrNewOpenstackLike(OpenStackPlatformSpec item) {
    return withNewOpenstackLike(getOpenstack() != null ? getOpenstack(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildOvirt instead.
   * @return The buildable object.
   */
  @Deprecated
  public OvirtPlatformSpec getOvirt() {
    return this.ovirt!=null ?this.ovirt.build():null;
  }
  public OvirtPlatformSpec buildOvirt() {
    return this.ovirt!=null ?this.ovirt.build():null;
  }
  public A withOvirt(OvirtPlatformSpec ovirt) {
    _visitables.get("ovirt").remove(this.ovirt);
    if (ovirt!=null){ this.ovirt= new OvirtPlatformSpecBuilder(ovirt); _visitables.get("ovirt").add(this.ovirt);} else { this.ovirt = null; _visitables.get("ovirt").remove(this.ovirt); } return (A) this;
  }
  public Boolean hasOvirt() {
    return this.ovirt != null;
  }
  public PlatformSpecFluent.OvirtNested<A> withNewOvirt() {
    return new PlatformSpecFluentImpl.OvirtNestedImpl();
  }
  public PlatformSpecFluent.OvirtNested<A> withNewOvirtLike(OvirtPlatformSpec item) {
    return new PlatformSpecFluentImpl.OvirtNestedImpl(item);
  }
  public PlatformSpecFluent.OvirtNested<A> editOvirt() {
    return withNewOvirtLike(getOvirt());
  }
  public PlatformSpecFluent.OvirtNested<A> editOrNewOvirt() {
    return withNewOvirtLike(getOvirt() != null ? getOvirt(): new OvirtPlatformSpecBuilder().build());
  }
  public PlatformSpecFluent.OvirtNested<A> editOrNewOvirtLike(OvirtPlatformSpec item) {
    return withNewOvirtLike(getOvirt() != null ? getOvirt(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildPowervs instead.
   * @return The buildable object.
   */
  @Deprecated
  public PowerVSPlatformSpec getPowervs() {
    return this.powervs!=null ?this.powervs.build():null;
  }
  public PowerVSPlatformSpec buildPowervs() {
    return this.powervs!=null ?this.powervs.build():null;
  }
  public A withPowervs(PowerVSPlatformSpec powervs) {
    _visitables.get("powervs").remove(this.powervs);
    if (powervs!=null){ this.powervs= new PowerVSPlatformSpecBuilder(powervs); _visitables.get("powervs").add(this.powervs);} else { this.powervs = null; _visitables.get("powervs").remove(this.powervs); } return (A) this;
  }
  public Boolean hasPowervs() {
    return this.powervs != null;
  }
  public PlatformSpecFluent.PowervsNested<A> withNewPowervs() {
    return new PlatformSpecFluentImpl.PowervsNestedImpl();
  }
  public PlatformSpecFluent.PowervsNested<A> withNewPowervsLike(PowerVSPlatformSpec item) {
    return new PlatformSpecFluentImpl.PowervsNestedImpl(item);
  }
  public PlatformSpecFluent.PowervsNested<A> editPowervs() {
    return withNewPowervsLike(getPowervs());
  }
  public PlatformSpecFluent.PowervsNested<A> editOrNewPowervs() {
    return withNewPowervsLike(getPowervs() != null ? getPowervs(): new PowerVSPlatformSpecBuilder().build());
  }
  public PlatformSpecFluent.PowervsNested<A> editOrNewPowervsLike(PowerVSPlatformSpec item) {
    return withNewPowervsLike(getPowervs() != null ? getPowervs(): item);
  }
  public String getType() {
    return this.type;
  }
  public A withType(String type) {
    this.type=type; return (A) this;
  }
  public Boolean hasType() {
    return this.type != null;
  }
  
  /**
   * This method has been deprecated, please use method buildVsphere instead.
   * @return The buildable object.
   */
  @Deprecated
  public VSpherePlatformSpec getVsphere() {
    return this.vsphere!=null ?this.vsphere.build():null;
  }
  public VSpherePlatformSpec buildVsphere() {
    return this.vsphere!=null ?this.vsphere.build():null;
  }
  public A withVsphere(VSpherePlatformSpec vsphere) {
    _visitables.get("vsphere").remove(this.vsphere);
    if (vsphere!=null){ this.vsphere= new VSpherePlatformSpecBuilder(vsphere); _visitables.get("vsphere").add(this.vsphere);} else { this.vsphere = null; _visitables.get("vsphere").remove(this.vsphere); } return (A) this;
  }
  public Boolean hasVsphere() {
    return this.vsphere != null;
  }
  public PlatformSpecFluent.VsphereNested<A> withNewVsphere() {
    return new PlatformSpecFluentImpl.VsphereNestedImpl();
  }
  public PlatformSpecFluent.VsphereNested<A> withNewVsphereLike(VSpherePlatformSpec item) {
    return new PlatformSpecFluentImpl.VsphereNestedImpl(item);
  }
  public PlatformSpecFluent.VsphereNested<A> editVsphere() {
    return withNewVsphereLike(getVsphere());
  }
  public PlatformSpecFluent.VsphereNested<A> editOrNewVsphere() {
    return withNewVsphereLike(getVsphere() != null ? getVsphere(): new VSpherePlatformSpecBuilder().build());
  }
  public PlatformSpecFluent.VsphereNested<A> editOrNewVsphereLike(VSpherePlatformSpec item) {
    return withNewVsphereLike(getVsphere() != null ? getVsphere(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    PlatformSpecFluentImpl that = (PlatformSpecFluentImpl) o;
    if (alibabaCloud != null ? !alibabaCloud.equals(that.alibabaCloud) :that.alibabaCloud != null) return false;
    if (aws != null ? !aws.equals(that.aws) :that.aws != null) return false;
    if (azure != null ? !azure.equals(that.azure) :that.azure != null) return false;
    if (baremetal != null ? !baremetal.equals(that.baremetal) :that.baremetal != null) return false;
    if (equinixMetal != null ? !equinixMetal.equals(that.equinixMetal) :that.equinixMetal != null) return false;
    if (gcp != null ? !gcp.equals(that.gcp) :that.gcp != null) return false;
    if (ibmcloud != null ? !ibmcloud.equals(that.ibmcloud) :that.ibmcloud != null) return false;
    if (kubevirt != null ? !kubevirt.equals(that.kubevirt) :that.kubevirt != null) return false;
    if (openstack != null ? !openstack.equals(that.openstack) :that.openstack != null) return false;
    if (ovirt != null ? !ovirt.equals(that.ovirt) :that.ovirt != null) return false;
    if (powervs != null ? !powervs.equals(that.powervs) :that.powervs != null) return false;
    if (type != null ? !type.equals(that.type) :that.type != null) return false;
    if (vsphere != null ? !vsphere.equals(that.vsphere) :that.vsphere != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(alibabaCloud,  aws,  azure,  baremetal,  equinixMetal,  gcp,  ibmcloud,  kubevirt,  openstack,  ovirt,  powervs,  type,  vsphere,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (alibabaCloud != null) { sb.append("alibabaCloud:"); sb.append(alibabaCloud + ","); }
    if (aws != null) { sb.append("aws:"); sb.append(aws + ","); }
    if (azure != null) { sb.append("azure:"); sb.append(azure + ","); }
    if (baremetal != null) { sb.append("baremetal:"); sb.append(baremetal + ","); }
    if (equinixMetal != null) { sb.append("equinixMetal:"); sb.append(equinixMetal + ","); }
    if (gcp != null) { sb.append("gcp:"); sb.append(gcp + ","); }
    if (ibmcloud != null) { sb.append("ibmcloud:"); sb.append(ibmcloud + ","); }
    if (kubevirt != null) { sb.append("kubevirt:"); sb.append(kubevirt + ","); }
    if (openstack != null) { sb.append("openstack:"); sb.append(openstack + ","); }
    if (ovirt != null) { sb.append("ovirt:"); sb.append(ovirt + ","); }
    if (powervs != null) { sb.append("powervs:"); sb.append(powervs + ","); }
    if (type != null) { sb.append("type:"); sb.append(type + ","); }
    if (vsphere != null) { sb.append("vsphere:"); sb.append(vsphere + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class AlibabaCloudNestedImpl<N> extends AlibabaCloudPlatformSpecFluentImpl<PlatformSpecFluent.AlibabaCloudNested<N>> implements PlatformSpecFluent.AlibabaCloudNested<N>,Nested<N>{
    AlibabaCloudNestedImpl(AlibabaCloudPlatformSpec item) {
      this.builder = new AlibabaCloudPlatformSpecBuilder(this, item);
    }
    AlibabaCloudNestedImpl() {
      this.builder = new AlibabaCloudPlatformSpecBuilder(this);
    }
    AlibabaCloudPlatformSpecBuilder builder;
    public N and() {
      return (N) PlatformSpecFluentImpl.this.withAlibabaCloud(builder.build());
    }
    public N endAlibabaCloud() {
      return and();
    }
    
  }
  class AwsNestedImpl<N> extends AWSPlatformSpecFluentImpl<PlatformSpecFluent.AwsNested<N>> implements PlatformSpecFluent.AwsNested<N>,Nested<N>{
    AwsNestedImpl(AWSPlatformSpec item) {
      this.builder = new AWSPlatformSpecBuilder(this, item);
    }
    AwsNestedImpl() {
      this.builder = new AWSPlatformSpecBuilder(this);
    }
    AWSPlatformSpecBuilder builder;
    public N and() {
      return (N) PlatformSpecFluentImpl.this.withAws(builder.build());
    }
    public N endAws() {
      return and();
    }
    
  }
  class AzureNestedImpl<N> extends AzurePlatformSpecFluentImpl<PlatformSpecFluent.AzureNested<N>> implements PlatformSpecFluent.AzureNested<N>,Nested<N>{
    AzureNestedImpl(AzurePlatformSpec item) {
      this.builder = new AzurePlatformSpecBuilder(this, item);
    }
    AzureNestedImpl() {
      this.builder = new AzurePlatformSpecBuilder(this);
    }
    AzurePlatformSpecBuilder builder;
    public N and() {
      return (N) PlatformSpecFluentImpl.this.withAzure(builder.build());
    }
    public N endAzure() {
      return and();
    }
    
  }
  class BaremetalNestedImpl<N> extends BareMetalPlatformSpecFluentImpl<PlatformSpecFluent.BaremetalNested<N>> implements PlatformSpecFluent.BaremetalNested<N>,Nested<N>{
    BaremetalNestedImpl(BareMetalPlatformSpec item) {
      this.builder = new BareMetalPlatformSpecBuilder(this, item);
    }
    BaremetalNestedImpl() {
      this.builder = new BareMetalPlatformSpecBuilder(this);
    }
    BareMetalPlatformSpecBuilder builder;
    public N and() {
      return (N) PlatformSpecFluentImpl.this.withBaremetal(builder.build());
    }
    public N endBaremetal() {
      return and();
    }
    
  }
  class EquinixMetalNestedImpl<N> extends EquinixMetalPlatformSpecFluentImpl<PlatformSpecFluent.EquinixMetalNested<N>> implements PlatformSpecFluent.EquinixMetalNested<N>,Nested<N>{
    EquinixMetalNestedImpl(EquinixMetalPlatformSpec item) {
      this.builder = new EquinixMetalPlatformSpecBuilder(this, item);
    }
    EquinixMetalNestedImpl() {
      this.builder = new EquinixMetalPlatformSpecBuilder(this);
    }
    EquinixMetalPlatformSpecBuilder builder;
    public N and() {
      return (N) PlatformSpecFluentImpl.this.withEquinixMetal(builder.build());
    }
    public N endEquinixMetal() {
      return and();
    }
    
  }
  class GcpNestedImpl<N> extends GCPPlatformSpecFluentImpl<PlatformSpecFluent.GcpNested<N>> implements PlatformSpecFluent.GcpNested<N>,Nested<N>{
    GcpNestedImpl(GCPPlatformSpec item) {
      this.builder = new GCPPlatformSpecBuilder(this, item);
    }
    GcpNestedImpl() {
      this.builder = new GCPPlatformSpecBuilder(this);
    }
    GCPPlatformSpecBuilder builder;
    public N and() {
      return (N) PlatformSpecFluentImpl.this.withGcp(builder.build());
    }
    public N endGcp() {
      return and();
    }
    
  }
  class IbmcloudNestedImpl<N> extends IBMCloudPlatformSpecFluentImpl<PlatformSpecFluent.IbmcloudNested<N>> implements PlatformSpecFluent.IbmcloudNested<N>,Nested<N>{
    IbmcloudNestedImpl(IBMCloudPlatformSpec item) {
      this.builder = new IBMCloudPlatformSpecBuilder(this, item);
    }
    IbmcloudNestedImpl() {
      this.builder = new IBMCloudPlatformSpecBuilder(this);
    }
    IBMCloudPlatformSpecBuilder builder;
    public N and() {
      return (N) PlatformSpecFluentImpl.this.withIbmcloud(builder.build());
    }
    public N endIbmcloud() {
      return and();
    }
    
  }
  class KubevirtNestedImpl<N> extends KubevirtPlatformSpecFluentImpl<PlatformSpecFluent.KubevirtNested<N>> implements PlatformSpecFluent.KubevirtNested<N>,Nested<N>{
    KubevirtNestedImpl(KubevirtPlatformSpec item) {
      this.builder = new KubevirtPlatformSpecBuilder(this, item);
    }
    KubevirtNestedImpl() {
      this.builder = new KubevirtPlatformSpecBuilder(this);
    }
    KubevirtPlatformSpecBuilder builder;
    public N and() {
      return (N) PlatformSpecFluentImpl.this.withKubevirt(builder.build());
    }
    public N endKubevirt() {
      return and();
    }
    
  }
  class OpenstackNestedImpl<N> extends OpenStackPlatformSpecFluentImpl<PlatformSpecFluent.OpenstackNested<N>> implements PlatformSpecFluent.OpenstackNested<N>,Nested<N>{
    OpenstackNestedImpl(OpenStackPlatformSpec item) {
      this.builder = new OpenStackPlatformSpecBuilder(this, item);
    }
    OpenstackNestedImpl() {
      this.builder = new OpenStackPlatformSpecBuilder(this);
    }
    OpenStackPlatformSpecBuilder builder;
    public N and() {
      return (N) PlatformSpecFluentImpl.this.withOpenstack(builder.build());
    }
    public N endOpenstack() {
      return and();
    }
    
  }
  class OvirtNestedImpl<N> extends OvirtPlatformSpecFluentImpl<PlatformSpecFluent.OvirtNested<N>> implements PlatformSpecFluent.OvirtNested<N>,Nested<N>{
    OvirtNestedImpl(OvirtPlatformSpec item) {
      this.builder = new OvirtPlatformSpecBuilder(this, item);
    }
    OvirtNestedImpl() {
      this.builder = new OvirtPlatformSpecBuilder(this);
    }
    OvirtPlatformSpecBuilder builder;
    public N and() {
      return (N) PlatformSpecFluentImpl.this.withOvirt(builder.build());
    }
    public N endOvirt() {
      return and();
    }
    
  }
  class PowervsNestedImpl<N> extends PowerVSPlatformSpecFluentImpl<PlatformSpecFluent.PowervsNested<N>> implements PlatformSpecFluent.PowervsNested<N>,Nested<N>{
    PowervsNestedImpl(PowerVSPlatformSpec item) {
      this.builder = new PowerVSPlatformSpecBuilder(this, item);
    }
    PowervsNestedImpl() {
      this.builder = new PowerVSPlatformSpecBuilder(this);
    }
    PowerVSPlatformSpecBuilder builder;
    public N and() {
      return (N) PlatformSpecFluentImpl.this.withPowervs(builder.build());
    }
    public N endPowervs() {
      return and();
    }
    
  }
  class VsphereNestedImpl<N> extends VSpherePlatformSpecFluentImpl<PlatformSpecFluent.VsphereNested<N>> implements PlatformSpecFluent.VsphereNested<N>,Nested<N>{
    VsphereNestedImpl(VSpherePlatformSpec item) {
      this.builder = new VSpherePlatformSpecBuilder(this, item);
    }
    VsphereNestedImpl() {
      this.builder = new VSpherePlatformSpecBuilder(this);
    }
    VSpherePlatformSpecBuilder builder;
    public N and() {
      return (N) PlatformSpecFluentImpl.this.withVsphere(builder.build());
    }
    public N endVsphere() {
      return and();
    }
    
  }
  
}