package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class OperatorHubStatusFluentImpl<A extends OperatorHubStatusFluent<A>> extends BaseFluent<A> implements OperatorHubStatusFluent<A>{
  public OperatorHubStatusFluentImpl() {
  }
  public OperatorHubStatusFluentImpl(OperatorHubStatus instance) {
    this.withSources(instance.getSources()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private ArrayList<HubSourceStatusBuilder> sources = new ArrayList<HubSourceStatusBuilder>();
  private Map<String,Object> additionalProperties;
  public A addToSources(Integer index,HubSourceStatus item) {
    if (this.sources == null) {this.sources = new ArrayList<HubSourceStatusBuilder>();}
    HubSourceStatusBuilder builder = new HubSourceStatusBuilder(item);_visitables.get("sources").add(index >= 0 ? index : _visitables.get("sources").size(), builder);this.sources.add(index >= 0 ? index : sources.size(), builder); return (A)this;
  }
  public A setToSources(Integer index,HubSourceStatus item) {
    if (this.sources == null) {this.sources = new ArrayList<HubSourceStatusBuilder>();}
    HubSourceStatusBuilder builder = new HubSourceStatusBuilder(item);
    if (index < 0 || index >= _visitables.get("sources").size()) { _visitables.get("sources").add(builder); } else { _visitables.get("sources").set(index, builder);}
    if (index < 0 || index >= sources.size()) { sources.add(builder); } else { sources.set(index, builder);}
     return (A)this;
  }
  public A addToSources(io.fabric8.openshift.api.model.config.v1.HubSourceStatus... items) {
    if (this.sources == null) {this.sources = new ArrayList<HubSourceStatusBuilder>();}
    for (HubSourceStatus item : items) {HubSourceStatusBuilder builder = new HubSourceStatusBuilder(item);_visitables.get("sources").add(builder);this.sources.add(builder);} return (A)this;
  }
  public A addAllToSources(Collection<HubSourceStatus> items) {
    if (this.sources == null) {this.sources = new ArrayList<HubSourceStatusBuilder>();}
    for (HubSourceStatus item : items) {HubSourceStatusBuilder builder = new HubSourceStatusBuilder(item);_visitables.get("sources").add(builder);this.sources.add(builder);} return (A)this;
  }
  public A removeFromSources(io.fabric8.openshift.api.model.config.v1.HubSourceStatus... items) {
    for (HubSourceStatus item : items) {HubSourceStatusBuilder builder = new HubSourceStatusBuilder(item);_visitables.get("sources").remove(builder);if (this.sources != null) {this.sources.remove(builder);}} return (A)this;
  }
  public A removeAllFromSources(Collection<HubSourceStatus> items) {
    for (HubSourceStatus item : items) {HubSourceStatusBuilder builder = new HubSourceStatusBuilder(item);_visitables.get("sources").remove(builder);if (this.sources != null) {this.sources.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromSources(Predicate<HubSourceStatusBuilder> predicate) {
    if (sources == null) return (A) this;
    final Iterator<HubSourceStatusBuilder> each = sources.iterator();
    final List visitables = _visitables.get("sources");
    while (each.hasNext()) {
      HubSourceStatusBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildSources instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<HubSourceStatus> getSources() {
    return sources != null ? build(sources) : null;
  }
  public List<HubSourceStatus> buildSources() {
    return sources != null ? build(sources) : null;
  }
  public HubSourceStatus buildSource(Integer index) {
    return this.sources.get(index).build();
  }
  public HubSourceStatus buildFirstSource() {
    return this.sources.get(0).build();
  }
  public HubSourceStatus buildLastSource() {
    return this.sources.get(sources.size() - 1).build();
  }
  public HubSourceStatus buildMatchingSource(Predicate<HubSourceStatusBuilder> predicate) {
    for (HubSourceStatusBuilder item: sources) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingSource(Predicate<HubSourceStatusBuilder> predicate) {
    for (HubSourceStatusBuilder item: sources) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withSources(List<HubSourceStatus> sources) {
    if (this.sources != null) { _visitables.get("sources").removeAll(this.sources);}
    if (sources != null) {this.sources = new ArrayList(); for (HubSourceStatus item : sources){this.addToSources(item);}} else { this.sources = null;} return (A) this;
  }
  public A withSources(io.fabric8.openshift.api.model.config.v1.HubSourceStatus... sources) {
    if (this.sources != null) {this.sources.clear();}
    if (sources != null) {for (HubSourceStatus item :sources){ this.addToSources(item);}} return (A) this;
  }
  public Boolean hasSources() {
    return sources != null && !sources.isEmpty();
  }
  public A addNewSource(Boolean disabled,String message,String name,String status) {
    return (A)addToSources(new HubSourceStatus(disabled, message, name, status));
  }
  public OperatorHubStatusFluent.SourcesNested<A> addNewSource() {
    return new OperatorHubStatusFluentImpl.SourcesNestedImpl();
  }
  public OperatorHubStatusFluent.SourcesNested<A> addNewSourceLike(HubSourceStatus item) {
    return new OperatorHubStatusFluentImpl.SourcesNestedImpl(-1, item);
  }
  public OperatorHubStatusFluent.SourcesNested<A> setNewSourceLike(Integer index,HubSourceStatus item) {
    return new OperatorHubStatusFluentImpl.SourcesNestedImpl(index, item);
  }
  public OperatorHubStatusFluent.SourcesNested<A> editSource(Integer index) {
    if (sources.size() <= index) throw new RuntimeException("Can't edit sources. Index exceeds size.");
    return setNewSourceLike(index, buildSource(index));
  }
  public OperatorHubStatusFluent.SourcesNested<A> editFirstSource() {
    if (sources.size() == 0) throw new RuntimeException("Can't edit first sources. The list is empty.");
    return setNewSourceLike(0, buildSource(0));
  }
  public OperatorHubStatusFluent.SourcesNested<A> editLastSource() {
    int index = sources.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last sources. The list is empty.");
    return setNewSourceLike(index, buildSource(index));
  }
  public OperatorHubStatusFluent.SourcesNested<A> editMatchingSource(Predicate<HubSourceStatusBuilder> predicate) {
    int index = -1;
    for (int i=0;i<sources.size();i++) { 
    if (predicate.test(sources.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching sources. No match found.");
    return setNewSourceLike(index, buildSource(index));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    OperatorHubStatusFluentImpl that = (OperatorHubStatusFluentImpl) o;
    if (sources != null ? !sources.equals(that.sources) :that.sources != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(sources,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (sources != null && !sources.isEmpty()) { sb.append("sources:"); sb.append(sources + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class SourcesNestedImpl<N> extends HubSourceStatusFluentImpl<OperatorHubStatusFluent.SourcesNested<N>> implements OperatorHubStatusFluent.SourcesNested<N>,Nested<N>{
    SourcesNestedImpl(Integer index,HubSourceStatus item) {
      this.index = index;
      this.builder = new HubSourceStatusBuilder(this, item);
    }
    SourcesNestedImpl() {
      this.index = -1;
      this.builder = new HubSourceStatusBuilder(this);
    }
    HubSourceStatusBuilder builder;
    Integer index;
    public N and() {
      return (N) OperatorHubStatusFluentImpl.this.setToSources(index,builder.build());
    }
    public N endSource() {
      return and();
    }
    
  }
  
}