package io.fabric8.openshift.api.model.config.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class OpenIDIdentityProviderFluentImpl<A extends OpenIDIdentityProviderFluent<A>> extends BaseFluent<A> implements OpenIDIdentityProviderFluent<A>{
  public OpenIDIdentityProviderFluentImpl() {
  }
  public OpenIDIdentityProviderFluentImpl(OpenIDIdentityProvider instance) {
    this.withCa(instance.getCa()); 
    this.withClaims(instance.getClaims()); 
    this.withClientID(instance.getClientID()); 
    this.withClientSecret(instance.getClientSecret()); 
    this.withExtraAuthorizeParameters(instance.getExtraAuthorizeParameters()); 
    this.withExtraScopes(instance.getExtraScopes()); 
    this.withIssuer(instance.getIssuer()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private ConfigMapNameReferenceBuilder ca;
  private OpenIDClaimsBuilder claims;
  private String clientID;
  private SecretNameReferenceBuilder clientSecret;
  private Map<String,String> extraAuthorizeParameters;
  private List<String> extraScopes = new ArrayList<String>();
  private String issuer;
  private Map<String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildCa instead.
   * @return The buildable object.
   */
  @Deprecated
  public ConfigMapNameReference getCa() {
    return this.ca!=null ?this.ca.build():null;
  }
  public ConfigMapNameReference buildCa() {
    return this.ca!=null ?this.ca.build():null;
  }
  public A withCa(ConfigMapNameReference ca) {
    _visitables.get("ca").remove(this.ca);
    if (ca!=null){ this.ca= new ConfigMapNameReferenceBuilder(ca); _visitables.get("ca").add(this.ca);} else { this.ca = null; _visitables.get("ca").remove(this.ca); } return (A) this;
  }
  public Boolean hasCa() {
    return this.ca != null;
  }
  public A withNewCa(String name) {
    return (A)withCa(new ConfigMapNameReference(name));
  }
  public OpenIDIdentityProviderFluent.CaNested<A> withNewCa() {
    return new OpenIDIdentityProviderFluentImpl.CaNestedImpl();
  }
  public OpenIDIdentityProviderFluent.CaNested<A> withNewCaLike(ConfigMapNameReference item) {
    return new OpenIDIdentityProviderFluentImpl.CaNestedImpl(item);
  }
  public OpenIDIdentityProviderFluent.CaNested<A> editCa() {
    return withNewCaLike(getCa());
  }
  public OpenIDIdentityProviderFluent.CaNested<A> editOrNewCa() {
    return withNewCaLike(getCa() != null ? getCa(): new ConfigMapNameReferenceBuilder().build());
  }
  public OpenIDIdentityProviderFluent.CaNested<A> editOrNewCaLike(ConfigMapNameReference item) {
    return withNewCaLike(getCa() != null ? getCa(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildClaims instead.
   * @return The buildable object.
   */
  @Deprecated
  public OpenIDClaims getClaims() {
    return this.claims!=null ?this.claims.build():null;
  }
  public OpenIDClaims buildClaims() {
    return this.claims!=null ?this.claims.build():null;
  }
  public A withClaims(OpenIDClaims claims) {
    _visitables.get("claims").remove(this.claims);
    if (claims!=null){ this.claims= new OpenIDClaimsBuilder(claims); _visitables.get("claims").add(this.claims);} else { this.claims = null; _visitables.get("claims").remove(this.claims); } return (A) this;
  }
  public Boolean hasClaims() {
    return this.claims != null;
  }
  public OpenIDIdentityProviderFluent.ClaimsNested<A> withNewClaims() {
    return new OpenIDIdentityProviderFluentImpl.ClaimsNestedImpl();
  }
  public OpenIDIdentityProviderFluent.ClaimsNested<A> withNewClaimsLike(OpenIDClaims item) {
    return new OpenIDIdentityProviderFluentImpl.ClaimsNestedImpl(item);
  }
  public OpenIDIdentityProviderFluent.ClaimsNested<A> editClaims() {
    return withNewClaimsLike(getClaims());
  }
  public OpenIDIdentityProviderFluent.ClaimsNested<A> editOrNewClaims() {
    return withNewClaimsLike(getClaims() != null ? getClaims(): new OpenIDClaimsBuilder().build());
  }
  public OpenIDIdentityProviderFluent.ClaimsNested<A> editOrNewClaimsLike(OpenIDClaims item) {
    return withNewClaimsLike(getClaims() != null ? getClaims(): item);
  }
  public String getClientID() {
    return this.clientID;
  }
  public A withClientID(String clientID) {
    this.clientID=clientID; return (A) this;
  }
  public Boolean hasClientID() {
    return this.clientID != null;
  }
  
  /**
   * This method has been deprecated, please use method buildClientSecret instead.
   * @return The buildable object.
   */
  @Deprecated
  public SecretNameReference getClientSecret() {
    return this.clientSecret!=null ?this.clientSecret.build():null;
  }
  public SecretNameReference buildClientSecret() {
    return this.clientSecret!=null ?this.clientSecret.build():null;
  }
  public A withClientSecret(SecretNameReference clientSecret) {
    _visitables.get("clientSecret").remove(this.clientSecret);
    if (clientSecret!=null){ this.clientSecret= new SecretNameReferenceBuilder(clientSecret); _visitables.get("clientSecret").add(this.clientSecret);} else { this.clientSecret = null; _visitables.get("clientSecret").remove(this.clientSecret); } return (A) this;
  }
  public Boolean hasClientSecret() {
    return this.clientSecret != null;
  }
  public A withNewClientSecret(String name) {
    return (A)withClientSecret(new SecretNameReference(name));
  }
  public OpenIDIdentityProviderFluent.ClientSecretNested<A> withNewClientSecret() {
    return new OpenIDIdentityProviderFluentImpl.ClientSecretNestedImpl();
  }
  public OpenIDIdentityProviderFluent.ClientSecretNested<A> withNewClientSecretLike(SecretNameReference item) {
    return new OpenIDIdentityProviderFluentImpl.ClientSecretNestedImpl(item);
  }
  public OpenIDIdentityProviderFluent.ClientSecretNested<A> editClientSecret() {
    return withNewClientSecretLike(getClientSecret());
  }
  public OpenIDIdentityProviderFluent.ClientSecretNested<A> editOrNewClientSecret() {
    return withNewClientSecretLike(getClientSecret() != null ? getClientSecret(): new SecretNameReferenceBuilder().build());
  }
  public OpenIDIdentityProviderFluent.ClientSecretNested<A> editOrNewClientSecretLike(SecretNameReference item) {
    return withNewClientSecretLike(getClientSecret() != null ? getClientSecret(): item);
  }
  public A addToExtraAuthorizeParameters(String key,String value) {
    if(this.extraAuthorizeParameters == null && key != null && value != null) { this.extraAuthorizeParameters = new LinkedHashMap(); }
    if(key != null && value != null) {this.extraAuthorizeParameters.put(key, value);} return (A)this;
  }
  public A addToExtraAuthorizeParameters(Map<String,String> map) {
    if(this.extraAuthorizeParameters == null && map != null) { this.extraAuthorizeParameters = new LinkedHashMap(); }
    if(map != null) { this.extraAuthorizeParameters.putAll(map);} return (A)this;
  }
  public A removeFromExtraAuthorizeParameters(String key) {
    if(this.extraAuthorizeParameters == null) { return (A) this; }
    if(key != null && this.extraAuthorizeParameters != null) {this.extraAuthorizeParameters.remove(key);} return (A)this;
  }
  public A removeFromExtraAuthorizeParameters(Map<String,String> map) {
    if(this.extraAuthorizeParameters == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.extraAuthorizeParameters != null){this.extraAuthorizeParameters.remove(key);}}} return (A)this;
  }
  public Map<String,String> getExtraAuthorizeParameters() {
    return this.extraAuthorizeParameters;
  }
  public <K,V>A withExtraAuthorizeParameters(Map<String,String> extraAuthorizeParameters) {
    if (extraAuthorizeParameters == null) { this.extraAuthorizeParameters =  null;} else {this.extraAuthorizeParameters = new LinkedHashMap(extraAuthorizeParameters);} return (A) this;
  }
  public Boolean hasExtraAuthorizeParameters() {
    return this.extraAuthorizeParameters != null;
  }
  public A addToExtraScopes(Integer index,String item) {
    if (this.extraScopes == null) {this.extraScopes = new ArrayList<String>();}
    this.extraScopes.add(index, item);
    return (A)this;
  }
  public A setToExtraScopes(Integer index,String item) {
    if (this.extraScopes == null) {this.extraScopes = new ArrayList<String>();}
    this.extraScopes.set(index, item); return (A)this;
  }
  public A addToExtraScopes(java.lang.String... items) {
    if (this.extraScopes == null) {this.extraScopes = new ArrayList<String>();}
    for (String item : items) {this.extraScopes.add(item);} return (A)this;
  }
  public A addAllToExtraScopes(Collection<String> items) {
    if (this.extraScopes == null) {this.extraScopes = new ArrayList<String>();}
    for (String item : items) {this.extraScopes.add(item);} return (A)this;
  }
  public A removeFromExtraScopes(java.lang.String... items) {
    for (String item : items) {if (this.extraScopes!= null){ this.extraScopes.remove(item);}} return (A)this;
  }
  public A removeAllFromExtraScopes(Collection<String> items) {
    for (String item : items) {if (this.extraScopes!= null){ this.extraScopes.remove(item);}} return (A)this;
  }
  public List<String> getExtraScopes() {
    return this.extraScopes;
  }
  public String getExtraScope(Integer index) {
    return this.extraScopes.get(index);
  }
  public String getFirstExtraScope() {
    return this.extraScopes.get(0);
  }
  public String getLastExtraScope() {
    return this.extraScopes.get(extraScopes.size() - 1);
  }
  public String getMatchingExtraScope(Predicate<String> predicate) {
    for (String item: extraScopes) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingExtraScope(Predicate<String> predicate) {
    for (String item: extraScopes) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withExtraScopes(List<String> extraScopes) {
    if (extraScopes != null) {this.extraScopes = new ArrayList(); for (String item : extraScopes){this.addToExtraScopes(item);}} else { this.extraScopes = null;} return (A) this;
  }
  public A withExtraScopes(java.lang.String... extraScopes) {
    if (this.extraScopes != null) {this.extraScopes.clear();}
    if (extraScopes != null) {for (String item :extraScopes){ this.addToExtraScopes(item);}} return (A) this;
  }
  public Boolean hasExtraScopes() {
    return extraScopes != null && !extraScopes.isEmpty();
  }
  public String getIssuer() {
    return this.issuer;
  }
  public A withIssuer(String issuer) {
    this.issuer=issuer; return (A) this;
  }
  public Boolean hasIssuer() {
    return this.issuer != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    OpenIDIdentityProviderFluentImpl that = (OpenIDIdentityProviderFluentImpl) o;
    if (ca != null ? !ca.equals(that.ca) :that.ca != null) return false;
    if (claims != null ? !claims.equals(that.claims) :that.claims != null) return false;
    if (clientID != null ? !clientID.equals(that.clientID) :that.clientID != null) return false;
    if (clientSecret != null ? !clientSecret.equals(that.clientSecret) :that.clientSecret != null) return false;
    if (extraAuthorizeParameters != null ? !extraAuthorizeParameters.equals(that.extraAuthorizeParameters) :that.extraAuthorizeParameters != null) return false;
    if (extraScopes != null ? !extraScopes.equals(that.extraScopes) :that.extraScopes != null) return false;
    if (issuer != null ? !issuer.equals(that.issuer) :that.issuer != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(ca,  claims,  clientID,  clientSecret,  extraAuthorizeParameters,  extraScopes,  issuer,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (ca != null) { sb.append("ca:"); sb.append(ca + ","); }
    if (claims != null) { sb.append("claims:"); sb.append(claims + ","); }
    if (clientID != null) { sb.append("clientID:"); sb.append(clientID + ","); }
    if (clientSecret != null) { sb.append("clientSecret:"); sb.append(clientSecret + ","); }
    if (extraAuthorizeParameters != null && !extraAuthorizeParameters.isEmpty()) { sb.append("extraAuthorizeParameters:"); sb.append(extraAuthorizeParameters + ","); }
    if (extraScopes != null && !extraScopes.isEmpty()) { sb.append("extraScopes:"); sb.append(extraScopes + ","); }
    if (issuer != null) { sb.append("issuer:"); sb.append(issuer + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class CaNestedImpl<N> extends ConfigMapNameReferenceFluentImpl<OpenIDIdentityProviderFluent.CaNested<N>> implements OpenIDIdentityProviderFluent.CaNested<N>,Nested<N>{
    CaNestedImpl(ConfigMapNameReference item) {
      this.builder = new ConfigMapNameReferenceBuilder(this, item);
    }
    CaNestedImpl() {
      this.builder = new ConfigMapNameReferenceBuilder(this);
    }
    ConfigMapNameReferenceBuilder builder;
    public N and() {
      return (N) OpenIDIdentityProviderFluentImpl.this.withCa(builder.build());
    }
    public N endCa() {
      return and();
    }
    
  }
  class ClaimsNestedImpl<N> extends OpenIDClaimsFluentImpl<OpenIDIdentityProviderFluent.ClaimsNested<N>> implements OpenIDIdentityProviderFluent.ClaimsNested<N>,Nested<N>{
    ClaimsNestedImpl(OpenIDClaims item) {
      this.builder = new OpenIDClaimsBuilder(this, item);
    }
    ClaimsNestedImpl() {
      this.builder = new OpenIDClaimsBuilder(this);
    }
    OpenIDClaimsBuilder builder;
    public N and() {
      return (N) OpenIDIdentityProviderFluentImpl.this.withClaims(builder.build());
    }
    public N endClaims() {
      return and();
    }
    
  }
  class ClientSecretNestedImpl<N> extends SecretNameReferenceFluentImpl<OpenIDIdentityProviderFluent.ClientSecretNested<N>> implements OpenIDIdentityProviderFluent.ClientSecretNested<N>,Nested<N>{
    ClientSecretNestedImpl(SecretNameReference item) {
      this.builder = new SecretNameReferenceBuilder(this, item);
    }
    ClientSecretNestedImpl() {
      this.builder = new SecretNameReferenceBuilder(this);
    }
    SecretNameReferenceBuilder builder;
    public N and() {
      return (N) OpenIDIdentityProviderFluentImpl.this.withClientSecret(builder.build());
    }
    public N endClientSecret() {
      return and();
    }
    
  }
  
}