package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class OAuthTemplatesBuilder extends OAuthTemplatesFluentImpl<OAuthTemplatesBuilder> implements VisitableBuilder<OAuthTemplates,OAuthTemplatesBuilder>{
  public OAuthTemplatesBuilder() {
    this(false);
  }
  public OAuthTemplatesBuilder(Boolean validationEnabled) {
    this(new OAuthTemplates(), validationEnabled);
  }
  public OAuthTemplatesBuilder(OAuthTemplatesFluent<?> fluent) {
    this(fluent, false);
  }
  public OAuthTemplatesBuilder(OAuthTemplatesFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new OAuthTemplates(), validationEnabled);
  }
  public OAuthTemplatesBuilder(OAuthTemplatesFluent<?> fluent,OAuthTemplates instance) {
    this(fluent, instance, false);
  }
  public OAuthTemplatesBuilder(OAuthTemplatesFluent<?> fluent,OAuthTemplates instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withError(instance.getError()); 
    fluent.withLogin(instance.getLogin()); 
    fluent.withProviderSelection(instance.getProviderSelection()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public OAuthTemplatesBuilder(OAuthTemplates instance) {
    this(instance,false);
  }
  public OAuthTemplatesBuilder(OAuthTemplates instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withError(instance.getError()); 
    this.withLogin(instance.getLogin()); 
    this.withProviderSelection(instance.getProviderSelection()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  OAuthTemplatesFluent<?> fluent;
  Boolean validationEnabled;
  public OAuthTemplates build() {
    OAuthTemplates buildable = new OAuthTemplates(fluent.getError(),fluent.getLogin(),fluent.getProviderSelection());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}