package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class OAuthBuilder extends OAuthFluentImpl<OAuthBuilder> implements VisitableBuilder<OAuth,OAuthBuilder>{
  public OAuthBuilder() {
    this(false);
  }
  public OAuthBuilder(Boolean validationEnabled) {
    this(new OAuth(), validationEnabled);
  }
  public OAuthBuilder(OAuthFluent<?> fluent) {
    this(fluent, false);
  }
  public OAuthBuilder(OAuthFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new OAuth(), validationEnabled);
  }
  public OAuthBuilder(OAuthFluent<?> fluent,OAuth instance) {
    this(fluent, instance, false);
  }
  public OAuthBuilder(OAuthFluent<?> fluent,OAuth instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public OAuthBuilder(OAuth instance) {
    this(instance,false);
  }
  public OAuthBuilder(OAuth instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  OAuthFluent<?> fluent;
  Boolean validationEnabled;
  public OAuth build() {
    OAuth buildable = new OAuth(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}