package io.fabric8.openshift.api.model.config.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class InfrastructureSpecFluentImpl<A extends InfrastructureSpecFluent<A>> extends BaseFluent<A> implements InfrastructureSpecFluent<A>{
  public InfrastructureSpecFluentImpl() {
  }
  public InfrastructureSpecFluentImpl(InfrastructureSpec instance) {
    this.withCloudConfig(instance.getCloudConfig()); 
    this.withPlatformSpec(instance.getPlatformSpec()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private ConfigMapFileReferenceBuilder cloudConfig;
  private PlatformSpecBuilder platformSpec;
  private Map<String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildCloudConfig instead.
   * @return The buildable object.
   */
  @Deprecated
  public ConfigMapFileReference getCloudConfig() {
    return this.cloudConfig!=null ?this.cloudConfig.build():null;
  }
  public ConfigMapFileReference buildCloudConfig() {
    return this.cloudConfig!=null ?this.cloudConfig.build():null;
  }
  public A withCloudConfig(ConfigMapFileReference cloudConfig) {
    _visitables.get("cloudConfig").remove(this.cloudConfig);
    if (cloudConfig!=null){ this.cloudConfig= new ConfigMapFileReferenceBuilder(cloudConfig); _visitables.get("cloudConfig").add(this.cloudConfig);} else { this.cloudConfig = null; _visitables.get("cloudConfig").remove(this.cloudConfig); } return (A) this;
  }
  public Boolean hasCloudConfig() {
    return this.cloudConfig != null;
  }
  public A withNewCloudConfig(String key,String name) {
    return (A)withCloudConfig(new ConfigMapFileReference(key, name));
  }
  public InfrastructureSpecFluent.CloudConfigNested<A> withNewCloudConfig() {
    return new InfrastructureSpecFluentImpl.CloudConfigNestedImpl();
  }
  public InfrastructureSpecFluent.CloudConfigNested<A> withNewCloudConfigLike(ConfigMapFileReference item) {
    return new InfrastructureSpecFluentImpl.CloudConfigNestedImpl(item);
  }
  public InfrastructureSpecFluent.CloudConfigNested<A> editCloudConfig() {
    return withNewCloudConfigLike(getCloudConfig());
  }
  public InfrastructureSpecFluent.CloudConfigNested<A> editOrNewCloudConfig() {
    return withNewCloudConfigLike(getCloudConfig() != null ? getCloudConfig(): new ConfigMapFileReferenceBuilder().build());
  }
  public InfrastructureSpecFluent.CloudConfigNested<A> editOrNewCloudConfigLike(ConfigMapFileReference item) {
    return withNewCloudConfigLike(getCloudConfig() != null ? getCloudConfig(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildPlatformSpec instead.
   * @return The buildable object.
   */
  @Deprecated
  public PlatformSpec getPlatformSpec() {
    return this.platformSpec!=null ?this.platformSpec.build():null;
  }
  public PlatformSpec buildPlatformSpec() {
    return this.platformSpec!=null ?this.platformSpec.build():null;
  }
  public A withPlatformSpec(PlatformSpec platformSpec) {
    _visitables.get("platformSpec").remove(this.platformSpec);
    if (platformSpec!=null){ this.platformSpec= new PlatformSpecBuilder(platformSpec); _visitables.get("platformSpec").add(this.platformSpec);} else { this.platformSpec = null; _visitables.get("platformSpec").remove(this.platformSpec); } return (A) this;
  }
  public Boolean hasPlatformSpec() {
    return this.platformSpec != null;
  }
  public InfrastructureSpecFluent.PlatformSpecNested<A> withNewPlatformSpec() {
    return new InfrastructureSpecFluentImpl.PlatformSpecNestedImpl();
  }
  public InfrastructureSpecFluent.PlatformSpecNested<A> withNewPlatformSpecLike(PlatformSpec item) {
    return new InfrastructureSpecFluentImpl.PlatformSpecNestedImpl(item);
  }
  public InfrastructureSpecFluent.PlatformSpecNested<A> editPlatformSpec() {
    return withNewPlatformSpecLike(getPlatformSpec());
  }
  public InfrastructureSpecFluent.PlatformSpecNested<A> editOrNewPlatformSpec() {
    return withNewPlatformSpecLike(getPlatformSpec() != null ? getPlatformSpec(): new PlatformSpecBuilder().build());
  }
  public InfrastructureSpecFluent.PlatformSpecNested<A> editOrNewPlatformSpecLike(PlatformSpec item) {
    return withNewPlatformSpecLike(getPlatformSpec() != null ? getPlatformSpec(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    InfrastructureSpecFluentImpl that = (InfrastructureSpecFluentImpl) o;
    if (cloudConfig != null ? !cloudConfig.equals(that.cloudConfig) :that.cloudConfig != null) return false;
    if (platformSpec != null ? !platformSpec.equals(that.platformSpec) :that.platformSpec != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(cloudConfig,  platformSpec,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (cloudConfig != null) { sb.append("cloudConfig:"); sb.append(cloudConfig + ","); }
    if (platformSpec != null) { sb.append("platformSpec:"); sb.append(platformSpec + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class CloudConfigNestedImpl<N> extends ConfigMapFileReferenceFluentImpl<InfrastructureSpecFluent.CloudConfigNested<N>> implements InfrastructureSpecFluent.CloudConfigNested<N>,Nested<N>{
    CloudConfigNestedImpl(ConfigMapFileReference item) {
      this.builder = new ConfigMapFileReferenceBuilder(this, item);
    }
    CloudConfigNestedImpl() {
      this.builder = new ConfigMapFileReferenceBuilder(this);
    }
    ConfigMapFileReferenceBuilder builder;
    public N and() {
      return (N) InfrastructureSpecFluentImpl.this.withCloudConfig(builder.build());
    }
    public N endCloudConfig() {
      return and();
    }
    
  }
  class PlatformSpecNestedImpl<N> extends PlatformSpecFluentImpl<InfrastructureSpecFluent.PlatformSpecNested<N>> implements InfrastructureSpecFluent.PlatformSpecNested<N>,Nested<N>{
    PlatformSpecNestedImpl(PlatformSpec item) {
      this.builder = new PlatformSpecBuilder(this, item);
    }
    PlatformSpecNestedImpl() {
      this.builder = new PlatformSpecBuilder(this);
    }
    PlatformSpecBuilder builder;
    public N and() {
      return (N) InfrastructureSpecFluentImpl.this.withPlatformSpec(builder.build());
    }
    public N endPlatformSpec() {
      return and();
    }
    
  }
  
}