package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CustomFeatureGatesBuilder extends CustomFeatureGatesFluentImpl<CustomFeatureGatesBuilder> implements VisitableBuilder<CustomFeatureGates,CustomFeatureGatesBuilder>{
  public CustomFeatureGatesBuilder() {
    this(false);
  }
  public CustomFeatureGatesBuilder(Boolean validationEnabled) {
    this(new CustomFeatureGates(), validationEnabled);
  }
  public CustomFeatureGatesBuilder(CustomFeatureGatesFluent<?> fluent) {
    this(fluent, false);
  }
  public CustomFeatureGatesBuilder(CustomFeatureGatesFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CustomFeatureGates(), validationEnabled);
  }
  public CustomFeatureGatesBuilder(CustomFeatureGatesFluent<?> fluent,CustomFeatureGates instance) {
    this(fluent, instance, false);
  }
  public CustomFeatureGatesBuilder(CustomFeatureGatesFluent<?> fluent,CustomFeatureGates instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withDisabled(instance.getDisabled()); 
    fluent.withEnabled(instance.getEnabled()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public CustomFeatureGatesBuilder(CustomFeatureGates instance) {
    this(instance,false);
  }
  public CustomFeatureGatesBuilder(CustomFeatureGates instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withDisabled(instance.getDisabled()); 
    this.withEnabled(instance.getEnabled()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  CustomFeatureGatesFluent<?> fluent;
  Boolean validationEnabled;
  public CustomFeatureGates build() {
    CustomFeatureGates buildable = new CustomFeatureGates(fluent.getDisabled(),fluent.getEnabled());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}