package io.fabric8.openshift.api.model.clusterautoscaling.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ScaleDownConfigBuilder extends ScaleDownConfigFluent<ScaleDownConfigBuilder> implements VisitableBuilder<ScaleDownConfig,ScaleDownConfigBuilder>{
  public ScaleDownConfigBuilder() {
    this(new ScaleDownConfig());
  }
  
  public ScaleDownConfigBuilder(ScaleDownConfigFluent<?> fluent) {
    this(fluent, new ScaleDownConfig());
  }
  
  public ScaleDownConfigBuilder(ScaleDownConfigFluent<?> fluent,ScaleDownConfig instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ScaleDownConfigBuilder(ScaleDownConfig instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ScaleDownConfigFluent<?> fluent;
  
  public ScaleDownConfig build() {
    ScaleDownConfig buildable = new ScaleDownConfig(fluent.getDelayAfterAdd(),fluent.getDelayAfterDelete(),fluent.getDelayAfterFailure(),fluent.getEnabled(),fluent.getUnneededTime(),fluent.getUtilizationThreshold());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}