/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client;

import io.fabric8.kubernetes.client.Client;
import io.fabric8.kubernetes.client.ExtensionAdapter;
import io.fabric8.openshift.api.model.Build;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.ClusterRoleBinding;
import io.fabric8.openshift.api.model.DNS;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.Group;
import io.fabric8.openshift.api.model.OAuthAccessToken;
import io.fabric8.openshift.api.model.OAuthAuthorizeToken;
import io.fabric8.openshift.api.model.OAuthClient;
import io.fabric8.openshift.api.model.Project;
import io.fabric8.openshift.api.model.Role;
import io.fabric8.openshift.api.model.RoleBinding;
import io.fabric8.openshift.api.model.SecurityContextConstraints;
import io.fabric8.openshift.api.model.Template;
import io.fabric8.openshift.api.model.User;
import io.fabric8.openshift.api.model.miscellaneous.cncf.cni.v1.NetworkAttachmentDefinition;
import io.fabric8.openshift.client.DefaultOpenShiftClient;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.OpenShiftHandlers;
import io.fabric8.openshift.client.OpenShiftNotAvailableException;
import io.fabric8.openshift.client.OpenshiftAdapterSupport;
import io.fabric8.openshift.client.dsl.internal.apps.DeploymentConfigOperationsImpl;
import io.fabric8.openshift.client.dsl.internal.authorization.ClusterRoleBindingOperationsImpl;
import io.fabric8.openshift.client.dsl.internal.authorization.RoleBindingOperationsImpl;
import io.fabric8.openshift.client.dsl.internal.authorization.RoleOperationsImpl;
import io.fabric8.openshift.client.dsl.internal.build.BuildConfigOperationsImpl;
import io.fabric8.openshift.client.dsl.internal.build.BuildOperationsImpl;
import io.fabric8.openshift.client.dsl.internal.config.DNSOperationsImpl;
import io.fabric8.openshift.client.dsl.internal.core.NetworkAttachmentDefinitionOperationsImpl;
import io.fabric8.openshift.client.dsl.internal.core.TemplateOperationsImpl;
import io.fabric8.openshift.client.dsl.internal.oauth.OAuthAccessTokenOperationsImpl;
import io.fabric8.openshift.client.dsl.internal.oauth.OAuthAuthorizeTokenOperationsImpl;
import io.fabric8.openshift.client.dsl.internal.oauth.OAuthClientOperationsImpl;
import io.fabric8.openshift.client.dsl.internal.project.ProjectOperationsImpl;
import io.fabric8.openshift.client.dsl.internal.security.SecurityContextConstraintsOperationsImpl;
import io.fabric8.openshift.client.dsl.internal.user.GroupOperationsImpl;
import io.fabric8.openshift.client.dsl.internal.user.UserOperationsImpl;
import okhttp3.OkHttpClient;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;

@Component
@Service
public class OpenShiftExtensionAdapter
extends OpenshiftAdapterSupport
implements ExtensionAdapter<OpenShiftClient> {
    public Class<OpenShiftClient> getExtensionType() {
        return OpenShiftClient.class;
    }

    public OpenShiftClient adapt(Client client) {
        if (!this.isAdaptable(client).booleanValue()) {
            throw new OpenShiftNotAvailableException("OpenShift is not available. Root paths at: " + client.getMasterUrl() + " do not include oapi.");
        }
        return new DefaultOpenShiftClient((OkHttpClient)client.adapt(OkHttpClient.class), OpenShiftConfig.wrap(client.getConfiguration()));
    }

    static {
        OpenShiftHandlers.register(BuildConfig.class, BuildConfigOperationsImpl::new);
        OpenShiftHandlers.register(Build.class, BuildOperationsImpl::new);
        OpenShiftHandlers.register(ClusterRoleBinding.class, ClusterRoleBindingOperationsImpl::new);
        OpenShiftHandlers.register(DeploymentConfig.class, DeploymentConfigOperationsImpl::new);
        OpenShiftHandlers.register(DNS.class, DNSOperationsImpl::new);
        OpenShiftHandlers.register(Group.class, GroupOperationsImpl::new);
        OpenShiftHandlers.register(NetworkAttachmentDefinition.class, NetworkAttachmentDefinitionOperationsImpl::new);
        OpenShiftHandlers.register(OAuthAccessToken.class, OAuthAccessTokenOperationsImpl::new);
        OpenShiftHandlers.register(OAuthAuthorizeToken.class, OAuthAuthorizeTokenOperationsImpl::new);
        OpenShiftHandlers.register(OAuthClient.class, OAuthClientOperationsImpl::new);
        OpenShiftHandlers.register(RoleBinding.class, RoleBindingOperationsImpl::new);
        OpenShiftHandlers.register(Role.class, RoleOperationsImpl::new);
        OpenShiftHandlers.register(SecurityContextConstraints.class, SecurityContextConstraintsOperationsImpl::new);
        OpenShiftHandlers.register(Template.class, TemplateOperationsImpl::new);
        OpenShiftHandlers.register(User.class, UserOperationsImpl::new);
        OpenShiftHandlers.register(Project.class, ProjectOperationsImpl::new);
    }
}

