/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.handlers.network;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.Deletable;
import io.fabric8.kubernetes.client.dsl.EditReplacePatchDeletable;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.WritableOperation;
import io.fabric8.openshift.api.model.HostSubnet;
import io.fabric8.openshift.api.model.HostSubnetBuilder;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.dsl.internal.network.HostSubnetOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class HostSubnetHandler
implements ResourceHandler<HostSubnet, HostSubnetBuilder> {
    public String getKind() {
        return HostSubnet.class.getSimpleName();
    }

    public String getApiVersion() {
        return "network.openshift.io/v1";
    }

    public HostSubnet create(OkHttpClient client, Config config, String namespace, HostSubnet item, boolean dryRun) {
        return (HostSubnet)((WritableOperation)new HostSubnetOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).dryRun(dryRun)).create((Object[])new HostSubnet[0]);
    }

    public HostSubnet replace(OkHttpClient client, Config config, String namespace, HostSubnet item, boolean dryRun) {
        return (HostSubnet)((WritableOperation)((Resource)new HostSubnetOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).dryRun(dryRun)).replace((Object)item);
    }

    public HostSubnet reload(OkHttpClient client, Config config, String namespace, HostSubnet item) {
        return (HostSubnet)((Gettable)((Resource)new HostSubnetOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    public HostSubnetBuilder edit(HostSubnet item) {
        return new HostSubnetBuilder(item);
    }

    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, HostSubnet item, boolean dryRun) {
        return ((Deletable)((EditReplacePatchDeletable)new HostSubnetOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).dryRun(dryRun).withPropagationPolicy(propagationPolicy)).withGracePeriod(gracePeriodSeconds)).delete();
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, HostSubnet item, Watcher<HostSubnet> watcher) {
        return ((Resource)new HostSubnetOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, HostSubnet item, String resourceVersion, Watcher<HostSubnet> watcher) {
        return ((Resource)new HostSubnetOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, HostSubnet item, ListOptions options, Watcher<HostSubnet> watcher) {
        return ((Resource)new HostSubnetOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(options, watcher);
    }

    public HostSubnet waitUntilReady(OkHttpClient client, Config config, String namespace, HostSubnet item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (HostSubnet)((Resource)new HostSubnetOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    public HostSubnet waitUntilCondition(OkHttpClient client, Config config, String namespace, HostSubnet item, Predicate<HostSubnet> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (HostSubnet)((Resource)new HostSubnetOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

