/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.handlers.machineconfiguration;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.Deletable;
import io.fabric8.kubernetes.client.dsl.EditReplacePatchDeletable;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.WritableOperation;
import io.fabric8.openshift.api.model.machineconfig.v1.MachineConfigPool;
import io.fabric8.openshift.api.model.machineconfig.v1.MachineConfigPoolBuilder;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.dsl.internal.machineconfiguration.MachineConfigPoolOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class MachineConfigPoolHandler
implements ResourceHandler<MachineConfigPool, MachineConfigPoolBuilder> {
    public String getKind() {
        return MachineConfigPool.class.getSimpleName();
    }

    public String getApiVersion() {
        return "machineconfiguration.openshift.io/v1";
    }

    public MachineConfigPool create(OkHttpClient client, Config config, String namespace, MachineConfigPool item, boolean dryRun) {
        return (MachineConfigPool)((WritableOperation)new MachineConfigPoolOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).dryRun(dryRun)).create((Object[])new MachineConfigPool[0]);
    }

    public MachineConfigPool replace(OkHttpClient client, Config config, String namespace, MachineConfigPool item, boolean dryRun) {
        return (MachineConfigPool)((WritableOperation)((Resource)new MachineConfigPoolOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).dryRun(dryRun)).replace((Object)item);
    }

    public MachineConfigPool reload(OkHttpClient client, Config config, String namespace, MachineConfigPool item) {
        return (MachineConfigPool)((Gettable)((Resource)new MachineConfigPoolOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    public MachineConfigPoolBuilder edit(MachineConfigPool item) {
        return new MachineConfigPoolBuilder(item);
    }

    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, MachineConfigPool item, boolean dryRun) {
        return ((Deletable)((EditReplacePatchDeletable)new MachineConfigPoolOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).dryRun(dryRun).withPropagationPolicy(propagationPolicy)).withGracePeriod(gracePeriodSeconds)).delete();
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, MachineConfigPool item, Watcher<MachineConfigPool> watcher) {
        return ((Resource)new MachineConfigPoolOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, MachineConfigPool item, String resourceVersion, Watcher<MachineConfigPool> watcher) {
        return ((Resource)new MachineConfigPoolOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, MachineConfigPool item, ListOptions options, Watcher<MachineConfigPool> watcher) {
        return ((Resource)new MachineConfigPoolOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(options, watcher);
    }

    public MachineConfigPool waitUntilReady(OkHttpClient client, Config config, String namespace, MachineConfigPool item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (MachineConfigPool)((Resource)new MachineConfigPoolOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    public MachineConfigPool waitUntilCondition(OkHttpClient client, Config config, String namespace, MachineConfigPool item, Predicate<MachineConfigPool> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (MachineConfigPool)((Resource)new MachineConfigPoolOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

