/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.handlers.machineconfiguration;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.Deletable;
import io.fabric8.kubernetes.client.dsl.EditReplacePatchDeletable;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.WritableOperation;
import io.fabric8.openshift.api.model.machineconfig.v1.MachineConfig;
import io.fabric8.openshift.api.model.machineconfig.v1.MachineConfigBuilder;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.dsl.internal.machineconfiguration.MachineConfigOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class MachineConfigHandler
implements ResourceHandler<MachineConfig, MachineConfigBuilder> {
    public String getKind() {
        return MachineConfig.class.getSimpleName();
    }

    public String getApiVersion() {
        return "machineconfiguration.openshift.io/v1";
    }

    public MachineConfig create(OkHttpClient client, Config config, String namespace, MachineConfig item, boolean dryRun) {
        return (MachineConfig)((WritableOperation)new MachineConfigOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).dryRun(dryRun)).create((Object[])new MachineConfig[0]);
    }

    public MachineConfig replace(OkHttpClient client, Config config, String namespace, MachineConfig item, boolean dryRun) {
        return (MachineConfig)((WritableOperation)((Resource)new MachineConfigOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).dryRun(dryRun)).replace((Object)item);
    }

    public MachineConfig reload(OkHttpClient client, Config config, String namespace, MachineConfig item) {
        return (MachineConfig)((Gettable)((Resource)new MachineConfigOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    public MachineConfigBuilder edit(MachineConfig item) {
        return new MachineConfigBuilder(item);
    }

    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, MachineConfig item, boolean dryRun) {
        return ((Deletable)((EditReplacePatchDeletable)new MachineConfigOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).dryRun(dryRun).withPropagationPolicy(propagationPolicy)).withGracePeriod(gracePeriodSeconds)).delete();
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, MachineConfig item, Watcher<MachineConfig> watcher) {
        return ((Resource)new MachineConfigOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, MachineConfig item, String resourceVersion, Watcher<MachineConfig> watcher) {
        return ((Resource)new MachineConfigOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, MachineConfig item, ListOptions options, Watcher<MachineConfig> watcher) {
        return ((Resource)new MachineConfigOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(options, watcher);
    }

    public MachineConfig waitUntilReady(OkHttpClient client, Config config, String namespace, MachineConfig item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (MachineConfig)((Resource)new MachineConfigOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    public MachineConfig waitUntilCondition(OkHttpClient client, Config config, String namespace, MachineConfig item, Predicate<MachineConfig> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (MachineConfig)((Resource)new MachineConfigOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

