/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.handlers;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.Deletable;
import io.fabric8.kubernetes.client.dsl.EditReplacePatchDeletable;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.WritableOperation;
import io.fabric8.openshift.api.model.Proxy;
import io.fabric8.openshift.api.model.ProxyBuilder;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.dsl.internal.ProxyOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class ProxyHandler
implements ResourceHandler<Proxy, ProxyBuilder> {
    public String getKind() {
        return Proxy.class.getSimpleName();
    }

    public String getApiVersion() {
        return "config.openshift.io/v1";
    }

    public Proxy create(OkHttpClient client, Config config, String namespace, Proxy item, boolean dryRun) {
        return (Proxy)((WritableOperation)new ProxyOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).dryRun(dryRun)).create((Object[])new Proxy[0]);
    }

    public Proxy replace(OkHttpClient client, Config config, String namespace, Proxy item, boolean dryRun) {
        return (Proxy)((WritableOperation)((Resource)new ProxyOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).dryRun(dryRun)).replace((Object)item);
    }

    public Proxy reload(OkHttpClient client, Config config, String namespace, Proxy item) {
        return (Proxy)((Gettable)((Resource)new ProxyOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    public ProxyBuilder edit(Proxy item) {
        return new ProxyBuilder(item);
    }

    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, Proxy item, boolean dryRun) {
        return ((Deletable)((EditReplacePatchDeletable)new ProxyOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).dryRun(dryRun).withPropagationPolicy(propagationPolicy)).withGracePeriod(gracePeriodSeconds)).delete();
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, Proxy item, Watcher<Proxy> watcher) {
        return ((Resource)new ProxyOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, Proxy item, String resourceVersion, Watcher<Proxy> watcher) {
        return ((Resource)new ProxyOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, Proxy item, ListOptions options, Watcher<Proxy> watcher) {
        return ((Resource)new ProxyOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(options, watcher);
    }

    public Proxy waitUntilReady(OkHttpClient client, Config config, String namespace, Proxy item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Proxy)((Resource)new ProxyOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    public Proxy waitUntilCondition(OkHttpClient client, Config config, String namespace, Proxy item, Predicate<Proxy> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Proxy)((Resource)new ProxyOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

