/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.handlers;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.Deletable;
import io.fabric8.kubernetes.client.dsl.EditReplacePatchDeletable;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.WritableOperation;
import io.fabric8.openshift.api.model.OAuthAccessToken;
import io.fabric8.openshift.api.model.OAuthAccessTokenBuilder;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.dsl.internal.OAuthAccessTokenOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class OAuthAccessTokenHandler
implements ResourceHandler<OAuthAccessToken, OAuthAccessTokenBuilder> {
    public String getKind() {
        return OAuthAccessToken.class.getSimpleName();
    }

    public String getApiVersion() {
        return "oauth.openshift.io/v1";
    }

    public OAuthAccessToken create(OkHttpClient client, Config config, String namespace, OAuthAccessToken item, boolean dryRun) {
        return (OAuthAccessToken)((WritableOperation)new OAuthAccessTokenOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).dryRun(dryRun)).create((Object[])new OAuthAccessToken[0]);
    }

    public OAuthAccessToken replace(OkHttpClient client, Config config, String namespace, OAuthAccessToken item, boolean dryRun) {
        return (OAuthAccessToken)((WritableOperation)((Resource)new OAuthAccessTokenOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).dryRun(dryRun)).replace((Object)item);
    }

    public OAuthAccessToken reload(OkHttpClient client, Config config, String namespace, OAuthAccessToken item) {
        return (OAuthAccessToken)((Gettable)((Resource)new OAuthAccessTokenOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    public OAuthAccessTokenBuilder edit(OAuthAccessToken item) {
        return new OAuthAccessTokenBuilder(item);
    }

    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, OAuthAccessToken item, boolean dryRun) {
        return ((Deletable)((EditReplacePatchDeletable)new OAuthAccessTokenOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).dryRun(dryRun).withPropagationPolicy(propagationPolicy)).withGracePeriod(gracePeriodSeconds)).delete();
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, OAuthAccessToken item, Watcher<OAuthAccessToken> watcher) {
        return ((Resource)new OAuthAccessTokenOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, OAuthAccessToken item, String resourceVersion, Watcher<OAuthAccessToken> watcher) {
        return ((Resource)new OAuthAccessTokenOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, OAuthAccessToken item, ListOptions options, Watcher<OAuthAccessToken> watcher) {
        return ((Resource)new OAuthAccessTokenOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(options, watcher);
    }

    public OAuthAccessToken waitUntilReady(OkHttpClient client, Config config, String namespace, OAuthAccessToken item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (OAuthAccessToken)((Resource)new OAuthAccessTokenOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    public OAuthAccessToken waitUntilCondition(OkHttpClient client, Config config, String namespace, OAuthAccessToken item, Predicate<OAuthAccessToken> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (OAuthAccessToken)((Resource)new OAuthAccessTokenOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

