/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.handlers;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.ClusterServiceVersion;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.ClusterServiceVersionBuilder;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.dsl.internal.ClusterServiceVersionOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class ClusterServiceVersionHandler
implements ResourceHandler<ClusterServiceVersion, ClusterServiceVersionBuilder> {
    public String getKind() {
        return ClusterServiceVersion.class.getSimpleName();
    }

    public String getApiVersion() {
        return "operators.coreos.com/v1alpha1";
    }

    public ClusterServiceVersion create(OkHttpClient client, Config config, String namespace, ClusterServiceVersion item) {
        return (ClusterServiceVersion)new ClusterServiceVersionOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).create((Object[])new ClusterServiceVersion[0]);
    }

    public ClusterServiceVersion replace(OkHttpClient client, Config config, String namespace, ClusterServiceVersion item) {
        return (ClusterServiceVersion)((Resource)new ClusterServiceVersionOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).replace((Object)item);
    }

    public ClusterServiceVersion reload(OkHttpClient client, Config config, String namespace, ClusterServiceVersion item) {
        return (ClusterServiceVersion)((Gettable)((Resource)new ClusterServiceVersionOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    public ClusterServiceVersionBuilder edit(ClusterServiceVersion item) {
        return new ClusterServiceVersionBuilder(item);
    }

    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, ClusterServiceVersion item) {
        return new ClusterServiceVersionOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).withPropagationPolicy(propagationPolicy).delete();
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, ClusterServiceVersion item, Watcher<ClusterServiceVersion> watcher) {
        return ((Resource)new ClusterServiceVersionOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, ClusterServiceVersion item, String resourceVersion, Watcher<ClusterServiceVersion> watcher) {
        return ((Resource)new ClusterServiceVersionOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, ClusterServiceVersion item, ListOptions options, Watcher<ClusterServiceVersion> watcher) {
        return ((Resource)new ClusterServiceVersionOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(options, watcher);
    }

    public ClusterServiceVersion waitUntilReady(OkHttpClient client, Config config, String namespace, ClusterServiceVersion item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (ClusterServiceVersion)((Resource)new ClusterServiceVersionOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    public ClusterServiceVersion waitUntilCondition(OkHttpClient client, Config config, String namespace, ClusterServiceVersion item, Predicate<ClusterServiceVersion> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (ClusterServiceVersion)((Resource)new ClusterServiceVersionOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

