/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client;

import io.fabric8.kubernetes.api.model.RootPaths;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.ServiceToURLProvider;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.utils.URLFromServiceUtil;
import io.fabric8.openshift.api.model.Route;
import io.fabric8.openshift.client.OpenShiftClient;
import java.net.URL;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLFromOpenshiftRouteImpl
implements ServiceToURLProvider {
    public static final Logger logger = LoggerFactory.getLogger(URLFromOpenshiftRouteImpl.class);
    private final ConcurrentMap<URL, Boolean> IS_OPENSHIFT = new ConcurrentHashMap<URL, Boolean>();

    public String getURL(Service service, String portName, String namespace, KubernetesClient client) {
        block4: {
            String serviceName = service.getMetadata().getName();
            ServicePort port = URLFromServiceUtil.getServicePortByName((Service)service, (String)portName);
            if (port != null && port.getName() != null && this.isOpenShift(client)) {
                try {
                    String serviceProtocol = port.getProtocol();
                    OpenShiftClient openShiftClient = (OpenShiftClient)client.adapt(OpenShiftClient.class);
                    Route route = (Route)((Resource)((NonNamespaceOperation)openShiftClient.routes().inNamespace(namespace)).withName(service.getMetadata().getName())).get();
                    if (route != null) {
                        return (serviceProtocol + "://" + route.getSpec().getHost()).toLowerCase(Locale.ROOT);
                    }
                }
                catch (KubernetesClientException e) {
                    if (e.getCode() != 403) break block4;
                    logger.warn("Could not lookup route:" + serviceName + " in namespace:" + namespace + ", due to: " + e.getMessage());
                }
            }
        }
        return null;
    }

    public int getPriority() {
        return ServiceToURLProvider.ServiceToUrlImplPriority.FOURTH.getValue();
    }

    public boolean isOpenShift(KubernetesClient client) {
        List paths;
        URL masterUrl = client.getMasterUrl();
        if (this.IS_OPENSHIFT.containsKey(masterUrl)) {
            return (Boolean)this.IS_OPENSHIFT.get(masterUrl);
        }
        RootPaths rootPaths = client.rootPaths();
        if (rootPaths != null && (paths = rootPaths.getPaths()) != null) {
            for (String path : paths) {
                if (!Objects.equals("/oapi", path) && !Objects.equals("oapi", path)) continue;
                this.IS_OPENSHIFT.putIfAbsent(masterUrl, true);
                return true;
            }
        }
        this.IS_OPENSHIFT.putIfAbsent(masterUrl, false);
        return false;
    }
}

